/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import artofillusion.ui.Translate;
import java.awt.Point;

public class GainModule
extends ProceduralModule {
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    double value;
    double error;
    double valueIn;
    double errorIn;
    double gain;
    double power;
    double lastBlur;
    Vec3 gradient = new Vec3();
    static final double scale = 1.0 / Math.log(0.5);

    public GainModule(Point position) {
        super(Translate.text("menu.gainModule"), new IOPort[]{new IOPort(0, 0, 1, new String[]{"Gain", "(0.5)"}), new IOPort(0, 0, 2, new String[]{"Input", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    @Override
    public double getAverageValue(int which, double blur) {
        double sign;
        double v;
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        if (this.linkFrom[1] == null) {
            this.error = 0.0;
            this.value = 0.0;
            this.errorOk = true;
            return 0.0;
        }
        this.gain = this.linkFrom[0] == null ? 0.5 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.valueIn = this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        this.errorIn = this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        if (this.gain <= 0.0) {
            this.gain = 0.0;
            this.value = 0.5;
            this.error = 0.0;
            this.errorOk = true;
            return this.value;
        }
        if (this.valueIn < 0.0) {
            v = -this.valueIn;
            sign = -1.0;
        } else {
            v = this.valueIn;
            sign = 1.0;
        }
        if (this.gain >= 1.0) {
            this.gain = 1.0;
            this.value = sign * (v < 0.5 ? 0.0 : 1.0);
            this.error = 0.0;
            this.errorOk = true;
            return this.value;
        }
        this.power = Math.log(1.0 - this.gain) * scale;
        if (this.errorIn == 0.0) {
            this.value = v < 0.5 ? 1.0 - 0.5 * Math.pow(2.0 - 2.0 * v, this.power) : 0.5 * Math.pow(2.0 * v, this.power);
            this.error = 0.0;
            this.errorOk = true;
            return this.value;
        }
        this.value = (this.integral(this.valueIn + this.errorIn, this.power) - this.integral(this.valueIn - this.errorIn, this.power)) / (2.0 * this.errorIn);
        return this.value;
    }

    private double integral(double x, double y) {
        double d = y + 1.0;
        double sign = 1.0;
        if (x < 0.0) {
            x = -x;
            sign = -1.0;
        }
        if (x < 0.5) {
            return sign * (x + (Math.pow(2.0 - 2.0 * x, d) - Math.pow(2.0, d)) / (4.0 * d));
        }
        return sign * (0.5 + (Math.pow(2.0 * x, d) - Math.pow(2.0, d)) / (4.0 * d));
    }

    @Override
    public double getValueError(int which, double blur) {
        double v;
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.errorOk) {
            return this.error;
        }
        this.errorOk = true;
        if (this.errorIn == 0.0 || this.power == 0.0) {
            this.error = 0.0;
            return 0.0;
        }
        double d = v = this.valueIn < 0.0 ? -this.valueIn : this.valueIn;
        this.error = this.valueIn < 0.5 ? (this.error *= Math.abs(this.power * Math.pow(2.0 - 2.0 * v, this.power - 1.0))) : (this.error *= Math.abs(this.power * Math.pow(2.0 * v, this.power - 1.0)));
        return this.error;
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (this.linkFrom[1] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        this.gradOk = true;
        if (this.gain == 0.0 || this.gain == 1.0) {
            this.gradient.set(0.0, 0.0, 0.0);
        } else {
            double v;
            this.linkFrom[1].getValueGradient(this.linkFromIndex[1], this.gradient, blur);
            double d = v = this.valueIn < 0.0 ? -this.valueIn : this.valueIn;
            if (v < 0.5) {
                this.gradient.scale(this.power * Math.pow(2.0 - 2.0 * v, this.power - 1.0));
            } else {
                this.gradient.scale(this.power * Math.pow(2.0 * v, this.power - 1.0));
            }
        }
        grad.set(this.gradient);
    }
}

