/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.FastMath;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import java.awt.Point;

public class ModModule
extends ProceduralModule {
    double value;
    double error;
    double gradScale;
    double lastBlur;
    boolean valueOk;

    public ModModule(Point position) {
        super("Mod", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(0)"}), new IOPort(0, 0, 1, new String[]{"Modulus", "(1)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.valueOk = false;
    }

    @Override
    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        if (this.linkFrom[0] == null) {
            this.error = 0.0;
            this.value = 0.0;
            return 0.0;
        }
        this.value = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.error = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double m = this.linkFrom[1] == null ? 1.0 : Math.abs(this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur));
        double minv = 1.0 / m;
        if (this.error == 0.0) {
            this.value *= minv;
            this.value -= (double)FastMath.floor(this.value);
            this.value *= m;
            this.gradScale = 1.0;
        } else if (this.error >= 0.5 * m) {
            this.value = this.error = 0.5 * m;
            this.gradScale = 0.0;
        } else {
            this.value *= minv;
            this.error *= minv;
            double min = this.value - this.error;
            double max = this.value + this.error;
            min -= (double)FastMath.floor(min);
            if ((max -= (double)FastMath.floor(max)) > min) {
                this.value = 0.5 * (max + min);
                this.gradScale = 1.0;
            } else {
                this.value = (0.5 * max * max + 0.5 * (1.0 + min) * (1.0 - min)) / (1.0 - min + max);
                this.gradScale = (max - min) / (2.0 * this.error * m);
                this.error = 0.5;
            }
            this.value *= m;
            this.error *= m;
        }
        return this.value;
    }

    @Override
    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        grad.scale(this.gradScale);
    }
}

