/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.ArtOfIllusion;
import artofillusion.procedural.Module;
import artofillusion.procedural.NumberModule;
import artofillusion.procedural.debug;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

class ModuleLoader {
    ModuleLoader() {
    }

    public static Module createModule(String name) {
        Class moduleClass;
        try {
            moduleClass = ArtOfIllusion.getClass(name);
        }
        catch (ClassNotFoundException e) {
            debug.print("Couldn't get class for " + name + ": " + e);
            return ModuleLoader.dummy();
        }
        return ModuleLoader.createModule(moduleClass);
    }

    public static boolean moduleExists(String name) {
        try {
            ArtOfIllusion.getClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Module dummy() {
        return new NumberModule(new Point(), 0.1234567);
    }

    public static Module createModule(Class moduleClass) {
        Module mod;
        Constructor cons = null;
        try {
            Class[] parameterTypes = new Class[]{Point.class};
            cons = moduleClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            System.err.println("Couldn't get constructor for " + moduleClass.getName() + ": " + e);
            return ModuleLoader.dummy();
        }
        try {
            Object[] wrappedPoint = new Object[]{new Point()};
            mod = (Module)cons.newInstance(wrappedPoint);
        }
        catch (InvocationTargetException e) {
            System.err.println("Couldn't create a " + moduleClass.getName() + ": (InvocationTargetException)" + e.getTargetException());
            return ModuleLoader.dummy();
        }
        catch (Exception e) {
            System.err.println("Couldn't create a " + moduleClass.getName() + ": " + e);
            return ModuleLoader.dummy();
        }
        return mod;
    }
}

