/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.ProceduralModule;
import java.awt.Point;

public class OutputModule
extends ProceduralModule {
    int width;
    double defaultValue;
    RGBColor defaultColor;

    public OutputModule(String name, String defaultLabel, double defaultValue, RGBColor defaultColor, int type) {
        super(name, new IOPort[]{new IOPort(type, 0, 2, new String[]{name, "(" + defaultLabel + ")"})}, new IOPort[0], new Point(0, 0));
        this.defaultValue = defaultValue;
        this.defaultColor = defaultColor;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    @Override
    public void calcSize() {
        super.calcSize();
        if (this.width > 0) {
            this.bounds.width = this.width;
        }
    }

    @Override
    public double getAverageValue(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return this.defaultValue;
        }
        return this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        }
    }

    @Override
    public void getColor(int which, RGBColor color, double blur) {
        if (this.linkFrom[0] == null) {
            color.copy(this.defaultColor);
        } else {
            this.linkFrom[0].getColor(this.linkFromIndex[0], color, blur);
        }
    }
}

