/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.PluginRegistry;
import artofillusion.script.BeanshellScriptEngine;
import artofillusion.script.GroovyScriptEngine;
import artofillusion.script.ObjectScript;
import artofillusion.script.ScriptEngine;
import artofillusion.script.ScriptException;
import artofillusion.script.ScriptOutputWindow;
import artofillusion.script.ToolScript;
import artofillusion.util.SearchlistClassLoader;
import buoy.widget.BStandardDialog;
import java.io.PrintStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ScriptRunner {
    public static final String[] LANGUAGES = new String[]{"Groovy", "BeanShell"};
    private static SearchlistClassLoader parentLoader;
    private static PrintStream output;
    private static final HashMap<String, ScriptEngine> engines;
    private static final String[] IMPORTS;

    public static ScriptEngine getScriptEngine(String language) {
        if (!engines.containsKey(language)) {
            ScriptEngine engine;
            if (parentLoader == null) {
                parentLoader = new SearchlistClassLoader(ScriptRunner.class.getClassLoader());
                for (ClassLoader classLoader : PluginRegistry.getPluginClassLoaders()) {
                    parentLoader.add(classLoader);
                }
            }
            if (language.equals("Groovy")) {
                engine = new GroovyScriptEngine(parentLoader);
            } else if (language.equals("BeanShell")) {
                engine = new BeanshellScriptEngine(parentLoader);
            } else {
                throw new IllegalArgumentException("Unknown name for scripting language: " + language);
            }
            engines.put(language, engine);
            try {
                for (String packageName : IMPORTS) {
                    engine.addImport(packageName);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            output = new PrintStream(new ScriptOutputWindow());
            engine.setOutput(output);
        }
        return engines.get(language);
    }

    public static void executeScript(String language, String script, Map<String, Object> variables) {
        try {
            ScriptRunner.getScriptEngine(language).executeScript(script, variables);
        }
        catch (ScriptException e) {
            System.out.println("Error in line " + e.getLineNumber() + ": " + e.getMessage());
        }
    }

    public static ToolScript parseToolScript(String language, String script) throws Exception {
        return ScriptRunner.getScriptEngine(language).createToolScript(script);
    }

    public static ObjectScript parseObjectScript(String language, String script) throws Exception {
        return ScriptRunner.getScriptEngine(language).createObjectScript(script);
    }

    public static int displayError(String language, Exception ex) {
        if (ex instanceof UndeclaredThrowableException) {
            ex = (Exception)((UndeclaredThrowableException)ex).getUndeclaredThrowable();
        }
        String head = "An error occurred while executing the script:";
        String message = null;
        String errorText = null;
        String column = null;
        int line = -1;
        try {
            if (ex instanceof ScriptException) {
                ScriptException t = (ScriptException)ex;
                message = t.getMessage();
                if (t.getLineNumber() > -1) {
                    line = t.getLineNumber();
                }
                ex.printStackTrace(output);
            } else {
                message = ex.getMessage();
                ex.printStackTrace(output);
            }
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        ArrayList<String> v = new ArrayList<String>();
        v.add(head);
        if (message != null) {
            if (!message.contains("Inline eval of")) {
                v.add(message);
            } else {
                int j;
                int i = message.lastIndexOf("> Encountered");
                if (i > -1 && (j = message.lastIndexOf(", column")) > i) {
                    column = message.substring(j);
                }
            }
        }
        if (line > -1 && errorText != null) {
            if (column == null) {
                v.add("Encountered \"" + errorText + "\" at line " + line + ".");
            } else {
                v.add("Encountered \"" + errorText + "\" at line " + line + column);
            }
        }
        String[] msg = v.toArray(new String[v.size()]);
        new BStandardDialog("Error", msg, BStandardDialog.ERROR).showMessageDialog(null);
        return line;
    }

    public static String getLanguageForFilename(String filename) {
        for (String language : LANGUAGES) {
            if (!filename.endsWith("." + ScriptRunner.getScriptEngine(language).getFilenameExtension())) continue;
            return language;
        }
        throw new IllegalArgumentException("Filename \"" + filename + "\" does not match any recognized scripting language.");
    }

    public static String getFilenameExtension(String language) {
        return ScriptRunner.getScriptEngine(language).getFilenameExtension();
    }

    static {
        engines = new HashMap();
        IMPORTS = new String[]{"artofillusion.*", "artofillusion.image.*", "artofillusion.material.*", "artofillusion.math.*", "artofillusion.object.*", "artofillusion.script.*", "artofillusion.texture.*", "artofillusion.ui.*", "buoy.event.*", "buoy.widget.*"};
    }
}

