/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.widget.BScrollPane;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class AutoScroller
implements Runnable {
    protected BScrollPane sp;
    protected Thread scrollThread;
    protected int x;
    protected int y;
    protected int xinc;
    protected int yinc;
    protected int delay;

    public AutoScroller(BScrollPane pane, int xincrement, int yincrement) {
        this.xinc = xincrement;
        this.yinc = yincrement;
        this.sp = pane;
        pane.getContent().addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        pane.getContent().addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        pane.getContent().addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.delay = 100;
    }

    private void mousePressed(MousePressedEvent ev) {
        this.x = ev.getX();
        this.y = ev.getY();
        if (this.scrollThread == null) {
            this.scrollThread = new Thread(this);
            this.scrollThread.start();
        }
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        this.scrollThread.interrupt();
        this.scrollThread = null;
    }

    private void mouseDragged(MouseDraggedEvent ev) {
        this.x = ev.getX();
        this.y = ev.getY();
    }

    @Override
    public void run() {
        while (true) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dimension scrollSize = AutoScroller.this.sp.getViewSize();
                    Point scrollPos = new Point(AutoScroller.this.sp.getHorizontalScrollBar().getValue(), AutoScroller.this.sp.getVerticalScrollBar().getValue());
                    if (AutoScroller.this.x < scrollPos.x || AutoScroller.this.y < scrollPos.y || AutoScroller.this.x > scrollPos.x + scrollSize.width || AutoScroller.this.y > scrollPos.y + scrollSize.height) {
                        AutoScroller.this.scrollWhileDragging(scrollSize, scrollPos);
                    }
                }
            });
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    protected void scrollWhileDragging(Dimension scrollSize, Point scrollPos) {
        Point newPos = scrollPos;
        if (this.x < scrollPos.x) {
            newPos.x -= this.xinc;
        }
        if (this.y < scrollPos.y) {
            newPos.y -= this.yinc;
        }
        if (this.x > scrollPos.x + scrollSize.width) {
            newPos.x += this.xinc;
        }
        if (this.y > scrollPos.y + scrollSize.height) {
            newPos.y += this.yinc;
        }
        this.sp.getHorizontalScrollBar().setValue(newPos.x);
        this.sp.getVerticalScrollBar().setValue(newPos.y);
        this.x += newPos.x - scrollPos.x;
        this.y += newPos.y - scrollPos.y;
    }
}

