/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ViewerCanvas;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.ToolButton;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseScrolledEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BFrame;

public abstract class EditingTool {
    protected EditingWindow theWindow;
    protected BFrame theFrame;
    protected ToolButton button;
    public static final int ALL_CLICKS = 1;
    public static final int OBJECT_CLICKS = 2;
    public static final int HANDLE_CLICKS = 4;

    public EditingTool(EditingWindow win) {
        this.theWindow = win;
        if (win != null) {
            this.theFrame = win.getFrame();
        }
    }

    public EditingWindow getWindow() {
        return this.theWindow;
    }

    public ToolButton getButton() {
        return this.button;
    }

    protected void initButton(String name) {
        this.button = ThemeManager.getToolButton(this, name);
    }

    public String getToolTipText() {
        return null;
    }

    public int whichClicks() {
        return 1;
    }

    public boolean allowSelectionChanges() {
        int clicks = this.whichClicks();
        return (clicks & 2) != 0 || (clicks & 4) != 0;
    }

    public boolean hilightSelection() {
        return true;
    }

    public void drawOverlay(ViewerCanvas view) {
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void mousePressedOnObject(WidgetMouseEvent e, ViewerCanvas view, int obj) {
    }

    public void mousePressedOnHandle(WidgetMouseEvent e, ViewerCanvas view, int obj, int handle) {
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void mouseMoved(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void mouseScrolled(MouseScrolledEvent e, ViewerCanvas view) {
    }

    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
    }

    public void activate() {
        this.theWindow.setTool(this);
        this.button.setSelected(true);
    }

    public void deactivate() {
        this.button.setSelected(false);
    }

    public boolean isEditable() {
        return false;
    }

    public void iconDoubleClicked() {
    }
}

