/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.awt.Insets;

public class MessageDialog
extends BDialog {
    private int pressed;
    private int i;
    private int number;

    public MessageDialog(WindowWidget parent, String message) {
        this(parent, UIUtilities.breakString(message));
    }

    public MessageDialog(WindowWidget parent, String message, String[] choices) {
        this(parent, UIUtilities.breakString(message), choices);
    }

    public MessageDialog(WindowWidget parent, String[] message) {
        this(parent, message, new String[]{Translate.text("button.ok")});
    }

    public MessageDialog(WindowWidget parent, String[] message, String[] choices) {
        super(parent, true);
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(10, 10, 10, 10), null));
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH);
        this.i = 0;
        while (this.i < choices.length) {
            BButton btn = new BButton(choices[this.i]);
            btn.addEventLink(CommandEvent.class, new Object(){
                int number;
                {
                    this.number = MessageDialog.this.i;
                }

                void processEvent() {
                    MessageDialog.this.pressed = this.number;
                    MessageDialog.this.dispose();
                }
            });
            buttons.add(btn);
            btn.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
            ++this.i;
        }
        ColumnContainer msg = new ColumnContainer();
        content.add(msg, BorderContainer.CENTER);
        this.i = 0;
        while (this.i < message.length) {
            msg.add(new BLabel(message[this.i]));
            ++this.i;
        }
        this.number = choices.length;
        this.addEventLink(WindowClosingEvent.class, new Object(){

            void processEvent() {
                MessageDialog.this.pressed = MessageDialog.this.number - 1;
                MessageDialog.this.dispose();
            }
        });
        this.pack();
        this.setResizable(false);
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    public int getChoice() {
        return this.pressed;
    }

    private void keyPressed(KeyPressedEvent ev) {
        if (ev.getKeyCode() == 27) {
            this.pressed = this.number - 1;
        } else if (ev.getKeyCode() == 10) {
            this.pressed = 0;
        } else {
            return;
        }
        this.dispose();
    }
}

