/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.animation.Track;
import artofillusion.animation.TrackTreeElement;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import java.util.Vector;
import javax.swing.Icon;

public class ObjectTreeElement
extends TreeElement {
    protected ObjectInfo info;
    private static Icon lockIcon = ThemeManager.getIcon("lock");

    public ObjectTreeElement(ObjectInfo info, TreeList tree) {
        this(info, null, tree, true);
    }

    public ObjectTreeElement(ObjectInfo info, TreeElement parent, TreeList tree, boolean addChildren) {
        this.info = info;
        this.parent = parent;
        this.tree = tree;
        this.children = new Vector();
        if (addChildren) {
            for (int i = 0; i < info.getChildren().length; ++i) {
                this.children.add(new ObjectTreeElement(info.getChildren()[i], this, tree, true));
            }
        }
    }

    @Override
    public String getLabel() {
        return this.info.getName();
    }

    @Override
    public Icon getIcon() {
        return this.info.isLocked() ? lockIcon : null;
    }

    @Override
    public boolean canAcceptAsParent(TreeElement el) {
        if (el == null) {
            return true;
        }
        if (!(el instanceof ObjectTreeElement)) {
            return false;
        }
        for (ObjectInfo i = ((ObjectTreeElement)el).info; i != null; i = i.getParent()) {
            if (i != this.info) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addChild(TreeElement el, int position) {
        this.children.add(position, el);
        el.parent = this;
        if (el.getObject() instanceof ObjectInfo) {
            if (this.tree.undo != null) {
                this.tree.undo.addCommandAtBeginning(8, new Object[]{this.info, el.getObject()});
            }
            this.info.addChild((ObjectInfo)el.getObject(), position);
        } else if (el.getObject() instanceof Track) {
            Track tr = (Track)el.getObject();
            this.info.addTrack(tr, position);
            tr.setParent(this.info);
        }
    }

    @Override
    public void removeChild(Object object) {
        int pos;
        TreeElement el = null;
        for (pos = 0; pos < this.children.size() && (el = (TreeElement)this.children.get(pos)).getObject() != object; ++pos) {
        }
        if (pos == this.children.size()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((TreeElement)this.children.get(i)).removeChild(object);
            }
            return;
        }
        el.parent = null;
        this.children.remove(pos);
        if (object instanceof Track) {
            this.info.removeTrack((Track)object);
            return;
        }
        this.info.removeChild((ObjectInfo)object);
        if (this.tree.undo != null) {
            this.tree.undo.addCommandAtBeginning(7, new Object[]{this.info, object, pos});
        }
    }

    @Override
    public Object getObject() {
        return this.info;
    }

    @Override
    public boolean isGray() {
        return !this.info.isVisible();
    }

    public void addTracks() {
        for (int i = 0; i < this.info.getTracks().length; ++i) {
            TrackTreeElement el = new TrackTreeElement(this.info.getTracks()[i], this, this.tree);
            this.children.add(i, el);
        }
    }
}

