/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.SceneViewer;
import artofillusion.ViewerCanvas;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.Translate;
import artofillusion.view.ViewChangedEvent;
import artofillusion.view.ViewerControl;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.Widget;

public class ViewerOrientationControl
implements ViewerControl {
    @Override
    public Widget createWidget(ViewerCanvas view) {
        return new OrientationChoice(view);
    }

    @Override
    public String getName() {
        return Translate.text("ViewDirection");
    }

    public static class OrientationChoice
    extends BComboBox {
        private final ViewerCanvas view;

        private OrientationChoice(ViewerCanvas view) {
            super(new String[]{Translate.text("Front"), Translate.text("Back"), Translate.text("Left"), Translate.text("Right"), Translate.text("Top"), Translate.text("Bottom"), Translate.text("Other")});
            this.view = view;
            if (view instanceof SceneViewer) {
                this.rebuildCameraList();
            }
            this.setSelectedIndex(0);
            view.addEventLink(ViewChangedEvent.class, (Object)this, "viewChanged");
            this.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
            this.setPreferredVisibleRows(20);
        }

        private void viewChanged() {
            if (this.view.getOrientation() != this.getSelectedIndex()) {
                if (this.view.getOrientation() < this.getItemCount()) {
                    this.setSelectedIndex(this.view.getOrientation());
                } else {
                    this.setSelectedIndex(this.getItemCount() - 1);
                }
            }
        }

        private void valueChanged() {
            if (this.getSelectedIndex() != this.view.getOrientation()) {
                this.view.setOrientation(this.getSelectedIndex());
            }
        }

        public void rebuildCameraList() {
            int i = this.getItemCount() - 2;
            int selected = this.getSelectedIndex();
            while (i > 5) {
                this.remove(i--);
            }
            ObjectInfo[] cameras = ((SceneViewer)this.view).getCameras();
            for (i = 0; i < cameras.length; ++i) {
                this.add(this.getItemCount() - 1, new listName(cameras[i].getName()));
                if (cameras[i] == this.view.getBoundCamera()) {
                    selected = this.getItemCount() - 2;
                    continue;
                }
                if (selected != this.getItemCount() - 2) continue;
                selected = Integer.MAX_VALUE;
            }
            if (selected < this.getItemCount()) {
                this.setSelectedIndex(selected);
            } else {
                this.setSelectedIndex(this.getItemCount() - 1);
            }
            if (this.getParent() != null) {
                this.getParent().layoutChildren();
            }
        }

        private class listName {
            private final String name;

            private listName(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

