/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Sphere;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTEllipsoid
extends RTObject {
    Sphere theSphere;
    double rx;
    double ry;
    double rz;
    double rx2;
    double ry2;
    double rz2;
    double cx;
    double cy;
    double cz;
    double sy;
    double sz;
    double[] param;
    boolean bumpMapped;
    boolean transform;
    boolean uniform;
    Mat4 toLocal;
    Mat4 fromLocal;
    public static final double TOL = 1.0E-12;

    public RTEllipsoid(Sphere sphere, Mat4 fromLocal, Mat4 toLocal, double[] param) {
        Vec3 radii = sphere.getRadii();
        Vec3 vx = toLocal.timesDirection(Vec3.vx());
        Vec3 vy = toLocal.timesDirection(Vec3.vy());
        this.theSphere = sphere;
        this.param = param;
        this.uniform = sphere.getTextureMapping() instanceof UniformMapping;
        this.transform = true;
        if (vx.x == 1.0 || vx.x == -1.0) {
            if (vy.y == 1.0 || vy.y == -1.0) {
                this.rx = radii.x;
                this.ry = radii.y;
                this.rz = radii.z;
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                this.rx = radii.x;
                this.ry = radii.z;
                this.rz = radii.y;
                this.transform = false;
            }
        } else if (vx.y == 1.0 || vx.y == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                this.rx = radii.y;
                this.ry = radii.x;
                this.rz = radii.z;
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                this.rx = radii.y;
                this.ry = radii.z;
                this.rz = radii.x;
                this.transform = false;
            }
        } else if (vx.z == 1.0 || vx.z == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                this.rx = radii.z;
                this.ry = radii.x;
                this.rz = radii.y;
                this.transform = false;
            } else if (vy.y == 1.0 || vy.y == -1.0) {
                this.rx = radii.z;
                this.ry = radii.y;
                this.rz = radii.x;
                this.transform = false;
            }
        }
        if (this.transform) {
            this.rx = radii.x;
            this.ry = radii.y;
            this.rz = radii.z;
            this.fromLocal = fromLocal;
        }
        this.cx = fromLocal.m14 / fromLocal.m44;
        this.cy = fromLocal.m24 / fromLocal.m44;
        this.cz = fromLocal.m34 / fromLocal.m44;
        this.rx2 = this.rx * this.rx;
        this.ry2 = this.ry * this.ry;
        this.rz2 = this.rz * this.rz;
        this.sy = this.rx2 / this.ry2;
        this.sz = this.rx2 / this.rz2;
        this.bumpMapped = sphere.getTexture().hasComponent(5);
        this.toLocal = toLocal;
    }

    @Override
    public final TextureMapping getTextureMapping() {
        return this.theSphere.getTextureMapping();
    }

    @Override
    public final MaterialMapping getMaterialMapping() {
        return this.theSphere.getMaterialMapping();
    }

    @Override
    public SurfaceIntersection checkIntersection(Ray r) {
        double dist1;
        int numIntersections;
        Vec3 orig = r.getOrigin();
        Vec3 rdir = r.getDirection();
        Vec3 v1 = r.tempVec1;
        Vec3 v2 = r.tempVec2;
        Vec3 dir = r.tempVec3;
        double dist2 = 0.0;
        v1.set(this.cx - orig.x, this.cy - orig.y, this.cz - orig.z);
        if (this.transform) {
            this.toLocal.transformDirection(v1);
            dir.set(rdir);
            this.toLocal.transformDirection(dir);
        } else if (this.uniform) {
            dir = rdir;
        } else {
            dir.set(rdir);
        }
        double temp1 = this.sy * dir.y;
        double temp2 = this.sz * dir.z;
        double b = dir.x * v1.x + temp1 * v1.y + temp2 * v1.z;
        double c = v1.x * v1.x + this.sy * v1.y * v1.y + this.sz * v1.z * v1.z - this.rx2;
        if (c > 1.0E-12 * b) {
            if (b <= 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            double a = dir.x * dir.x + temp1 * dir.y + temp2 * dir.z;
            double d = b * b - a * c;
            if (d < 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            numIntersections = 2;
            temp1 = Math.sqrt(d);
            dist1 = (b - temp1) / a;
            dist2 = (b + temp1) / a;
            v2.set(orig.x + dist2 * dir.x, orig.y + dist2 * dir.y, orig.z + dist2 * dir.z);
            this.projectPoint(v2);
        } else if (c < -1.0E-12 * b) {
            double a = dir.x * dir.x + temp1 * dir.y + temp2 * dir.z;
            double d = b * b - a * c;
            if (d < 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            numIntersections = 1;
            dist1 = (b + Math.sqrt(d)) / a;
        } else {
            if (b <= 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            double a = dir.x * dir.x + temp1 * dir.y + temp2 * dir.z;
            double d = b * b - a * c;
            if (d < 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            numIntersections = 1;
            dist1 = (b + Math.sqrt(d)) / a;
        }
        v1.set(orig.x + dist1 * rdir.x, orig.y + dist1 * rdir.y, orig.z + dist1 * rdir.z);
        this.projectPoint(v1);
        return new EllipsoidIntersection(this, numIntersections, v1, v2, dist1, dist2);
    }

    private void projectPoint(Vec3 pos) {
        if (this.transform) {
            this.toLocal.transform(pos);
            double scale = this.rx / Math.sqrt(pos.x * pos.x + this.sy * pos.y * pos.y + this.sz * pos.z * pos.z);
            pos.scale(scale);
            this.fromLocal.transform(pos);
        } else {
            double dx = pos.x - this.cx;
            double dy = pos.y - this.cy;
            double dz = pos.z - this.cz;
            double scale = this.rx / Math.sqrt(dx * dx + this.sy * dy * dy + this.sz * dz * dz);
            pos.set(this.cx + dx * scale, this.cy + dy * scale, this.cz + dz * scale);
        }
    }

    @Override
    public BoundingBox getBounds() {
        if (this.transform) {
            return new BoundingBox(-this.rx, this.rx, -this.ry, this.ry, -this.rz, this.rz).transformAndOutset(this.fromLocal);
        }
        return new BoundingBox(this.cx - this.rx, this.cx + this.rx, this.cy - this.ry, this.cy + this.ry, this.cz - this.rz, this.cz + this.rz);
    }

    @Override
    public boolean intersectsNode(OctreeNode node) {
        double centerx;
        double centery;
        double centerz;
        BoundingBox bb = node.getBounds();
        if (this.transform) {
            bb = bb.transformAndOutset(this.toLocal);
            centerz = 0.0;
            centery = 0.0;
            centerx = 0.0;
        } else {
            centerx = this.cx;
            centery = this.cy;
            centerz = this.cz;
        }
        Vec3 c = new Vec3(centerx, centery, centerz);
        if (centerx < bb.minx) {
            c.x = bb.minx;
        } else if (centerx > bb.maxx) {
            c.x = bb.maxx;
        }
        if (centery < bb.miny) {
            c.y = bb.miny;
        } else if (centery > bb.maxy) {
            c.y = bb.maxy;
        }
        if (centerz < bb.minz) {
            c.z = bb.minz;
        } else if (centerz > bb.maxz) {
            c.z = bb.maxz;
        }
        if (!this.transform) {
            c.set(c.x - centerx, c.y - centery, c.z - centerz);
        }
        if (c.x * c.x + c.y * c.y * this.sy + c.z * c.z * this.sz > this.rx2) {
            return false;
        }
        double dx = 1.0 / this.rx;
        double dy = 1.0 / this.ry;
        double dz = 1.0 / this.rz;
        c.set((bb.minx - centerx) * dx, (bb.miny - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.minx - centerx) * dx, (bb.miny - centery) * dy, (bb.maxz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.minx - centerx) * dx, (bb.maxy - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.minx - centerx) * dx, (bb.maxy - centery) * dy, (bb.maxz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.miny - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.miny - centery) * dy, (bb.maxz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.maxy - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.maxy - centery) * dy, (bb.maxz - centerz) * dz);
        return c.length2() > 1.0;
    }

    @Override
    public Mat4 toLocal() {
        return this.toLocal;
    }

    private static class EllipsoidIntersection
    implements SurfaceIntersection {
        private RTEllipsoid ellipse;
        private int numIntersections;
        private double dist1;
        private double dist2;
        private double r1x;
        private double r1y;
        private double r1z;
        private double r2x;
        private double r2y;
        private double r2z;
        private boolean trueNormValid;
        private Vec3 trueNorm;
        private Vec3 pos;

        public EllipsoidIntersection(RTEllipsoid ellipse, int numIntersections, Vec3 point1, Vec3 point2, double dist1, double dist2) {
            this.ellipse = ellipse;
            this.numIntersections = numIntersections;
            this.dist1 = dist1;
            this.dist2 = dist2;
            this.r1x = point1.x;
            this.r1y = point1.y;
            this.r1z = point1.z;
            this.r2x = point2.x;
            this.r2y = point2.y;
            this.r2z = point2.z;
            this.trueNorm = new Vec3();
            this.pos = new Vec3();
        }

        @Override
        public RTObject getObject() {
            return this.ellipse;
        }

        @Override
        public int numIntersections() {
            return this.numIntersections;
        }

        @Override
        public void intersectionPoint(int n, Vec3 p) {
            if (n == 0) {
                p.set(this.r1x, this.r1y, this.r1z);
            } else {
                p.set(this.r2x, this.r2y, this.r2z);
            }
        }

        @Override
        public double intersectionDist(int n) {
            if (n == 0) {
                return this.dist1;
            }
            return this.dist2;
        }

        @Override
        public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size, double time) {
            this.calcTrueNorm();
            n.set(this.trueNorm);
            TextureMapping map = this.ellipse.theSphere.getTextureMapping();
            this.pos.set(this.r1x, this.r1y, this.r1z);
            if (map instanceof UniformMapping) {
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.ellipse.param);
            } else {
                this.ellipse.toLocal.transform(this.pos);
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.ellipse.param);
            }
            if (this.ellipse.bumpMapped) {
                if (this.ellipse.transform) {
                    this.ellipse.fromLocal.transformDirection(spec.bumpGrad);
                }
                n.scale(spec.bumpGrad.dot(n) + 1.0);
                n.subtract(spec.bumpGrad);
                n.normalize();
            }
        }

        @Override
        public void intersectionTransparency(int n, RGBColor trans, double angle, double size, double time) {
            TextureMapping map = this.ellipse.theSphere.getTextureMapping();
            if (n == 0) {
                this.pos.set(this.r1x, this.r1y, this.r1z);
            } else {
                this.pos.set(this.r2x, this.r2y, this.r2z);
            }
            if (map instanceof UniformMapping) {
                map.getTransparency(this.pos, trans, angle, size, time, this.ellipse.param);
            } else {
                this.ellipse.toLocal.transform(this.pos);
                map.getTransparency(this.pos, trans, angle, size, time, this.ellipse.param);
            }
        }

        @Override
        public void trueNormal(Vec3 n) {
            this.calcTrueNorm();
            n.set(this.trueNorm);
        }

        private void calcTrueNorm() {
            if (this.trueNormValid) {
                return;
            }
            this.trueNormValid = true;
            if (this.ellipse.transform) {
                this.trueNorm.set(this.r1x - this.ellipse.cx, this.r1y - this.ellipse.cy, this.r1z - this.ellipse.cz);
                this.ellipse.toLocal.transformDirection(this.trueNorm);
                this.trueNorm.set(this.trueNorm.x, this.trueNorm.y * this.ellipse.sy, this.trueNorm.z * this.ellipse.sz);
                this.ellipse.fromLocal.transformDirection(this.trueNorm);
            } else {
                this.trueNorm.set(this.r1x - this.ellipse.cx, (this.r1y - this.ellipse.cy) * this.ellipse.sy, (this.r1z - this.ellipse.cz) * this.ellipse.sz);
            }
            this.trueNorm.normalize();
        }
    }
}

