/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.exception;

import net.disy.commons.core.exception.IExceptionHandler;
import net.disy.commons.core.exception.InternalAwtExceptionHandler;

public class CentralExceptionHandling {
    private static final CentralExceptionHandling instance = new CentralExceptionHandling();
    private IExceptionHandler handler;

    private CentralExceptionHandling() {
        this.attachForEventDispatchExceptionHandling();
        this.attachForThreadUncaughtExceptionHandling();
    }

    private void attachForThreadUncaughtExceptionHandling() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                CentralExceptionHandling.this.handle(e);
            }
        });
    }

    public IExceptionHandler getHandler() {
        return this.handler;
    }

    public static void setHandler(IExceptionHandler handler) {
        CentralExceptionHandling.getInstance().handler = handler;
    }

    public static CentralExceptionHandling getInstance() {
        return instance;
    }

    public void handle(Throwable exception) {
        if (this.handler != null) {
            this.handler.handle(exception);
        } else {
            System.err.println("Exception occurred during event dispatching:");
            exception.printStackTrace();
        }
    }

    private void attachForEventDispatchExceptionHandling() {
        System.setProperty("sun.awt.exception.handler", InternalAwtExceptionHandler.class.getName());
    }

    @Deprecated
    public static ThreadGroup createThreadGroup(String name) {
        return new ThreadGroup(name);
    }

    @Deprecated
    public static ThreadGroup createThreadGroup() {
        return CentralExceptionHandling.createThreadGroup("ExceptionHandlingThreadGroup");
    }
}

