/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.model;

import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.model.listener.ListenerList;
import net.disy.commons.core.model.listener.NotifyChangeListenerClosure;

public abstract class AbstractChangeableModel
implements Cloneable,
IChangeableModel {
    private transient ListenerList<IChangeListener> listeners = new ListenerList();

    protected Object clone() {
        try {
            AbstractChangeableModel clone = (AbstractChangeableModel)super.clone();
            clone.listeners = new ListenerList();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnreachableCodeReachedException(e);
        }
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChangeEvent() {
        this.listeners.forAllDo(NotifyChangeListenerClosure.getInstance());
    }

    public int getChangeListenerCount() {
        return this.listeners.getSize();
    }

    protected final Object getMutex() {
        return this.listeners;
    }

    public final void clearListenerList() {
        this.listeners.clear();
    }
}

