/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.number;

import net.disy.commons.core.number.IDoubleValueAddable;

public class MinMaxDoubleValueBuilder
implements IDoubleValueAddable {
    private double minValue = Double.NaN;
    private double maxValue = Double.NaN;

    public double getMaximum(double fallBackValue) {
        if (Double.isNaN(this.maxValue)) {
            return fallBackValue;
        }
        return this.maxValue;
    }

    public double getMinimum(double fallBackValue) {
        if (Double.isNaN(this.minValue)) {
            return fallBackValue;
        }
        return this.minValue;
    }

    @Override
    public void add(double value) {
        this.minValue = value < this.minValue || Double.isNaN(this.minValue) ? value : this.minValue;
        this.maxValue = value > this.maxValue || Double.isNaN(this.maxValue) ? value : this.maxValue;
    }
}

