/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.disy.commons.core.predicate.IPredicate;
import net.disy.commons.core.string.StringConcatenationBuilder;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.IClosure;
import net.disy.commons.core.util.IKeyProvider;
import net.disy.commons.core.util.ITransformer;
import net.disy.commons.core.util.ObjectUtilities;
import net.disy.commons.core.util.Range;

public class ArrayUtilities {
    public static <T> T[] filter(T[] array, IPredicate<T> predicate) {
        ArrayList<T> selected = new ArrayList<T>();
        for (T element : array) {
            if (!predicate.evaluate(element)) continue;
            selected.add(element);
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), selected.size());
        return selected.toArray(newArray);
    }

    public static <T, E extends Exception> T getSingleRequired(T[] array, IPredicate<T> predicate, E e) throws E {
        T[] found = ArrayUtilities.filter(array, predicate);
        if (found.length != 1) {
            throw e;
        }
        return found[0];
    }

    public static <T> void forAllDo(T[] array, IClosure<T> closure) {
        for (T element : array) {
            closure.execute(element);
        }
    }

    @Deprecated
    public static <T> T[] concat(T[] array1, T ... array2) {
        if (array2 == null) {
            return array1;
        }
        if (array1 == null) {
            return array2;
        }
        Class<?> componentType1 = array1.getClass().getComponentType();
        Class<?> componentType2 = array2.getClass().getComponentType();
        Class<?> mergedType = ArrayUtilities.getSharedSuperType(componentType1, componentType2);
        Object[] mergedArray = (Object[])Array.newInstance(mergedType, array1.length + array2.length);
        System.arraycopy(array1, 0, mergedArray, 0, array1.length);
        System.arraycopy(array2, 0, mergedArray, array1.length, array2.length);
        return mergedArray;
    }

    public static Class<?> getSharedSuperType(Class<?> componentType1, Class<?> componentType2) {
        if (componentType1.isAssignableFrom(componentType2)) {
            return componentType1;
        }
        if (componentType2.isAssignableFrom(componentType1)) {
            return componentType2;
        }
        return ArrayUtilities.getSharedSuperType(componentType1.getSuperclass(), componentType2);
    }

    public static <T> T[] concat(T object, T[] array2, Class<T> clazz) {
        Object[] array1 = (Object[])Array.newInstance(clazz, 1);
        array1[0] = object;
        return ArrayUtilities.concat(clazz, array1, array2);
    }

    public static <T> T[] concat(Class<T> clazz, T[] array1, T ... array2) {
        if (array2 == null) {
            return array1;
        }
        if (array1 == null) {
            return array2;
        }
        Object[] mergedArray = (Object[])Array.newInstance(clazz, array1.length + array2.length);
        System.arraycopy(array1, 0, mergedArray, 0, array1.length);
        System.arraycopy(array2, 0, mergedArray, array1.length, array2.length);
        return mergedArray;
    }

    public static <T, U> Map<T, U> createMap(U[] objects, IKeyProvider<T, U> keyProvider) {
        HashMap<T, U> map = new HashMap<T, U>();
        for (U object : objects) {
            map.put(keyProvider.getKey(object), object);
        }
        return map;
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        for (int value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        int[] intArray = new int[integerArray.length];
        for (int index = 0; index < intArray.length; ++index) {
            intArray[index] = integerArray[index];
        }
        return intArray;
    }

    public static long[] toPrimitive(Long[] longs) {
        long[] longArray = new long[longs.length];
        for (int index = 0; index < longArray.length; ++index) {
            longArray[index] = longs[index];
        }
        return longArray;
    }

    public static double[] toPrimitive(Double[] doubles) {
        double[] doubleArray = new double[doubles.length];
        for (int index = 0; index < doubleArray.length; ++index) {
            doubleArray[index] = doubles[index];
        }
        return doubleArray;
    }

    public static char[] toPrimitive(Character[] characterArray) {
        char[] charArray = new char[characterArray.length];
        for (int index = 0; index < charArray.length; ++index) {
            charArray[index] = characterArray[index].charValue();
        }
        return charArray;
    }

    public static <T> boolean containsValue(T[] array, final T value) {
        return ArrayUtilities.contains(array, new IPredicate<T>(){

            @Override
            public boolean evaluate(T actualValue) {
                return ObjectUtilities.equals(value, actualValue);
            }
        });
    }

    public static <T> boolean contains(T[] array, IPredicate<T> predicate) {
        for (T element : array) {
            if (!predicate.evaluate(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> int[] getIndices(T[] values, T[] allValues) {
        int[] indices = new int[values.length];
        List<T> allValuesList = Arrays.asList(allValues);
        for (int i = 0; i < values.length; ++i) {
            indices[i] = allValuesList.indexOf(values[i]);
        }
        return indices;
    }

    public static <T> T getFirst(T[] array, IPredicate<T> predicate) {
        T notFoundValue = null;
        return ArrayUtilities.getFirst(array, predicate, notFoundValue);
    }

    public static <T> T getFirst(T[] array, IPredicate<T> predicate, T notFoundValue) {
        for (T element : array) {
            if (!predicate.evaluate(element)) continue;
            return element;
        }
        return notFoundValue;
    }

    public static <I, O> O[] transform(I[] array, Class clazz, ITransformer<I, O> transformer) {
        Object[] transformed = (Object[])Array.newInstance(clazz, array.length);
        for (int i = 0; i < array.length; ++i) {
            transformed[i] = transformer.transform(array[i]);
        }
        return transformed;
    }

    public static <I, O> O[] transform(I[] array, Class<O> clazz) {
        return ArrayUtilities.transform(array, clazz, new ITransformer<I, O>(){

            @Override
            public O transform(I input) {
                return input;
            }
        });
    }

    public static int indexOf(byte[] buffer, int value) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <T> int[] indicesOf(T[] values, IPredicate<T> predicate) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            if (!predicate.evaluate(values[i])) continue;
            indices.add(new Integer(i));
        }
        int[] intIndices = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            intIndices[i] = (Integer)indices.get(i);
        }
        return intIndices;
    }

    public static String[] toStrings(int[] values) {
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strings[i] = String.valueOf(values[i]);
        }
        return strings;
    }

    public static String[] toStrings(long[] values) {
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strings[i] = String.valueOf(values[i]);
        }
        return strings;
    }

    public static <T> int indexOf(T[] values, IPredicate<T> predicate) {
        for (int i = 0; i < values.length; ++i) {
            if (!predicate.evaluate(values[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] subArray(T[] array, int startIndex) {
        Ensure.ensureArgumentIndexInBounds(startIndex, new Range(0, array.length));
        int newLength = array.length - startIndex;
        Object[] subArray = (Object[])Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, startIndex, subArray, 0, newLength);
        return subArray;
    }

    public static <T> T[] subArray(T[] array, int startIndex, int endIndex) {
        Ensure.ensureArgumentIndexInBounds(startIndex, new Range(0, array.length));
        Ensure.ensureArgumentIndexInBounds(endIndex, new Range(0, array.length));
        Ensure.ensureTrue("EndIndex must be at least startIndex.", endIndex >= startIndex);
        int newLength = endIndex - startIndex;
        Object[] subArray = (Object[])Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, startIndex, subArray, 0, newLength);
        return subArray;
    }

    public static <T> T getFirstIfAny(T[] values) {
        return values.length == 0 ? null : (T)values[0];
    }

    public static <T> T[] reverse(T[] values) {
        Object[] revertedValues = (Object[])Array.newInstance(values.getClass().getComponentType(), values.length);
        for (int i = 0; i < revertedValues.length; ++i) {
            revertedValues[i] = values[values.length - i - 1];
        }
        return revertedValues;
    }

    public static String getRepresentation(long[] array) {
        return ArrayUtilities.getRepresentation(array, "[", ",", "]");
    }

    public static String getRepresentation(Object[] array) {
        return ArrayUtilities.getRepresentation(array, "[", ",", "]");
    }

    public static String getRepresentation(Object[] array, String separator) {
        return ArrayUtilities.getRepresentation(array, "", separator, "");
    }

    public static String getRepresentation(long[] array, String prefix, String separator, String postfix) {
        if (array == null) {
            return null;
        }
        StringConcatenationBuilder builder = new StringConcatenationBuilder(separator);
        for (long value : array) {
            builder.append(String.valueOf(value));
        }
        return prefix + builder.getString() + postfix;
    }

    public static String getRepresentation(Object[] array, String prefix, String separator, String postfix) {
        if (array == null) {
            return null;
        }
        StringConcatenationBuilder builder = new StringConcatenationBuilder(separator);
        for (Object value : array) {
            if (value instanceof Object[]) {
                builder.append(ArrayUtilities.getRepresentation((Object[])value));
                continue;
            }
            builder.append(String.valueOf(value));
        }
        return prefix + builder.getString() + postfix;
    }

    public static <T, U extends T> U[] filterClass(T[] array, final Class<U> clazz) {
        T[] filteredArray = ArrayUtilities.filter(array, new IPredicate<T>(){

            @Override
            public boolean evaluate(T object) {
                return clazz.isAssignableFrom(object.getClass());
            }
        });
        return ArrayUtilities.transform(filteredArray, clazz, new ITransformer<T, U>(){

            @Override
            public U transform(T input) {
                return input;
            }
        });
    }

    public static <T> T[] convert(T ... items) {
        return items;
    }

    @Deprecated
    public static <T> T[] toArray(Iterable<T> items, Class<T> itemClass) {
        ArrayList<T> itemList = new ArrayList<T>();
        for (T item : items) {
            itemList.add(item);
        }
        return itemList.toArray((Object[])Array.newInstance(itemClass, itemList.size()));
    }

    public static <T> T[] concat(Class<T> componentClass, T[] ... arrays) {
        int size = 0;
        for (T[] array : arrays) {
            size += array.length;
        }
        Object[] concat = (Object[])Array.newInstance(componentClass, size);
        int pos = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, concat, pos, array.length);
            pos += array.length;
        }
        return concat;
    }

    public static boolean[] createBooleanArray(int length, boolean value) {
        boolean[] b = new boolean[length];
        Arrays.fill(b, value);
        return b;
    }
}

