/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.core.DialogDefaults;
import net.disy.commons.swing.dialog.core.DialogPagePanel;
import net.disy.commons.swing.dialog.core.IDeprecatedGenericDialogConfiguration;
import net.disy.commons.swing.dialog.core.IGenericDialogConfiguration;
import net.disy.commons.swing.dialog.core.ISwingFrameOrDialog;
import net.disy.commons.swing.dialog.core.SwingDialog;
import net.disy.commons.swing.dialog.core.SwingFrame;
import net.disy.commons.swing.util.GuiUtilities;
import net.disy.commons.swing.widgets.HorizontalLine;

public abstract class AbstractDialog {
    private static final String INITIAL_DIALOG_TITLE = "!Dialog.title!";
    private final WindowAdapter cancelingWindowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            AbstractDialog.this.performCancel();
        }
    };
    private final ISwingFrameOrDialog dialog;
    private final IGenericDialogConfiguration dialogConfiguration;
    private final Component parent;
    private boolean canceled = false;
    private final DialogPagePanel dialogPagePanel;

    public AbstractDialog(Component parent, IGenericDialogConfiguration dialogConfiguration) {
        Ensure.ensureArgumentNotNull(dialogConfiguration);
        this.parent = parent;
        this.dialogConfiguration = dialogConfiguration;
        this.dialogPagePanel = new DialogPagePanel(dialogConfiguration);
        this.dialog = AbstractDialog.createFrameOrDialog(parent);
        this.dialog.setModal(true);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this.cancelingWindowListener);
    }

    private static ISwingFrameOrDialog createFrameOrDialog(Component parent) {
        Window window = GuiUtilities.getWindowForComponent(parent);
        if (window == null || !window.isVisible()) {
            JFrame frame = new JFrame(INITIAL_DIALOG_TITLE);
            if (window instanceof Frame) {
                Frame originalFrame = (Frame)window;
                frame.setIconImage(originalFrame.getIconImage());
            }
            DialogDefaults dialogDefaults = DialogDefaults.getInstance();
            if (frame.getIconImage() == null && dialogDefaults.getFrameIconImage() != null) {
                frame.setIconImage(dialogDefaults.getFrameIconImage());
            }
            return new SwingFrame(frame);
        }
        return new SwingDialog(GuiUtilities.createDialog(parent, INITIAL_DIALOG_TITLE));
    }

    public Component getParent() {
        return this.parent;
    }

    protected final void performCancel() {
        if (this.cancelPressed()) {
            this.canceled = true;
            this.closeDialog();
            if (this.dialogConfiguration instanceof IDeprecatedGenericDialogConfiguration) {
                ((IDeprecatedGenericDialogConfiguration)this.dialogConfiguration).performAfterDispose(true);
            }
        }
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    protected IGenericDialogConfiguration getGenericDialog() {
        return this.dialogConfiguration;
    }

    protected void initialize() {
        this.dialog.getContentPane().add((Component)this.dialogPagePanel.createPanel(), "Center");
        this.dialog.getContentPane().add((Component)this.createButtonPanel(), "South");
    }

    private JComponent createButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new HorizontalLine(), "Center");
        panel.add((Component)this.createButtonBar(), "South");
        return panel;
    }

    protected abstract JComponent createButtonBar();

    protected abstract boolean cancelPressed();

    protected void closeDialog() {
        this.dialog.dispose();
        this.dialog.removeWindowListener(this.cancelingWindowListener);
    }

    public void updateSize() {
        if (this.getContent() == null) {
            this.dialog.pack();
            return;
        }
        Dimension preferredSize = this.dialogPagePanel.getPreferredSize();
        Dimension actualSize = this.dialogPagePanel.getSize();
        if (preferredSize.width > actualSize.width || preferredSize.height > actualSize.height) {
            GuiUtilities.repack(this.dialog.getWindow());
        }
    }

    protected void setContent(JComponent content) {
        this.dialogPagePanel.setContent(content);
    }

    protected JComponent getContent() {
        return this.dialogPagePanel.getContent();
    }

    protected final void setMessage(IBasicMessage message) {
        this.dialogPagePanel.setMessage(message);
        this.updateSize();
    }

    protected final void setDescription(String description) {
        this.dialogPagePanel.setDescription(description);
    }

    protected void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    protected void setDefaultButton(JButton button) {
        this.dialog.getRootPane().setDefaultButton(button);
    }

    public final ISwingFrameOrDialog getDialog() {
        return this.dialog;
    }
}

