/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.input.text.suggest.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.input.text.suggest.ISuggestionConfiguration;
import net.disy.commons.swing.dialog.input.text.suggest.internal.SuggestionWindowBusyComponent;
import net.disy.commons.swing.layout.cardlayout.CardPanel;
import net.disy.commons.swing.layout.cardlayout.CardPanelKey;
import net.disy.commons.swing.list.TypeSafeListModel;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;
import net.disy.commons.swing.util.GuiUtilities;

public class SuggestionWindow<T> {
    private static final CardPanelKey listComponentKey = new CardPanelKey();
    private static final CardPanelKey busyComponentKey = new CardPanelKey();
    private final JList list = new JList();
    private final CardPanel cardPanel = new CardPanel();
    private final JComponent hookComponent;
    private final ISuggestionConfiguration<T> configuration;
    private JWindow window;
    private TypeSafeListModel<T> listModel;
    private boolean busy = false;

    private static void ensureIsEventDispatchThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Method may only be called on the EDT, was '" + Thread.currentThread().getName() + "'");
        }
    }

    public SuggestionWindow(JComponent hookComponent, ISuggestionConfiguration<T> configuration) {
        Ensure.ensureArgumentNotNull(hookComponent);
        Ensure.ensureArgumentNotNull(configuration);
        this.hookComponent = hookComponent;
        this.configuration = configuration;
        this.list.setCellRenderer(new ObjectUiListCellRenderer(configuration.getObjectUi()));
    }

    public void showWithQueryStarted() {
        SuggestionWindow.ensureIsEventDispatchThread();
        if (this.window == null) {
            JScrollPane listScrollPane = new JScrollPane(this.list, 20, 30);
            this.cardPanel.add(listScrollPane, listComponentKey);
            this.cardPanel.add(new SuggestionWindowBusyComponent(this.configuration.getBusyLabelText()).getContent(), busyComponentKey);
            this.window = new JWindow(GuiUtilities.getWindowForComponent(this.hookComponent));
            this.window.getContentPane().setLayout(new BorderLayout());
            this.window.getContentPane().add((Component)this.cardPanel.getContent(), "Center");
            this.window.setSize(new Dimension(120, 120));
        }
        this.cardPanel.setSelectedSubPanel(busyComponentKey);
        Point hookLocation = this.hookComponent.getLocationOnScreen();
        int height = this.hookComponent.getHeight();
        this.window.setLocation(hookLocation.x, hookLocation.y + height);
        this.window.setVisible(true);
        this.busy = true;
    }

    public void showLoadedSuggestions(List<T> suggestions) {
        SuggestionWindow.ensureIsEventDispatchThread();
        this.listModel = new TypeSafeListModel<T>(suggestions);
        this.list.setModel(this.listModel);
        this.cardPanel.setSelectedSubPanel(listComponentKey);
        if (suggestions.isEmpty()) {
            this.dispose();
            this.busy = false;
            return;
        }
        this.setSelectedIndexAndAssureVisible(0);
        this.busy = false;
    }

    private void setSelectedIndexAndAssureVisible(int selectionIndex) {
        this.list.setSelectedIndex(selectionIndex);
        this.list.ensureIndexIsVisible(selectionIndex);
    }

    public void dispose() {
        SuggestionWindow.ensureIsEventDispatchThread();
        if (this.window == null) {
            return;
        }
        this.window.setVisible(false);
    }

    public void moveSelectionUp() {
        SuggestionWindow.ensureIsEventDispatchThread();
        if (this.window == null) {
            return;
        }
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex < 1) {
            this.window.getToolkit().beep();
            return;
        }
        this.setSelectedIndexAndAssureVisible(selectedIndex - 1);
    }

    public void moveSelectionDown() {
        SuggestionWindow.ensureIsEventDispatchThread();
        if (this.window == null) {
            return;
        }
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex >= this.list.getModel().getSize() - 1) {
            this.window.getToolkit().beep();
            return;
        }
        this.setSelectedIndexAndAssureVisible(selectedIndex + 1);
    }

    public T getSelectedItem() {
        SuggestionWindow.ensureIsEventDispatchThread();
        if (this.busy) {
            return null;
        }
        if (this.window == null) {
            return null;
        }
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        T item = this.listModel.getElementAt(selectedIndex);
        return item;
    }
}

