/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.filechooser.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.io.FileUtilities;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.input.text.ITextInputDialogResult;
import net.disy.commons.swing.dialog.input.text.SmartTextInputDialog;
import net.disy.commons.swing.dialog.message.MessageDialogUtilities;
import net.disy.commons.swing.dialog.userdialog.page.AbstractDialogPage;
import net.disy.commons.swing.filechooser.dialog.FileChooserDialogConfiguration;
import net.disy.commons.swing.filechooser.dialog.IFileModelActionFactory;
import net.disy.commons.swing.filechooser.dialog.NewFolderInputDialogConfiguration;
import net.disy.commons.swing.filechooser.model.FileChooserModel;
import net.disy.commons.swing.filechooser.view.FileChooserPanel;
import net.disy.commons.swing.icon.CommonIcons;
import net.disy.commons.swing.icon.SwingIcons;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.toolbar.ToolBarBuilder;

public abstract class AbstractFileChooserDialogPage
extends AbstractDialogPage {
    private final FileChooserPanel fileChooserPanel;
    private final FileChooserModel model;
    private final FileChooserDialogConfiguration configuration;

    public AbstractFileChooserDialogPage(FileChooserModel model, FileChooserDialogConfiguration configuration, String defaultMessageText) {
        super(defaultMessageText);
        Ensure.ensureArgumentNotNull(model);
        Ensure.ensureArgumentNotNull(configuration);
        this.model = model;
        this.configuration = this.getConfiguration(configuration);
        this.fileChooserPanel = new FileChooserPanel(model, this.configuration);
    }

    protected FileChooserDialogConfiguration getConfiguration(FileChooserDialogConfiguration configurationData) {
        return configurationData;
    }

    @Override
    public JComponent createContent() {
        this.fileChooserPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFileChooserDialogPage.this.fileChooserPanelActionPerformed();
            }
        });
        this.getModel().getFileModel().addChangeListener(this.getCheckInputValidListener());
        JPanel panel = new JPanel(new BorderLayout(LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentSpacing()));
        ToolBarBuilder builder = new ToolBarBuilder();
        builder.add(this.createRefreshAction());
        builder.addSeparator();
        builder.add(this.createDeleteAction());
        builder.add(this.createNewFolderAction(panel));
        IFileModelActionFactory[] actionFactories = this.getConfiguration().getActionFactories();
        for (int i = 0; i < actionFactories.length; ++i) {
            builder.add(actionFactories[i].createAction(this.getModel().getFileModel()));
        }
        panel.add((Component)builder.getToolBar(), "North");
        panel.add((Component)this.fileChooserPanel.getContent(), "Center");
        return panel;
    }

    private Action createDeleteAction() {
        final SmartAction deleteAction = new SmartAction("Ausgew\u00e4hlte Datei oder Verzeichnis l\u00f6schen", CommonIcons.DELETE){

            @Override
            protected void execute(Component parentComponent) {
                AbstractFileChooserDialogPage.this.executeDelete(parentComponent);
            }
        };
        this.getModel().getFileModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                AbstractFileChooserDialogPage.this.updateDeleteActionEnabled(deleteAction);
            }
        });
        this.updateDeleteActionEnabled(deleteAction);
        return deleteAction;
    }

    private void executeDelete(Component parentComponent) {
        File file = (File)this.getModel().getFileModel().getValue();
        if (file.isDirectory()) {
            if (!MessageDialogUtilities.confirmUserOperation(parentComponent, "Wollen Sie das ausgew\u00e4hlte Verzeichnis und alle Dateien, die darin enthalten sind, wirklich l\u00f6schen?", "Best\u00e4tigen")) {
                return;
            }
            try {
                FileUtilities.deleteFileOrDirectory(file);
                this.getModel().refresh();
            }
            catch (IOException iOException) {}
        } else {
            if (!MessageDialogUtilities.confirmUserOperation(parentComponent, "Wollen Sie die ausgew\u00e4hlte Datei wirklich l\u00f6schen?", "Best\u00e4tigen")) {
                return;
            }
            if (file.delete()) {
                this.getModel().refresh();
            }
        }
    }

    private Action createRefreshAction() {
        return new SmartAction("Ansicht aktualisieren", CommonIcons.REFRESH){

            @Override
            protected void execute(Component parentComponent) {
                AbstractFileChooserDialogPage.this.getModel().refresh();
            }
        };
    }

    private Action createNewFolderAction(final Component parent) {
        SmartAction newFolderAction = new SmartAction("Neuen Ordner anlegen", SwingIcons.getFileViewNewFolderIcon()){

            @Override
            protected void execute(Component parentComponent) {
                AbstractFileChooserDialogPage.this.executeCreateNewFolder(parent);
            }
        };
        return newFolderAction;
    }

    private void executeCreateNewFolder(Component parent) {
        File folder = (File)this.getModel().getFolderModel().getValue();
        NewFolderInputDialogConfiguration dialogConfiguration = new NewFolderInputDialogConfiguration(folder);
        ITextInputDialogResult result = SmartTextInputDialog.showTextInputDialog(parent, dialogConfiguration, this.createNonExistingFileName(folder, "Neuer Ordner"));
        if (!result.isCanceled()) {
            File file = new File(folder, result.getText().trim());
            file.mkdir();
            this.getModel().refresh();
            this.getModel().getFileModel().setValue(file);
        }
    }

    private String createNonExistingFileName(File folder, String name) {
        if (!new File(folder, name).exists()) {
            return name;
        }
        int index = 1;
        String newName;
        while (new File(folder, newName = name + " " + index).exists()) {
            ++index;
        }
        return newName;
    }

    private void updateDeleteActionEnabled(Action deleteAction) {
        File file = (File)this.getModel().getFileModel().getValue();
        deleteAction.setEnabled(file != null && file.exists());
    }

    protected void fileChooserPanelActionPerformed() {
        this.fireRequestFinish();
    }

    public FileChooserModel getModel() {
        return this.model;
    }

    protected FileChooserDialogConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setAccessory(JComponent accessory) {
        this.fileChooserPanel.setAccessory(accessory);
    }
}

