/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.filechooser.dialog;

import java.io.File;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.filechooser.dialog.AbstractFileChooserDialogPage;
import net.disy.commons.swing.filechooser.dialog.FileChooserDialogConfiguration;
import net.disy.commons.swing.filechooser.model.FileChooserModel;

public class FileOpenDialogPage
extends AbstractFileChooserDialogPage {
    private static final String DEFAULT_MESSAGE = "Bitte w\u00e4hlen Sie eine Datei zum \u00d6ffnen aus.";
    private static final IBasicMessage NO_FILE_SELECTED_MESSAGE = new BasicMessage("Es ist keine Datei ausgew\u00e4hlt. Bitte w\u00e4hlen Sie eine Datei aus.", MessageType.ERROR);
    private static final IBasicMessage DIRECTORY_SELECTED_MESSAGE = new BasicMessage("Es ist ein Verzeichnis ausgew\u00e4hlt. Bitte w\u00e4hlen Sie eine einfache Datei aus.", MessageType.ERROR);
    private static final IBasicMessage FILE_NOT_EXISTENT_MESSAGE = new BasicMessage("Die Datei existiert nicht. Bitte w\u00e4hlen Sie eine vorhandene Datei aus.", MessageType.ERROR);

    public FileOpenDialogPage(FileChooserModel model, FileChooserDialogConfiguration configuration) {
        super(model, configuration, DEFAULT_MESSAGE);
    }

    @Override
    public IBasicMessage createCurrentMessage() {
        File file = (File)this.getModel().getFileModel().getValue();
        if (file == null) {
            return NO_FILE_SELECTED_MESSAGE;
        }
        if (file.isDirectory()) {
            return DIRECTORY_SELECTED_MESSAGE;
        }
        if (!file.exists()) {
            return FILE_NOT_EXISTENT_MESSAGE;
        }
        return this.getDefaultMessage();
    }

    @Override
    public String getTitle() {
        return "Datei \u00f6ffnen";
    }
}

