/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.text;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.model.IntModel;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.ObjectUtilities;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.textfield.IntegerField;

public class TextWidgetFactory {
    private static final int DEFAULT_COLUMN_COUNT = 25;

    private TextWidgetFactory() {
        throw new UnreachableCodeReachedException();
    }

    public static JTextField createTextField(ObjectModel<String> stringModel) {
        return TextWidgetFactory.createTextField(stringModel, 25);
    }

    public static JTextField createTextField(ObjectModel<String> stringModel, int columnCount) {
        JTextField widget = new JTextField(columnCount);
        return TextWidgetFactory.connect(stringModel, widget);
    }

    private static JTextField connect(final ObjectModel<String> stringModel, final JTextField widget) {
        stringModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                String value = (String)stringModel.getValue();
                if (!ObjectUtilities.equals(value, widget.getText())) {
                    widget.setText(value);
                }
            }
        });
        widget.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            @Override
            protected void documentChanged() {
                stringModel.setValue(widget.getText());
            }
        });
        widget.setText(stringModel.getValue());
        return widget;
    }

    public static JPasswordField createPasswordField(ObjectModel<String> model) {
        JPasswordField passwordField = new JPasswordField(25);
        TextWidgetFactory.connect(model, passwordField);
        return passwordField;
    }

    public static JComboBox createComboBox(final ObjectModel<String> stringModel, String[] values) {
        final JComboBox<String> widget = new JComboBox<String>(values);
        stringModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                String value = (String)stringModel.getValue();
                if (!ObjectUtilities.equals(value, widget.getSelectedItem())) {
                    widget.setSelectedItem(value);
                }
            }
        });
        widget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stringModel.setValue((String)widget.getSelectedItem());
            }
        });
        widget.setSelectedItem(stringModel.getValue());
        return widget;
    }

    public static JTextField createTextField(final IntModel intModel) {
        final IntegerField widget = new IntegerField();
        intModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                int value = intModel.getValue();
                if (value != widget.getInt()) {
                    widget.setInt(value);
                }
            }
        });
        widget.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            @Override
            protected void documentChanged() {
                intModel.setValue(widget.getInt());
            }
        });
        widget.setInt(intModel.getValue());
        return widget;
    }

    public static JFormattedTextField createUneditableDateWidget(final ObjectModel<Calendar> model, DateFormat format) {
        final JFormattedTextField widget = new JFormattedTextField(format);
        widget.setValue(model.getValue().getTime());
        model.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                widget.setValue(((Calendar)model.getValue()).getTime());
            }
        });
        widget.setEditable(false);
        return widget;
    }
}

