/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export.applet;

import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.asciimation.export.jmov.JmovAnimationExporter;
import de.jave.jave.JaveGlobalRessources;
import de.jave.lib.io.IoUtilities;
import de.jave.lib.net.HtmlUtilities;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.disy.commons.core.io.IOUtilities;

public class AppletAnimationExporter
extends JmovAnimationExporter {
    public AppletAnimationExporter(AnimationExportOptions options) {
        super(options);
    }

    @Override
    protected File getJmovOutputFile() {
        return new File(this.getOptions().getFileNameWithoutExtension() + ".jmov");
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        this.createHtmlFile();
        this.copyPlayerFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHtmlFile() throws IOException {
        Dimension plateSize = this.calculateExpectedPlatePixelSize(this.getFrameSize());
        int width = plateSize.width;
        if (this.getOptions().getAdditionalOptions().isControls() && width < 320) {
            width = 320;
        }
        int height = plateSize.height;
        if (this.getOptions().getAdditionalOptions().isControls()) {
            height += 27;
        }
        String widthString = String.valueOf(width);
        String heightString = String.valueOf(height);
        String controlsValueString = this.getOptions().getAdditionalOptions().isControls() ? "1" : "0";
        String autoStartValueString = "0";
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.getOptions().getFile()));
            AppletAnimationExporter.writeLine(writer, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            AppletAnimationExporter.writeLine(writer, "<html>");
            AppletAnimationExporter.writeLine(writer, "\t<head>");
            writer.write("\t\t<title>");
            if (this.getTitle() == null) {
                writer.write("Ascii Animation");
            } else {
                writer.write(HtmlUtilities.encode(this.getTitle()));
            }
            AppletAnimationExporter.writeLine(writer, "</title>");
            AppletAnimationExporter.writeLine(writer, "\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />");
            AppletAnimationExporter.writeLine(writer, "\t</head>");
            AppletAnimationExporter.writeLine(writer, "\t<body>");
            AppletAnimationExporter.writeLine(writer, "\t\t<applet code=\"de.jave.javeplayer.JavePlayerApplet\" archive=\"javeplayer.jar\" width=\"" + widthString + "\" height=\"" + heightString + "\">");
            AppletAnimationExporter.writeLine(writer, "\t\t\t<param name=\"file\"       value=\"" + this.getJmovOutputFile().getName() + "\" />");
            AppletAnimationExporter.writeLine(writer, "\t\t\t<param name=\"controls\"  value=\"" + controlsValueString + "\" />");
            AppletAnimationExporter.writeLine(writer, "\t\t\t<param name=\"autostart\"       value=\"0\" />");
            AppletAnimationExporter.writeLine(writer, "\t\t\t<h3>Your browser is not configured or able to run Java Applets</h3>");
            AppletAnimationExporter.writeLine(writer, "\t\t\t<blockquote>");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\tViewing this animation requires a Java-enabled browser with Java 1.4 or greater installed.");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\t<ul>");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\t\t<li>You need to install Java Plug-in, which happens automatically when");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\t\tyou <a href=\"http://java.sun.com/j2se/downloads.html\" target=\"_blank\">install the J2SE JRE or SDK</a>.</li>");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\t\t<li>If your browser still does support Java, perhaps you have Java turned off.</li>");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\t\t<li>You can find more information in the <a href=\"http://java.sun.com/products/plugin\" target=\"_blank\">Java");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\t\tPlug-in home page.</a></li>");
            AppletAnimationExporter.writeLine(writer, "\t\t\t\t</ul>");
            AppletAnimationExporter.writeLine(writer, "\t\t\t</blockquote>");
            AppletAnimationExporter.writeLine(writer, "\t\t</applet>");
            AppletAnimationExporter.writeLine(writer, "\t</body>");
            writer.write("</html>");
        }
        catch (Throwable throwable) {
            IOUtilities.close(writer);
            throw throwable;
        }
        IOUtilities.close(writer);
    }

    private static void writeLine(BufferedWriter writer, String text) throws IOException {
        writer.write(text);
        writer.newLine();
    }

    private void copyPlayerFile() throws Exception, IOException {
        File playerFile = new File(JaveGlobalRessources.codeBase, "javeplayer.jar");
        if (!playerFile.exists() || !playerFile.canRead()) {
            throw new Exception("Unable to load player file " + playerFile.getAbsolutePath());
        }
        File playerTargetFile = new File(this.getOptions().getFile().getParentFile(), playerFile.getName());
        IoUtilities.copy(playerFile, playerTargetFile);
    }
}

