/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.layouter;

import de.jave.figlet.engine.layout.HorizontalAlignment;
import de.jave.figlet.engine.layout.IHorizontalAlignmentVisitor;
import de.jave.figlet.engine.layout.PrintDirection;
import de.jave.figlet.engine.layout.VerticalAlignment;
import de.jave.figlet.engine.layouter.IFigLayouter;
import de.jave.figlet.engine.primitives.FigFont;
import de.jave.figlet.engine.primitives.FigFragment;
import de.jave.figlet.engine.primitives.FigLayout;
import de.jave.figlet.engine.primitives.HorizontalLayoutMode;
import de.jave.text.QuickString;

public class DefaultFigLayouter
implements IFigLayouter {
    private int maxLineLength = -1;

    public DefaultFigLayouter(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    private static void ensureMinimumWidth(final FigFragment fragment, final int newWidth) {
        if (newWidth <= fragment.getWidth()) {
            return;
        }
        fragment.getHorizontalAlignment().accept(new IHorizontalAlignmentVisitor(){

            @Override
            public void visitLeftAlignment(HorizontalAlignment horizontalAlignment) {
                fragment.addColumnsRight(newWidth - fragment.getWidth());
            }

            @Override
            public void visitRightAlignment(HorizontalAlignment horizontalAlignment) {
                fragment.addColumnsLeft(newWidth - fragment.getWidth());
            }

            @Override
            public void visitCenterAlignment(HorizontalAlignment horizontalAlignment) {
                fragment.addColumnsLeft((newWidth - fragment.getWidth()) / 2);
                fragment.addColumnsRight(newWidth - fragment.getWidth());
            }
        });
    }

    private static void ensureMinimumHeight(FigFragment fragment, int newHeight) {
        if (newHeight <= fragment.getHeight()) {
            return;
        }
        if (fragment.getVerticalAlignment() == VerticalAlignment.TOP) {
            fragment.addRowsBottom(newHeight - fragment.getHeight());
        } else if (fragment.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
            fragment.addRowsTop(newHeight - fragment.getHeight());
        } else {
            fragment.addRowsTop((newHeight - fragment.getHeight()) / 2);
            fragment.addRowsBottom(newHeight - fragment.getHeight());
        }
    }

    private static void ensureUnderLength(FigFragment fragment, int newUnderLength) {
        if (fragment.getUnderLength() >= newUnderLength) {
            return;
        }
        fragment.addRowsBottom(newUnderLength - fragment.getUnderLength());
    }

    @Override
    public FigFragment createFragment(FigFont font, FigLayout layout, int characterCode) {
        FigFragment fragment = new FigFragment(font.getFIGCharacter(characterCode), layout, font.getUnderLength(), this.maxLineLength);
        if (layout.getHorizontalLayoutMode() == HorizontalLayoutMode.FIXED_WIDTH) {
            DefaultFigLayouter.ensureMinimumWidth(fragment, font.getOptions().getActualMaxLineWidth());
        }
        return fragment;
    }

    @Override
    public FigFragment appendHorizontal(FigFragment fragment1, FigFragment fragment2) {
        return this.addHorizontal(fragment1, fragment2);
    }

    @Override
    public FigFragment appendVertical(FigFragment fragment, FigFragment lineFragment) {
        return DefaultFigLayouter.addVertical(fragment, lineFragment);
    }

    private static FigFragment addVertical(FigFragment a, FigFragment b) {
        if (b == null) {
            return a;
        }
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        int shallWidth = DefaultFigLayouter.max(b.getWidth(), a.getWidth());
        DefaultFigLayouter.ensureMinimumWidth(a, shallWidth);
        DefaultFigLayouter.ensureMinimumWidth(b, shallWidth);
        int width = a.getWidth();
        FigLayout[] intersectedLayouts = new FigLayout[width];
        for (int i = 0; i < width; ++i) {
            intersectedLayouts[i] = a.getBottomLayout(i).intersect(b.getTopLayout(i));
        }
        int maxi = 10;
        if (maxi > a.getHeight()) {
            maxi = a.getHeight();
        }
        if (maxi > b.getHeight()) {
            maxi = b.getHeight();
        }
        QuickString[] aa = new QuickString[a.getWidth()];
        for (int i = 0; i < a.getWidth(); ++i) {
            aa[i] = new QuickString(maxi * 2);
            for (int j = 0; j < maxi; ++j) {
                aa[i].append(a.getLines()[a.getHeight() - maxi + j].charAt(i));
            }
        }
        QuickString[] bb = new QuickString[b.getWidth()];
        for (int i = 0; i < b.getWidth(); ++i) {
            bb[i] = new QuickString(maxi * 2);
            for (int j = 0; j < maxi; ++j) {
                bb[i].append(b.getLines()[j].charAt(i));
            }
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < bb.length; ++i) {
            int depth = intersectedLayouts[i].getMaximalVerticalSmushingDepth(aa[i], bb[i]);
            if (depth < min) {
                min = depth;
            }
            if (min == 0) break;
        }
        QuickString[] ss = new QuickString[bb.length];
        for (int i = 0; i < bb.length; ++i) {
            ss[i] = intersectedLayouts[i].smushVertical(aa[i], bb[i], min);
        }
        QuickString[] s = new QuickString[a.getHeight() + b.getHeight() - min];
        System.arraycopy(a.getLines(), 0, s, 0, a.getHeight() - maxi);
        for (int i = 0; i < maxi + maxi - min; ++i) {
            s[i + a.getHeight() - maxi] = new QuickString();
            for (int j = 0; j < ss.length; ++j) {
                s[i + a.getHeight() - maxi].append(ss[j].charAt(i));
            }
        }
        System.arraycopy(b.getLines(), maxi, s, s.length - b.getHeight() + maxi, b.getHeight() - maxi);
        int top = a.getHeight() - min / 2;
        if (top < 0) {
            top = 0;
        }
        int bottom = s.length - top;
        FigLayout[] newLeftLayout = new FigLayout[s.length];
        FigLayout[] newRightLayout = new FigLayout[s.length];
        System.arraycopy(a.getLayoutLeft(), 0, newLeftLayout, 0, top);
        System.arraycopy(a.getLayoutRight(), 0, newRightLayout, 0, top);
        System.arraycopy(b.getLayoutLeft(), b.getHeight() - bottom, newLeftLayout, top, bottom);
        System.arraycopy(b.getLayoutRight(), b.getHeight() - bottom, newRightLayout, top, bottom);
        FigFragment result = new FigFragment(s, newLeftLayout, newRightLayout, s.length, s[0].length(), a.getLayoutTop(), b.getLayoutBottom(), a.getUnderLength(), b.getMaxLineLength(), a.getPrintDirection());
        result.setHorizontalAlignment(b.getHorizontalAlignment());
        return result;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    private FigFragment addHorizontal(FigFragment one, FigFragment other) {
        int index;
        int i;
        if (other == null) {
            return one;
        }
        FigFragment a = (FigFragment)one.clone();
        FigFragment b = (FigFragment)other.clone();
        if (a.getHeight() == 0 || a.getWidth() == 0) {
            return b;
        }
        if (b.getHeight() == 0 || b.getWidth() == 0) {
            return a;
        }
        if (a.getPrintDirection() == PrintDirection.RIGHT_TO_LEFT && b.getPrintDirection() == PrintDirection.RIGHT_TO_LEFT) {
            FigFragment t = a;
            a = b;
            b = t;
        }
        if (a.getWidth() == 1 && a.getLines()[0].firstChar() == ' ') {
            a.getLines()[0] = new QuickString('\u007f');
        }
        if (b.getWidth() == 1 && b.getLines()[0].firstChar() == ' ') {
            b.getLines()[0] = new QuickString('\u007f');
        }
        if (b.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
            DefaultFigLayouter.ensureUnderLength(a, b.getUnderLength());
            DefaultFigLayouter.ensureUnderLength(b, a.getUnderLength());
        }
        DefaultFigLayouter.ensureMinimumHeight(a, b.getHeight());
        DefaultFigLayouter.ensureMinimumHeight(b, a.getHeight());
        int h = a.getHeight();
        FigLayout[] layoutInter = new FigLayout[h];
        for (int i2 = 0; i2 < h; ++i2) {
            layoutInter[i2] = a.getLayoutRight()[i2].intersect(b.getLayoutLeft()[i2]);
        }
        int smushingWidth = Integer.MAX_VALUE;
        for (int i3 = 0; i3 < h; ++i3) {
            int depth = layoutInter[i3].getMaximalHorizontalSmushingDepth(a.getLines()[i3], b.getLines()[i3]);
            if (depth >= smushingWidth) continue;
            smushingWidth = depth;
        }
        QuickString[] s = new QuickString[h];
        for (int i4 = 0; i4 < h; ++i4) {
            s[i4] = layoutInter[i4].smushHorizontal(a.getLines()[i4], b.getLines()[i4], smushingWidth);
        }
        FigFragment result = new FigFragment(s, a.getLayoutLeft(), b.getLayoutRight(), s.length, s[0].length(), new FigLayout[s[0].length()], new FigLayout[s[0].length()], b.getUnderLength(), b.getMaxLineLength(), a.getPrintDirection());
        int resultCutX = a.getWidth() - smushingWidth / 2;
        if (resultCutX < 0) {
            resultCutX = 0;
        }
        if (resultCutX >= result.getWidth()) {
            resultCutX = result.getWidth() - 1;
        }
        for (i = 0; i < resultCutX; ++i) {
            index = Math.min(i, a.getWidth() - 1);
            result.setTopLayout(i, a.getTopLayout(index));
            result.setBottomLayout(i, a.getBottomLayout(index));
        }
        for (i = resultCutX; i < result.getWidth(); ++i) {
            index = Math.max(0, b.getWidth() - result.getWidth() + resultCutX);
            result.setTopLayout(i, b.getTopLayout(index));
            result.setBottomLayout(i, b.getBottomLayout(index));
        }
        return result;
    }
}

