/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class UmkehrTabellenBuilder {
    protected static final String CONFIGURATION_FOLDER_NAME = "./greyscaletables/3_hand_classified_tables/";
    protected static final String OUTPUT_FOLDER_NAME = "./greyscaletables/4_jgt_tables/";

    public static void main(String[] args) throws Exception {
        UmkehrTabellenBuilder.parseFolder();
    }

    public static void parseFolder() throws Exception {
        int i;
        File file = new File(CONFIGURATION_FOLDER_NAME);
        if (!file.isDirectory()) {
            throw new Exception("There is no folder '" + file + "' containing cofiguration files.");
        }
        String[] fileNames = file.list();
        int counter = 0;
        for (i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].toLowerCase().endsWith(".cfg")) continue;
            ++counter;
        }
        if (counter == 0) {
            throw new Exception("There are no configuration files in folder '" + file + "'.");
        }
        for (i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].toLowerCase().endsWith(".cfg")) continue;
            UmkehrTabellenBuilder.buildFile(file, fileNames[i]);
        }
    }

    protected static void buildFile(File folder, String fileName) throws Exception {
        File fileIn = new File(folder, fileName);
        File fileOut = new File(new File(OUTPUT_FOLDER_NAME), fileName.substring(0, fileName.length() - 4) + ".jgt");
        try {
            int i;
            int[] greyscales = new int[95];
            int[][] g4 = new int[95][4];
            char[] g4ch = new char[95];
            boolean[] ignores = new boolean[95];
            boolean[] i4 = new boolean[95];
            BufferedReader br = new BufferedReader(new FileReader(fileIn));
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileOut));
            String line = null;
            for (int i2 = 0; i2 < 95; ++i2) {
                line = br.readLine();
                if (line == null) {
                    throw new Exception("Configuration file '" + fileIn + "' is truncated.");
                }
                System.out.println(line);
                bw.write(line);
                bw.newLine();
                String value = null;
                if (line.endsWith("##")) {
                    ignores[i2] = true;
                    i4[i2] = true;
                    value = line.substring(2, line.length() - 2);
                } else if (line.endsWith(" #")) {
                    ignores[i2] = false;
                    i4[i2] = true;
                    value = line.substring(2, line.length() - 2);
                } else if (line.endsWith("#")) {
                    ignores[i2] = true;
                    i4[i2] = false;
                    value = line.substring(2, line.length() - 1);
                } else {
                    ignores[i2] = false;
                    i4[i2] = false;
                    value = line.substring(2);
                }
                try {
                    int ii1 = value.indexOf(32);
                    int ii2 = value.indexOf(32, ii1 + 1);
                    int ii3 = value.indexOf(32, ii2 + 1);
                    int ii4 = value.indexOf(32, ii3 + 1);
                    greyscales[i2] = Integer.parseInt(value.substring(0, ii1));
                    g4[i2][0] = Integer.parseInt(value.substring(ii1 + 1, ii2));
                    g4[i2][1] = Integer.parseInt(value.substring(ii2 + 1, ii3));
                    g4[i2][2] = Integer.parseInt(value.substring(ii3 + 1, ii4));
                    g4[i2][3] = Integer.parseInt(value.substring(ii4 + 1));
                    g4ch[i2] = (char)(32 + i2);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Syntax error in configuration file '" + fileIn + "': " + line);
                }
            }
            int size = g4ch.length;
            boolean done = false;
            while (!done) {
                done = true;
                for (i = 0; i < size - 1; ++i) {
                    if (!(g4[i][0] > g4[i + 1][0] || g4[i][0] == g4[i + 1][0] && g4[i][1] > g4[i + 1][1] || g4[i][0] == g4[i + 1][0] && g4[i][1] == g4[i + 1][1] && g4[i][2] > g4[i + 1][2]) && (g4[i][0] != g4[i + 1][0] || g4[i][1] != g4[i + 1][1] || g4[i][2] != g4[i + 1][2] || g4[i][3] <= g4[i + 1][3])) continue;
                    int[] t = g4[i];
                    g4[i] = g4[i + 1];
                    g4[i + 1] = t;
                    char ct = g4ch[i];
                    g4ch[i] = g4ch[i + 1];
                    g4ch[i + 1] = ct;
                    boolean bt = i4[i];
                    i4[i] = i4[i + 1];
                    i4[i + 1] = bt;
                    done = false;
                }
            }
            for (i = 0; i < size; ++i) {
                if (i4[i]) continue;
                System.out.println(g4[i][0] + " " + g4[i][1] + " " + g4[i][2] + " " + g4[i][3] + " " + g4ch[i]);
                bw.write(g4[i][0] + " " + g4[i][1] + " " + g4[i][2] + " " + g4[i][3] + " " + g4ch[i]);
                bw.newLine();
            }
            br.close();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error loading configuration file '" + fileIn + "'.");
        }
    }
}

