/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmFeltpenOptionsModel;
import de.jave.image2ascii.algorithm.HistogrammRun;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgotihmFeltpenOptionsPanel;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.lib.CharacterPlate;
import java.util.Vector;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public class Image2AsciiAlgorithmFeltpen
extends Image2AsciiAlgorithm {
    private final AlgorithmFeltpenOptionsModel optionsModel = new AlgorithmFeltpenOptionsModel();

    @Override
    public String getName() {
        return "Felt Pen";
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    @Override
    public void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    @Override
    public void setSpecialChars(String specialCharacters) {
    }

    @Override
    public IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgotihmFeltpenOptionsPanel(this.optionsModel);
    }

    @Override
    public int getVerticalPixelsPerChar() {
        return 4;
    }

    @Override
    public int getHorizontalPixelsPerChar() {
        return 3;
    }

    @Override
    public boolean isMonochromeImageRequired() {
        return false;
    }

    @Override
    public CharacterPlate convert(IValueRaster raster, IProgressMonitor progressMonitor, ICancelable cancelable) throws InterruptedException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        PixelPlateMode[] feltpenGradientModes = PixelPlate.FELTPEN_GRADIENT_MODES;
        int gradientCount = feltpenGradientModes.length;
        int[] colors = new int[256];
        boolean doMedianCut = this.optionsModel.isMedianCut();
        if (doMedianCut) {
            int[] histogramm = new int[256];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int n = raster.getValueAt(x, y);
                    histogramm[n] = histogramm[n] + 1;
                }
            }
            Vector<HistogrammRun> runs = new Vector<HistogrammRun>(gradientCount + 2);
            HistogrammRun h = new HistogrammRun(histogramm, 0, 255);
            runs.addElement(h);
            runs.addElement(h.split());
            HistogrammRun currentRun = null;
            while (runs.size() < gradientCount + 1) {
                int maxSize = 0;
                int maxIndex = 0;
                for (int i = 0; i < runs.size(); ++i) {
                    currentRun = (HistogrammRun)runs.elementAt(i);
                    if (!currentRun.isSplitable() || currentRun.getSize() <= maxSize) continue;
                    maxSize = currentRun.getSize();
                    maxIndex = i;
                }
                currentRun = (HistogrammRun)runs.elementAt(maxIndex);
                runs.insertElementAt(currentRun.split(), maxIndex + 1);
            }
            for (int i = 0; i < runs.size(); ++i) {
                currentRun = (HistogrammRun)runs.elementAt(i);
                for (int j = currentRun.getStart(); j <= currentRun.getEnd(); ++j) {
                    colors[j] = i;
                }
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                colors[i] = i * (gradientCount + 1) / 255;
            }
        }
        CharacterPlate cp = new CharacterPlate(width / 3, height / 4);
        cp.setMix(true);
        progressMonitor.beginTask("Converting...", gradientCount * height);
        for (int i = 0; i < gradientCount; ++i) {
            PixelPlate plate = new PixelPlate(0, 0, width / 3, height / 4);
            plate.setMode(feltpenGradientModes[gradientCount - i - 1]);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (i != colors[raster.getValueAt(x, y)]) continue;
                    plate.set(x, y);
                }
            }
            plate.convert();
            plate.pasteResultInto(cp);
            progressMonitor.worked(1);
        }
        return cp;
    }
}

