/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.Image2AsciiIcons;
import de.jave.image2ascii.algorithm.AlgorithmGradientOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmGradientOptionsPanel;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public class Image2AsciiAlgorithmGradient
extends Image2AsciiAlgorithm {
    private final AlgorithmGradientOptionsModel optionsModel = new AlgorithmGradientOptionsModel();

    @Override
    public IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    @Override
    public void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    @Override
    public void setSpecialChars(String specialCharacters) {
        this.optionsModel.setGradient(specialCharacters);
    }

    @Override
    public String getName() {
        return "Gradient";
    }

    @Override
    public Icon getIcon() {
        return Image2AsciiIcons.ALGORITHM_GRADIENT_ICON;
    }

    @Override
    public int getVerticalPixelsPerChar() {
        return 1;
    }

    @Override
    public int getHorizontalPixelsPerChar() {
        return 1;
    }

    @Override
    public boolean isMonochromeImageRequired() {
        return false;
    }

    @Override
    public IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmGradientOptionsPanel(this.optionsModel);
    }

    @Override
    public CharacterPlate convert(IValueRaster raster, IProgressMonitor progressMonitor, ICancelable cancelable) throws InterruptedException {
        String gradient = this.optionsModel.getGradient();
        if (gradient.length() == 0) {
            gradient = " ";
        }
        int resolution = gradient.length();
        int width = raster.getWidth();
        int height = raster.getHeight();
        progressMonitor.beginTask("Converting...", height);
        CharacterPlate cp = new CharacterPlate(width, height);
        boolean stegano = this.optionsModel.isSteganogram();
        String steganoText = this.optionsModel.getSteganogramText();
        for (int y = 0; y < height; ++y) {
            Thread.yield();
            ProgressUtilities.checkInterrupted(cancelable);
            for (int x = 0; x < width; ++x) {
                int characterIndex;
                double d = (double)raster.getValueAt(x, y) / 255.0;
                int i = (int)((1.0 - d) * (double)resolution);
                if (i >= resolution) {
                    i = resolution - 1;
                }
                if (stegano && (characterIndex = (y * width + x) / 8) < steganoText.length()) {
                    boolean iBit;
                    int bitIndex = (y * width + x) % 8;
                    boolean currentBit = (steganoText.charAt(characterIndex) & 1 << bitIndex) > 0;
                    boolean bl = iBit = (i & 1) > 0;
                    if (iBit != currentBit) {
                        i = (x + y) % 2 == 0 ? --i : ++i;
                    }
                    if (i < 0) {
                        i += 2;
                    } else if (i >= resolution) {
                        i -= 2;
                    }
                }
                cp.setForce(x, y, gradient.charAt(i));
            }
            progressMonitor.worked(1);
        }
        return cp;
    }
}

