/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.dialog;

import de.jave.image2ascii.dialog.BatchSourceImageModel;
import de.jave.image2ascii.dialog.BatchSourceImagesFinder;
import de.jave.image2ascii.dialog.SourceFileListPanel;
import java.io.File;
import javax.swing.JComponent;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.wizard.AbstractWizardPage;

public class BatchConversionSourceFilePage
extends AbstractWizardPage {
    private final FileModel currentDirectoryModel;
    private final BatchSourceImageModel model;
    private SourceFileListPanel sourceFileListPanel;

    public BatchConversionSourceFilePage(FileModel currentDirectoryModel) {
        super("Source Images", "Batch Conversion", "Add source files for batch conversion. The files will be converted in the listed order using the current converter settings.");
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        this.currentDirectoryModel = currentDirectoryModel;
        this.model = new BatchSourceImageModel(BatchSourceImagesFinder.findSourceFiles((File)currentDirectoryModel.getValue()));
        this.model.addChangeListener(this.getCheckInputValidListener());
    }

    @Override
    protected IBasicMessage createCurrentMessage() {
        if (this.model.getFileCount() == 0) {
            return new BasicMessage("There are no source image files selected. Please select source files.", MessageType.ERROR);
        }
        return this.getDefaultMessage();
    }

    @Override
    protected JComponent createContent() {
        this.sourceFileListPanel = new SourceFileListPanel(this.model, this.currentDirectoryModel);
        return this.sourceFileListPanel.getContent();
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.getNextPage() == null) {
            return false;
        }
        if (this.getMessage().getType() == MessageType.ERROR) {
            return false;
        }
        return this.createCurrentMessage().getType() != MessageType.ERROR;
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public void performHelp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHelpAvailable() {
        return false;
    }

    @Override
    public void requestFocus() {
        this.sourceFileListPanel.requestFocus();
    }

    public File[] getSourceFiles() {
        return this.model.getFiles();
    }
}

