/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.disy.commons.core.io.IOUtilities;

public class CharSetsConfiguration
implements IJaveInitializable {
    private static final CharSetsConfiguration instance = new CharSetsConfiguration();
    private String[] charsetNames = new String[]{"Any Characters", "Pure ASCII", "User Defined"};
    private String[] charsetCharacters = new String[]{"", "", "!\"#$%&'()*+,-./0123456789:;<=>?@\nABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`\nabcdefghijklmnopqrstuvwxyz{|}~"};
    private static int userDefinedIndex = 2;
    private static final String DEFAULT_CHARSET = "!\"#$%&'()*+,-./0123456789:;<=>?@\nABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`\nabcdefghijklmnopqrstuvwxyz{|}~";

    private CharSetsConfiguration() {
    }

    @Override
    public void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/charsets.txt");
        this.charsetNames = null;
        this.charsetCharacters = null;
        ArrayList<String> characters = new ArrayList<String>();
        characters.add("");
        characters.add("");
        ArrayList<String> names = new ArrayList<String>();
        names.add("Any Characters");
        names.add("Pure ASCII");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            boolean mode = true;
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (mode) {
                    if (line.length() > 30) {
                        line = line.substring(0, 30);
                    }
                    names.add(line);
                    mode = false;
                    continue;
                }
                characters.add(" " + line);
                mode = true;
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(configurationFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
        }
        IOUtilities.close(br);
        names.add("User Defined");
        characters.add(DEFAULT_CHARSET);
        int size = names.size();
        this.charsetNames = new String[size];
        this.charsetCharacters = new String[size];
        for (int i = 0; i < size; ++i) {
            this.charsetNames[i] = (String)names.get(i);
            this.charsetCharacters[i] = (String)characters.get(i);
        }
        userDefinedIndex = size - 1;
    }

    public static CharSetsConfiguration getInstance() {
        return instance;
    }

    public int getUserDefinedIndex() {
        return userDefinedIndex;
    }

    public String getCharSetChatacters(int index) {
        return this.charsetCharacters[index];
    }

    public void setCharsetCharacters(int index, String string) {
        this.charsetCharacters[index] = string;
    }

    public String[] getCharsetNames() {
        return this.charsetNames;
    }
}

