/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.asciimation.action.OpenAnimationAction;
import de.jave.gui.GStatusLabel;
import de.jave.gui.StatusBar;
import de.jave.gui.button.ModernToggleButtonFactory;
import de.jave.gui.dialog.disposeanimation.AbstractDialogDisposeContext;
import de.jave.gui.dialog.disposeanimation.DialogDisposeRectangleAnimator;
import de.jave.gui.io.AcceptAllFileFilter;
import de.jave.gui.io.CompositeExtensionFileFilter;
import de.jave.gui.io.ExtensionFileFilters;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.FileSelection;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import de.jave.gui.splash.IStartupMonitor;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.BrushTool;
import de.jave.jave.CharacterSets;
import de.jave.jave.CompressedDocumentState;
import de.jave.jave.DocumentDefaultTitleFactory;
import de.jave.jave.DocumentManager;
import de.jave.jave.FractalTool;
import de.jave.jave.FunctionPlotTool;
import de.jave.jave.IToolManager;
import de.jave.jave.JaveLogFileParser;
import de.jave.jave.JaveSelection;
import de.jave.jave.JaveStatusFile;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.ReplaceCharacterDialog;
import de.jave.jave.SelectionTool;
import de.jave.jave.TextboxDialog;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkTool;
import de.jave.jave.actions.JaveActions;
import de.jave.jave.actions.JaveMenuBar;
import de.jave.jave.actions.JaveTopToolbar;
import de.jave.jave.actions.ResizeDocumentAction;
import de.jave.jave.actions.ShowVtViewerAction;
import de.jave.jave.actions.ToolBar;
import de.jave.jave.actions.performers.IDocumentSaveListener;
import de.jave.jave.actions.performers.SavePerformer;
import de.jave.jave.actions.preferences.JavePreferencesAction;
import de.jave.jave.algorithm.rectangle.RectangleStyle;
import de.jave.jave.algorithm.replaceillegal.AsciiReplaceIllegal;
import de.jave.jave.application.about.JaveAboutDialog;
import de.jave.jave.ascii3d.Render3DTool;
import de.jave.jave.brace.BraceLocationDialog;
import de.jave.jave.browser.AsciiThumbnailBrowser;
import de.jave.jave.browser.JaveFileType;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.open.JaveDropFileOpener;
import de.jave.jave.open.OpenImageFilePerformer;
import de.jave.jave.plate.AnimationDocumentEditor;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.GameDocumentEditor;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.TextDocumentEditor;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.jave.tool.dialog.ToolOptionsDialog;
import de.jave.jave.tool.text.TextTool;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.jave.watermark.WatermarkImageFile;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.lib.CharacterPlate;
import de.jave.lib.gui.GuiUtilities;
import de.jave.lib.gui.IStatusDisplay;
import de.jave.maxosx.IMacOsXApplicationCallbacks;
import de.jave.preferences.JavePreferences;
import de.jave.util.RecentFileOpenListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.swing.component.Gap;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.dialog.message.MessageDialogUtilities;
import net.disy.commons.swing.dialog.message.MessageUserDialogConfiguration;
import net.disy.commons.swing.dialog.message.YesNoCancel;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.dialog.userdialog.buttons.DialogButtonConfigurationFactory;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class JavEApplication
implements ActionListener,
RecentFileOpenListener,
IToolManager {
    private final JaveMainPanel mainPanel;
    private final DocumentManager documentManager;
    private final ToolBar toolBar;
    private GStatusLabel sizeLabel;
    private GStatusLabel lInsert;
    private ToolOptionsDialog optionsDialog;
    private TextboxDialog textboxDialog;
    private ReplaceCharacterDialog replaceCharacterDialog;
    private AsciiThumbnailBrowser thumbnailBrowser;
    private final JaveActions actions;
    private JaveMenuBar menuBar;
    private final StatusBar status;
    private final JFrame frame = new JFrame();
    private final JavePreferences javePreferences;
    private final JaveApplicationPreferences applicationPreferences;
    private final JaveTopToolbar topToolbar;
    private final BooleanModel toolOptionsDialogVisibilityModel;
    private final PlatePreferences platePreferences;
    private JToggleButton toggleOptionsDialogButton;

    public JavEApplication() {
        this.frame.setTitle(JaveTitleProvider.TITLE);
        this.status = new StatusBar();
        this.frame.setIconImage(JaveIcons.JAVE_ICON_IMAGE);
        this.javePreferences = new JavePreferences();
        this.applicationPreferences = new JaveApplicationPreferences(this.javePreferences);
        FileModel currectDirectoryModel = this.applicationPreferences.getCurrectDirectoryModel();
        this.toolOptionsDialogVisibilityModel = new BooleanModel();
        this.toolOptionsDialogVisibilityModel.setValue(true);
        DialogDisposeRectangleAnimator.attachTo(this.toolOptionsDialogVisibilityModel, new AbstractDialogDisposeContext(){

            @Override
            public JFrame getParentFrame() {
                return JavEApplication.this.frame;
            }

            @Override
            public Rectangle getTargetAreaOnScreen() {
                return this.getAreaOnScreen(JavEApplication.this.toggleOptionsDialogButton);
            }

            @Override
            public Rectangle getDialogAreaOnScreen() {
                return this.getAreaOnScreen(JavEApplication.this.optionsDialog.getWindow());
            }
        });
        this.documentManager = new DocumentManager(currectDirectoryModel, this.applicationPreferences.getDefaultColorSchemeModel());
        this.platePreferences = new PlatePreferences(this.javePreferences);
        MouseCharacterModel mouseCharacterModel = new MouseCharacterModel();
        this.mainPanel = new JaveMainPanel(this, this.status, mouseCharacterModel);
        this.mainPanel.getActiveEditorModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                JavEApplication.this.updateFrameTitle();
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.actions = new JaveActions(this, this.javePreferences, this.toolOptionsDialogVisibilityModel, this.platePreferences, this.applicationPreferences.getDisplayFontModel(), this.applicationPreferences.getDefaultColorSchemeModel());
        this.topToolbar = new JaveTopToolbar(this, this.actions);
        this.frame.getContentPane().add((Component)this.topToolbar.getContent(), "North");
        this.toolBar = new ToolBar(this, this.applicationPreferences, this.platePreferences);
        this.frame.getContentPane().add((Component)this.toolBar.getContent(), "West");
        this.frame.getContentPane().add((Component)this.mainPanel.getContent(), "Center");
        JaveDropFileOpener.attachTo(this, this.mainPanel.getContent());
        JPanel bottomPanel = this.createBottomPanel();
        this.frame.getContentPane().add((Component)bottomPanel, "South");
        this.frame.pack();
    }

    public JaveActions getActions() {
        return this.actions;
    }

    public void performSetColorScheme(ColorScheme colorScheme) {
        ColorScheme old;
        PlateDocument doc = this.mainPanel.getDocument();
        if (doc != null && (old = doc.getColorScheme()) != colorScheme) {
            doc.setColorScheme(colorScheme);
            this.mainPanel.saveCurrentState("change color");
        }
        this.mainPanel.repaint();
    }

    public boolean startupRecovery(IStartupMonitor startupMonitor) {
        if (!JaveStatusFile.exists()) {
            return false;
        }
        String[] statusData = JaveStatusFile.load();
        if (statusData == null || statusData[1].equals("0")) {
            return false;
        }
        String fileCountString = Integer.parseInt(statusData[1]) > 1 ? statusData[1] + " files" : "1 file";
        String question = "It seems JavE has crashed somewhen after\n" + statusData[0] + " with " + fileCountString + " open.\n\n" + "Do you want JavE to continue where the interruption occured?";
        Component parentComponent = null;
        Message message = new Message("JavE - Crash Recovery", question, MessageType.WARNING);
        startupMonitor.dispose();
        YesNoCancel result = MessageDialogUtilities.showYesNoCancelDialog(parentComponent, message);
        if (result == YesNoCancel.CANCEL) {
            System.exit(0);
        }
        if (result == YesNoCancel.NO) {
            return false;
        }
        this.switchToSelectonTool();
        PlateDocument doc = null;
        for (int i = 2; i < statusData.length; i += 2) {
            CompressedDocumentState[] docStates;
            doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
            doc.setModified(true);
            if (statusData[i] != null && statusData[i].length() > 0) {
                doc.setFile(new File(statusData[i]));
            }
            ColorScheme colorScheme = (docStates = JaveLogFileParser.load(new File(statusData[i + 1]))).length > 0 ? docStates[0].getColorScheme() : this.applicationPreferences.getDefaultColorSchemeModel().getValue();
            TextDocumentEditor editor = new TextDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel(), colorScheme);
            this.mainPanel.addPlate(editor);
            if (docStates == null || docStates.length <= 0) continue;
            for (int j = 0; j < docStates.length; ++j) {
                doc.getUndoManager().saveCurrentState(docStates[j]);
            }
            doc.setDocumentState(docStates[docStates.length - 1]);
        }
        this.updateStatusFile();
        return true;
    }

    public void startupMenuBar() {
        this.menuBar = new JaveMenuBar(this, this.javePreferences, this.mainPanel, this.actions, this.applicationPreferences.getRecentFileList(), this.applicationPreferences, this.platePreferences);
        this.frame.setJMenuBar(this.menuBar);
        this.updateUndoRedo();
        this.updateSelectionMenu();
    }

    public void startupFinish2() {
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JavEApplication.this.performExit(JavEApplication.this.frame);
            }
        });
        this.frame.setBounds(this.applicationPreferences.getApplicationFrameBounds());
        this.frame.setExtendedState(this.applicationPreferences.getApplicationFrameState());
        this.frame.setVisible(true);
    }

    public void startupFinish3() {
        this.applicationPreferences.getRecentFileList().setRecentFileOpenListener(this);
    }

    public void startupOptionsDialog() {
        this.optionsDialog = new ToolOptionsDialog(this, false, this.toolOptionsDialogVisibilityModel);
        this.optionsDialog.setTool(this.mainPanel.getCurrentTool());
        this.optionsDialog.pack();
        this.optionsDialog.setLocation(this.applicationPreferences.getToolDialogLocation());
        this.optionsDialog.show();
        this.optionsDialog.toFront();
    }

    public void updateSelectionMenu() {
        if (this.menuBar != null) {
            this.menuBar.updateSelectionMenu(this.mainPanel.hasSelection());
        }
    }

    public void updateFrameTitle() {
        this.mainPanel.updateAllDocumentTitles();
        IDocumentEditor activeEditor = this.mainPanel.getActiveEditorModel().getActiveEditor();
        if (activeEditor == null) {
            this.frame.setTitle(JaveTitleProvider.TITLE);
        } else {
            String title = DocumentEditorTitleFactory.createEditorFrameTitle(activeEditor);
            this.frame.setTitle(JaveTitleProvider.TITLE + " - " + title);
        }
    }

    private final JPanel createBottomPanel() {
        this.sizeLabel = new GStatusLabel("");
        this.sizeLabel.setToolTipText("Document Size");
        this.sizeLabel.addActionListener(this);
        this.toggleOptionsDialogButton = ModernToggleButtonFactory.createModernToggleButton(this.actions.getToolOptionsDialogToggleAction());
        this.toggleOptionsDialogButton.setPreferredSize(new Dimension(24, 19));
        this.toggleOptionsDialogButton.setText(null);
        this.mainPanel.getActiveEditorModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                JavEApplication.this.updateSizeLabelToDocumentSize();
            }
        });
        this.updateSizeLabelToDocumentSize();
        this.lInsert = new GStatusLabel("OVR");
        this.lInsert.setToolTipText("Insert / Overwrite");
        this.lInsert.addActionListener(this);
        JPanel panel = new JPanel(new GridDialogLayout(5, false));
        panel.add((Component)this.status, GridDialogLayoutData.FILL_HORIZONTAL);
        panel.add(this.toggleOptionsDialogButton);
        panel.add(this.sizeLabel);
        panel.add(this.lInsert);
        panel.add(new Gap(12, 1));
        return panel;
    }

    public void updateSizeLabelToDocumentSize() {
        if (this.sizeLabel == null) {
            return;
        }
        IDocumentEditor editor = this.mainPanel.getActiveEditorModel().getActiveEditor();
        Dimension size = editor == null ? null : editor.getPlate().getDocumentSize();
        String text = size == null ? "      " : size.width + " x " + size.height;
        this.sizeLabel.setText(text);
    }

    public void packOptionsDialog() {
        this.optionsDialog.pack();
    }

    public void hideToolOptionsDialog() {
        this.optionsDialog.setVisible(false);
    }

    public void showToolOptionsDialog() {
        this.optionsDialog.setVisible(true);
    }

    public void doSelectionDelete() {
        if (!this.mainPanel.hasSelection()) {
            this.mainPanel.selectAll();
        }
        this.mainPanel.getCurrentTool().setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        this.mainPanel.unselect();
        this.mainPanel.saveCurrentState("delete");
    }

    public void doSelectionShrink() {
        if (!this.mainPanel.hasSelection()) {
            this.mainPanel.selectAll();
        }
        this.mainPanel.shrinkSelection();
        this.mainPanel.saveCurrentState("shrink selection");
    }

    public void doSelectionExpand() {
        if (!this.mainPanel.hasSelection()) {
            return;
        }
        this.mainPanel.expandSelection();
        this.mainPanel.saveCurrentState("expand selection");
    }

    public void doSelectionToBrush() {
        if (!this.mainPanel.hasSelection()) {
            return;
        }
        CharacterPlate cp = this.mainPanel.getContentOfInterest().getContent();
        if (cp.getWidth() > 10 || cp.getHeight() > 8 || cp.getHeight() * cp.getWidth() > 35) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("JavE", "The selection is too big.\nIt can not be used as a brush.", MessageType.INFORMATION));
            return;
        }
        this.setTool(14);
        ((BrushTool)this.mainPanel.getCurrentTool()).setBrush(cp);
    }

    public void doReplaceCharacter() {
        if (this.replaceCharacterDialog == null) {
            this.replaceCharacterDialog = new ReplaceCharacterDialog(this.mainPanel, this.frame);
            GuiUtilities.centerOnScreen(this.replaceCharacterDialog.getDialog());
        }
        this.replaceCharacterDialog.show();
    }

    public void doRepairIllegalReplace() {
        JaveSelection sel = this.mainPanel.getContentOfInterest();
        if (sel == null) {
            return;
        }
        int[] result = AsciiReplaceIllegal.replaceIllegal(sel);
        int count = result[0];
        int replaced = result[1];
        this.mainPanel.repaint();
        this.mainPanel.saveCurrentState("replace illegal characters");
        if (count == 0) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "There are no illegal characters.", MessageType.INFORMATION));
        } else if (replaced == 0) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "Unable to find substitutes for " + count + " illegal characters.", MessageType.INFORMATION));
        } else if (replaced < count) {
            if (count == 1) {
                MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "Replaced 1 illegal character.\nUnable to find substitutes for the remaining " + (count - replaced) + ".", MessageType.INFORMATION));
            } else {
                MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "Replaced " + replaced + " illegal characters.\nUnable to find substitutes for the remaining " + (count - replaced) + ".", MessageType.INFORMATION));
            }
        } else if (count == 1) {
            this.status.showStatus("Replaced 1 of " + count + " occurence.");
        } else {
            this.status.showStatus("Replaced " + replaced + " of " + count + " occurrences.");
        }
    }

    public void doRepairIllegalRemove() {
        CharacterPlate cp = this.mainPanel.getContentOfInterest().getContent();
        if (cp == null) {
            return;
        }
        int count = 0;
        int h = cp.getHeight();
        int w = cp.getWidth();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (CharacterSets.isLegal(cp.get(x, y))) continue;
                cp.setForce(x, y, ' ');
                ++count;
            }
        }
        if (count == 0) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("Remove illegal characters", "There are no illegal characters.", MessageType.INFORMATION));
        } else if (count == 1) {
            this.status.showStatus("Removed 1 occurence.");
        } else {
            this.status.showStatus("Removed " + count + " occurrences.");
        }
        this.mainPanel.repaint();
        this.mainPanel.saveCurrentState("remove illegal characters");
    }

    public boolean performExit(Component parentComponent) {
        boolean success = this.doCloseAll(parentComponent);
        if (!success) {
            return false;
        }
        if (!JaveStatusFile.delete()) {
            System.err.println("Unable to delete Status-File!");
        }
        JaveStatusFile.deleteAllLogFiles();
        this.applicationPreferences.setApplicationFrameState(this.frame.getExtendedState(), this.frame.getBounds());
        this.applicationPreferences.setToolDialogLocation(this.optionsDialog.getLocation());
        this.javePreferences.flush();
        this.applicationPreferences.flush();
        this.platePreferences.flush();
        this.applicationPreferences.getRecentFileList().flush();
        this.dispose();
        System.exit(0);
        return true;
    }

    public void doNew() {
        PlateDocument doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
        TextDocumentEditor editor = new TextDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel(), this.applicationPreferences.getDefaultColorSchemeModel().getValue());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    public void updateStatusFile() {
        JaveStatusFile.saveLog(this.documentManager);
    }

    public boolean doClose(Component parentComponent) {
        IDocumentEditor editor = this.mainPanel.getEditor();
        if (!editor.isModified()) {
            this.documentManager.closeCurrentDocument();
            this.mainPanel.closeCurrentEditor();
            this.updateStatusFile();
            return true;
        }
        boolean success = SavePerformer.performSaveBeforeClose(parentComponent, editor, this.applicationPreferences.getRecentFileList(), this.documentManager.getCurrentDirectoryModel(), this.status, this.getDocumentSaveListener());
        if (success) {
            return this.doClose(parentComponent);
        }
        return false;
    }

    public boolean doCloseAll(Component parentComponent) {
        boolean success = true;
        while (this.mainPanel.getEditor() != null && success) {
            success = this.doClose(parentComponent);
            if (success) continue;
            return false;
        }
        return success;
    }

    public void close(PlateDocument doc) {
        int index = this.documentManager.getIndexOf(doc);
        if (index < 0) {
            return;
        }
        this.documentManager.closeDocument(index);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    public void doSelectionBraces() {
        if (!this.mainPanel.hasSelection()) {
            return;
        }
        BraceLocationDialog g = new BraceLocationDialog(this.frame);
        int loc = g.getBraceLocation();
        if (loc == -1) {
            return;
        }
        Rectangle region = this.mainPanel.getSelectionRegion();
        this.mainPanel.dropSelection();
        switch (loc) {
            case 0: {
                this.bracesTop(region);
                break;
            }
            case 2: {
                this.bracesLeft(region);
                break;
            }
            case 3: {
                this.bracesRight(region);
                break;
            }
            case 1: {
                this.bracesBottom(region);
            }
        }
    }

    protected void bracesRight(Rectangle region) {
        int x = region.x + region.width;
        int y = region.y;
        int w = 2;
        int h = region.height;
        CharacterPlate cp = new CharacterPlate(2, h);
        if (h == 1) {
            cp.setForce(0, 0, '}');
        } else {
            cp.setForce(0, 0, '\\');
            cp.setForce(0, h - 1, '/');
            if (h >= 5) {
                for (int i = 1; i < h - 1; ++i) {
                    cp.setForce(0, i, '|');
                }
            }
            if (h == 2) {
                cp.setForce(1, 0, '_');
            } else if (h == 3) {
                cp.setForce(1, 1, '>');
            } else if (h == 4) {
                cp.setForce(1, 1, '_');
                cp.setForce(0, 1, '|');
                cp.setForce(0, 2, '|');
            } else {
                cp.setForce(1, (h - 1) / 2, '>');
                cp.setForce(0, (h - 1) / 2, ' ');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, 2, h);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace right");
    }

    protected void bracesLeft(Rectangle region) {
        int x = region.x - 2;
        int y = region.y;
        int w = 2;
        int h = region.height;
        CharacterPlate cp = new CharacterPlate(2, h);
        if (h == 1) {
            cp.setForce(1, 0, '{');
        } else {
            cp.setForce(1, 0, '/');
            cp.setForce(1, h - 1, '\\');
            if (h >= 5) {
                for (int i = 1; i < h - 1; ++i) {
                    cp.setForce(1, i, '|');
                }
            }
            if (h == 2) {
                cp.setForce(0, 0, '_');
            } else if (h == 3) {
                cp.setForce(0, 1, '<');
            } else if (h == 4) {
                cp.setForce(0, 1, '_');
                cp.setForce(1, 1, '|');
                cp.setForce(1, 2, '|');
            } else {
                cp.setForce(0, (h - 1) / 2, '<');
                cp.setForce(1, (h - 1) / 2, ' ');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, 2, h);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace left");
    }

    protected void bracesTop(Rectangle region) {
        int x = region.x;
        int y = region.y - 2;
        int w = region.width;
        int h = 2;
        CharacterPlate cp = new CharacterPlate(w, 2);
        if (w == 1) {
            cp.setForce(0, 1, '^');
        } else {
            cp.setForce(0, 1, '/');
            cp.setForce(w - 1, 1, '\\');
            if (w > 5) {
                for (int i = 1; i < w - 1; ++i) {
                    cp.setForce(i, 0, '_');
                }
                cp.setForce(w / 2 - 1, 0, '/');
                cp.setForce(w / 2, 0, '\\');
            } else if (w == 3) {
                cp.setForce(1, 0, '|');
            } else if (w == 4) {
                cp.setForce(1, 0, '|');
                cp.setForce(2, 0, '_');
            } else if (w == 5) {
                cp.setForce(1, 0, '_');
                cp.setForce(2, 0, '|');
                cp.setForce(3, 0, '_');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, w, 2);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace top");
    }

    protected void bracesBottom(Rectangle region) {
        int x = region.x;
        int y = region.y + region.height;
        int w = region.width;
        int h = 2;
        CharacterPlate cp = new CharacterPlate(w, 2);
        if (w == 1) {
            cp.setForce(0, 0, 'V');
        } else {
            cp.setForce(0, 0, '\\');
            cp.setForce(w - 1, 0, '/');
            if (w > 5) {
                for (int i = 1; i < w - 1; ++i) {
                    cp.setForce(i, 0, '_');
                }
                cp.setForce(w / 2 - 1, 1, '\\');
                cp.setForce(w / 2, 1, '/');
                cp.setForce(w / 2 - 1, 0, ' ');
                cp.setForce(w / 2, 0, ' ');
            } else if (w == 3) {
                cp.setForce(1, 0, '_');
                cp.setForce(1, 1, '|');
            } else if (w == 4) {
                cp.setForce(2, 0, '_');
                cp.setForce(1, 0, '_');
                cp.setForce(1, 1, '|');
            } else if (w == 5) {
                cp.setForce(1, 0, '_');
                cp.setForce(2, 0, '_');
                cp.setForce(3, 0, '_');
                cp.setForce(2, 1, '|');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, w, 2);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace bottom");
    }

    @Override
    public void openRecentFile(Component parentComponent, File file) {
        this.open(parentComponent, file);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Window parentComponent = GuiUtilities.getWindowForComponent(evt);
        this.mainPanel.requestFocus();
        Object source = evt.getSource();
        if (source == this.sizeLabel) {
            ResizeDocumentAction resizeAction = this.actions.getResizeAction();
            if (resizeAction.isEnabled()) {
                resizeAction.actionPerformed(evt);
            }
            return;
        }
        if (source == this.lInsert) {
            this.toggleInsert();
        } else {
            System.err.println("JavE: source unknown in actionPerformed!" + source);
        }
    }

    public void editTextBox(String content, Point location, RectangleStyle textboxStyle) {
        if (this.textboxDialog == null) {
            this.textboxDialog = new TextboxDialog(this, content, location);
            GuiUtilities.centerOnScreen(this.textboxDialog.getDialog());
        } else {
            this.textboxDialog.setContent(content);
            this.textboxDialog.setLocation(location);
        }
        this.textboxDialog.setTextboxStyle(textboxStyle);
        this.textboxDialog.show();
    }

    public void showAboutDialog() {
        JaveAboutDialog.showAboutDialog(this.frame);
    }

    public void updateUndoRedo() {
        boolean canUndo = this.mainPanel.canUndo();
        boolean canRedo = this.mainPanel.canRedo();
        String undoName = null;
        String redoName = null;
        if (canUndo) {
            undoName = this.mainPanel.getUndoActionName();
        }
        if (canRedo) {
            redoName = this.mainPanel.getRedoActionName();
        }
        if (this.menuBar != null) {
            this.menuBar.updateUndoRedoMenu(canUndo, undoName, canRedo, redoName);
        }
        if (this.topToolbar != null) {
            this.topToolbar.updateUndoRedo(canUndo, canRedo);
        }
    }

    public void doRedo() {
        this.mainPanel.redo();
        this.updateUndoRedo();
        this.updateSelectionMenu();
        this.mainPanel.requestFocus();
    }

    public void doUndo() {
        this.mainPanel.undo();
        this.updateUndoRedo();
        this.updateSelectionMenu();
        this.mainPanel.requestFocus();
    }

    public void doDebugCrash() {
        MessageUserDialogConfiguration configuration = new MessageUserDialogConfiguration(new Message("JavE", "Crashing is not fun!!\n\nDo you really want the program to crash now?", MessageType.WARNING), DialogButtonConfigurationFactory.createYesCancel());
        UserDialog userDialog = new UserDialog((Component)this.frame, configuration);
        userDialog.show();
        if (userDialog.isCanceled()) {
            return;
        }
        System.err.println("===============================================");
        System.err.println("By your personal demand:");
        System.err.println("JavE is now crashing w/o doing all the cleanup!");
        System.err.println(" - Good bye.");
        System.err.println("===============================================");
        System.exit(1);
    }

    public void doDoc2Watermark() {
        if (this.mainPanel.hasSelection()) {
            this.mainPanel.dropSelection();
        }
        CharacterPlate cp = this.mainPanel.getContentOfInterest().getContent();
        Font font = this.mainPanel.getPlate().getFont();
        ColorScheme colorScheme = this.mainPanel.getPlate().getDocument().getColorScheme();
        BufferedImage image = AsciiToThumbnailConverter.convert(cp, font.getSize(), font, colorScheme.getColorPlateBackground(), colorScheme.getColorText(), this.isConnectedLinesView());
        cp.clear();
        this.mainPanel.setContentOfInterest(cp);
        this.mainPanel.saveCurrentState("clear content");
        this.setWatermarkImage(new WatermarkImageFile(image));
    }

    public void setWatermarkImage(WatermarkImageFile imageFile) {
        this.setTool(19);
        WatermarkTool tool = (WatermarkTool)this.mainPanel.getToolManager().getTool(19);
        tool.setImage(imageFile);
        tool.fit();
        this.toolBar.setWatermarkVisible(true);
    }

    public void doLoadWatermark() {
        this.setTool(19);
        this.toolBar.setWatermarkVisible(true);
        WatermarkTool tool = (WatermarkTool)this.mainPanel.getToolManager().getTool(19);
        tool.performLoadImage(this.frame);
    }

    public boolean isConnectedLinesView() {
        return this.platePreferences.getConnectedLinesViewModel().getValue();
    }

    public IDocumentSaveListener getDocumentSaveListener() {
        return new IDocumentSaveListener(){

            @Override
            public void savePerformed() {
                JavEApplication.this.menuBar.setRevertEnabled(JavEApplication.this.mainPanel.getDocument().hasFile());
                JavEApplication.this.updateFrameTitle();
            }
        };
    }

    public void doBrowse() {
        if (this.thumbnailBrowser != null) {
            this.thumbnailBrowser.setVisible(true);
        } else {
            this.thumbnailBrowser = new AsciiThumbnailBrowser(this.frame, this, this.getDocumentManager().getCurrentDirectoryModel());
            this.thumbnailBrowser.show();
        }
    }

    public void doZoomPlus() {
        this.mainPanel.zoomIn();
    }

    public void doZoomMinus() {
        this.mainPanel.zoomOut();
    }

    public void doRevert(Component parentComponent) {
        PlateDocument doc = this.documentManager.getCurrentDocument();
        boolean ok = MessageDialogUtilities.showOkCancelDialog(parentComponent, new Message("JavE", "Lose all changes since your last save?", MessageType.QUESTION));
        if (ok) {
            doc.setModified(false);
            File file = doc.getFile();
            this.doClose(parentComponent);
            this.open(parentComponent, file);
        }
    }

    public void doOpen(Component parentComponent) {
        FileSelection fileSelection = FileChooserUtilities.performOpenFileChooser(parentComponent, new IFileChooserConfiguration(){

            @Override
            public FileModel getCurrentDirectoryModel() {
                return JavEApplication.this.documentManager.getCurrentDirectoryModel();
            }

            @Override
            public String getSaveDialogTitle() {
                return null;
            }

            @Override
            public String getOpenDialogTitle() {
                return "Open ASCII File / Image / JMOV-animation / vt";
            }

            @Override
            public SmartFileFilter[] getFileFilters() {
                return new SmartFileFilter[]{new CompositeExtensionFileFilter("All supported Files", ExtensionFileFilters.TXT, ExtensionFileFilters.SUPPORTED_IMAGES, ExtensionFileFilters.JMOV, ExtensionFileFilters.VT), ExtensionFileFilters.TXT, ExtensionFileFilters.SUPPORTED_IMAGES, ExtensionFileFilters.JMOV, ExtensionFileFilters.VT, new AcceptAllFileFilter()};
            }

            @Override
            public String getFileNameSuggestion() {
                return null;
            }

            @Override
            public boolean isMultipleOpenFileSelectionAllowed() {
                return false;
            }
        });
        if (fileSelection.isEmpty()) {
            return;
        }
        this.open(parentComponent, fileSelection.getFile());
    }

    public void open(Component parentComponent, File file) {
        JaveFileType fileType = JaveFileType.guessType(file);
        if (fileType == JaveFileType.ANIMATION) {
            JaveAnimationFile animationFile = OpenAnimationAction.open(file, parentComponent);
            if (animationFile == null) {
                return;
            }
            this.applicationPreferences.getRecentFileList().add(file);
            this.openJaveAnimation(animationFile);
            return;
        }
        if (fileType == JaveFileType.VT) {
            ShowVtViewerAction action = new ShowVtViewerAction(this.applicationPreferences.getCurrectDirectoryModel());
            action.execute(parentComponent, file);
            return;
        }
        if (fileType == JaveFileType.RASTER_IMAGE) {
            OpenImageFilePerformer.performOpenImageFile(parentComponent, file, this, this.actions, this.mainPanel.getToolManager());
            return;
        }
        if (this.documentManager.isAlreadyOpen(file)) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "The selected file is already loaded.", MessageType.INFORMATION));
            return;
        }
        try {
            PlateDocument doc = this.documentManager.load(file, this.applicationPreferences.getRecentFileList());
            TextDocumentEditor editor = new TextDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(file.getName()), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel(), this.applicationPreferences.getDefaultColorSchemeModel().getValue());
            this.mainPanel.addPlate(editor);
            this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
            doc.getUndoManager().getLogFile().append(this.mainPanel.getDocumentState(null));
            this.updateStatusFile();
            this.status.showStatus("File loaded.");
            return;
        }
        catch (IOException e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error loading file:\n" + e.toString(), MessageType.ERROR, e));
            this.status.showStatus("Error loading File: " + e);
            return;
        }
        catch (OutOfMemoryError e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error loading file: The file is too big.", MessageType.ERROR));
            this.status.showStatus("Error loading File: " + e);
            return;
        }
    }

    public void openJaveAnimation(JaveAnimationFile animationFile) {
        PlateDocument document = this.documentManager.createNew(this.applicationPreferences.getDefaultAnimationSize());
        String stopGapName = DocumentDefaultTitleFactory.createDefaultDocumentTitle(animationFile.getFile());
        AnimationDocumentEditor editor = new AnimationDocumentEditor(stopGapName, animationFile, this, document, this.platePreferences, this.applicationPreferences, this.mainPanel.getToolManager(), new AnimationExportPreferences(this.javePreferences), this.applicationPreferences.getCurrectDirectoryModel());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    public void doFractal() {
        FractalTool dt = new FractalTool(this, this.applicationPreferences);
        dt.show();
    }

    public void doRender3D() {
        Render3DTool dt = new Render3DTool(this, this.applicationPreferences);
        dt.show();
    }

    public void doFunctionPlotter() {
        FunctionPlotTool dt = new FunctionPlotTool(this, this.applicationPreferences);
        dt.show();
    }

    public void doPreviousDocument() {
        int index = this.documentManager.getCurrentDocumentIndex() - 1;
        if (index < 0) {
            index = this.documentManager.getSize() - 1;
        }
        this.setCurrentDocument(index);
    }

    public void doNextDocument() {
        int index = this.documentManager.getCurrentDocumentIndex() + 1;
        if (index >= this.documentManager.getSize()) {
            index = 0;
        }
        this.setCurrentDocument(index);
    }

    public void setCurrentDocument(int index) {
        PlateDocument d = this.mainPanel.getDocument();
        if (d != null) {
            d.documentHiding();
        }
        if (index < 0 || index >= this.documentManager.getSize()) {
            this.updateUndoRedo();
            return;
        }
        this.documentManager.setCurrentDocument(index);
        PlateDocument currentDoc = this.documentManager.getCurrentDocument();
        this.mainPanel.setCurrentEditor(index);
        this.updateUndoRedo();
        this.mainPanel.repaint();
        currentDoc.documentShowing();
    }

    public void selectAll() {
        this.mainPanel.selectAll();
        this.switchToSelectonTool();
        this.mainPanel.saveCurrentState("select all");
    }

    public void switchToSelectonTool() {
        this.setTool(12);
        ((SelectionTool)this.mainPanel.getCurrentTool()).synchronizeToSelection();
    }

    @Override
    public void switchToTextTool(int x, int y) {
        this.setTool(10);
        ((TextTool)this.mainPanel.getCurrentTool()).setCursorLocation(x, y);
    }

    public void switchToTextTool(char ch, int x, int y) {
        this.setTool(10);
        TextTool textTool = (TextTool)this.mainPanel.getCurrentTool();
        textTool.setCursorLocation(x, y);
        textTool.checkSize();
        textTool.charEntered(ch);
    }

    public void switchToTextTool() {
        this.setTool(10);
    }

    public SelectionTool getSelectionTool() {
        return (SelectionTool)this.mainPanel.getToolManager().getTool(12);
    }

    public void setTool(int toolIndex) {
        if (this.mainPanel.getToolManager().getCurrentToolIndex() == toolIndex) {
            return;
        }
        Tool newTool = this.mainPanel.getToolManager().getTool(toolIndex);
        if (this.optionsDialog != null) {
            this.optionsDialog.setTool(newTool);
        }
        this.toolBar.selectToolButton(toolIndex);
        this.mainPanel.setCurrentTool(newTool);
        this.updateSelectionMenu();
    }

    public Plate pasteAsNewDocument(CharacterPlate content) {
        return this.pasteAsNewDocument(content, null);
    }

    public Plate pasteAsNewDocument(CharacterPlate content, String documentName) {
        PlateDocument doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
        String stopGapName = DocumentDefaultTitleFactory.createDefaultDocumentTitle(documentName);
        doc.setContent(content);
        TextDocumentEditor editor = new TextDocumentEditor(stopGapName, doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel(), this.applicationPreferences.getDefaultColorSchemeModel().getValue());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
        return editor.getPlate();
    }

    public Plate pasteAsNewGameDocument(CharacterPlate content, String documentName) {
        PlateDocument doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
        doc.setContent(content);
        GameDocumentEditor editor = new GameDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(documentName), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel(), this.applicationPreferences.getDefaultColorSchemeModel());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
        return editor.getPlate();
    }

    public void pasteAsNewSelection(CharacterPlate content, int x, int y) {
        this.pasteAsNewSelection(content, new Point(x, y));
    }

    public void pasteAsNewSelection(CharacterPlate content, Point location) {
        if (this.mainPanel.getDocument() == null) {
            this.pasteAsNewDocument(content);
            return;
        }
        this.mainPanel.pasteAsNewSelection(content, location);
        this.switchToSelectonTool();
        this.updateSelectionMenu();
        this.mainPanel.saveCurrentState("paste");
    }

    public void pasteAsNewSelection(CharacterPlate content) {
        this.pasteAsNewSelection(content, this.mainPanel.getPasteLocation());
    }

    protected void toggleInsert() {
        boolean insert = !Tool.isInsert();
        this.lInsert.setText(insert ? "INS" : "OVR");
        this.mainPanel.getCurrentTool().setInsert(insert);
        this.mainPanel.repaintCursor();
    }

    public void showTextboxDialog() {
        if (this.textboxDialog == null) {
            this.textboxDialog = new TextboxDialog(this);
            GuiUtilities.centerOnScreen(this.textboxDialog.getDialog());
        }
        this.textboxDialog.show();
    }

    public void dispose() {
        this.frame.dispose();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void toFront() {
        this.frame.toFront();
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public JaveMainPanel getMainPanel() {
        return this.mainPanel;
    }

    public JaveApplicationPreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    public IStatusDisplay getStatusDisplay() {
        return this.status;
    }

    public IMacOsXApplicationCallbacks getMaxOsXApplicationCallbacks() {
        return new IMacOsXApplicationCallbacks(){

            @Override
            public void performShowPreferencesDialog() {
                JavePreferencesAction.performShowPreferencesDialog(JavEApplication.this.frame, JavEApplication.this.applicationPreferences, JavEApplication.this.platePreferences);
            }

            @Override
            public boolean performShowExitDialog() {
                return JavEApplication.this.performExit(JavEApplication.this.frame);
            }

            @Override
            public void performShowAboutDialog() {
                JaveAboutDialog.showAboutDialog(JavEApplication.this.frame);
            }
        };
    }
}

