/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.awt.Component;
import java.io.File;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public class JaveConfigurationFileLoader {
    static final String CONFIGURATION_FOLDER_NAME = "config";
    private final Component parentComponent;

    public JaveConfigurationFileLoader(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public void initConfigFile(IJaveInitializable confy) {
        block2: {
            IJavaInitializationContext context = new IJavaInitializationContext(){

                @Override
                public File getConfigurationFile(String fileName) {
                    File file = new File(JaveGlobalRessources.codeBase, fileName);
                    if (!file.exists()) {
                        file = new File(JaveGlobalRessources.codeBase, file.getName());
                    }
                    if (!file.exists()) {
                        file = new File(fileName);
                    }
                    if (file.exists()) {
                        return file;
                    }
                    if (JaveConfigurationFileLoader.this.parentComponent != null) {
                        MessageDialogFactory.showMessageDialog(JaveConfigurationFileLoader.this.parentComponent, new Message("JavE", "Error loading configuration from file:\n\t'" + file.getAbsolutePath() + "'\n" + "The file does not exist.\n\n" + " Using default configuration instead.", MessageType.ERROR));
                    }
                    return null;
                }
            };
            try {
                confy.initialize(context);
            }
            catch (Exception e) {
                if (this.parentComponent == null) break block2;
                MessageDialogFactory.showMessageDialog(this.parentComponent, new Message("JavE", "Error loading configuration.\n" + e.getMessage() + "\n\n" + " Using default configuration instead.", MessageType.ERROR, e));
            }
        }
    }

    public void checkConfigurationFolderExistant() throws ConfigurationException {
        File fallbackFolder;
        File configurationFolder = new File(JaveGlobalRessources.codeBase, CONFIGURATION_FOLDER_NAME);
        if (!configurationFolder.exists() && (fallbackFolder = new File(CONFIGURATION_FOLDER_NAME)).exists() && fallbackFolder.canRead()) {
            return;
        }
        if (!configurationFolder.exists()) {
            throw new ConfigurationException("Configuration folder '" + configurationFolder.getAbsolutePath() + "' does not exist.");
        }
        if (!configurationFolder.isDirectory()) {
            throw new ConfigurationException("Configuration folder '" + configurationFolder.getAbsolutePath() + "' is not a directory.");
        }
    }
}

