/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CompressedDocumentState;
import de.jave.jave.preferences.ColorScheme;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.disy.commons.core.io.IOUtilities;

public class JaveLogFileParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static CompressedDocumentState[] load(File file) {
        ArrayList<CompressedDocumentState> frames = new ArrayList<CompressedDocumentState>();
        BufferedReader reader = null;
        try {
            String s;
            reader = new BufferedReader(new FileReader(file));
            if (reader == null) {
                throw new IOException("Unable to open file '" + file.getAbsolutePath() + "'");
            }
            int frameCount = 0;
            CompressedDocumentState currentFrame = null;
            ColorScheme colorScheme = ColorScheme.BLACK_ON_WHITE;
            block17: while ((s = reader.readLine()) != null) {
                if (s.startsWith("J:")) {
                    if (currentFrame != null) {
                        frames.add(currentFrame);
                    }
                    currentFrame = new CompressedDocumentState();
                    currentFrame.setColorScheme(colorScheme);
                    ++frameCount;
                    try {
                        String content = s.substring(2);
                        currentFrame.setContent(content);
                    }
                    catch (Exception e) {
                        System.err.println("Warning: Error in format of JavE jmov-Logfile.");
                    }
                    continue;
                }
                if (s.startsWith("S:")) {
                    try {
                        int i1 = 2;
                        int i2 = s.indexOf(32, 3);
                        int i3 = s.indexOf(32, i2 + 1);
                        String s1 = s.substring(2, i2);
                        String s2 = s.substring(i2 + 1, i3);
                        String content = s.substring(i3 + 1);
                        int selectionX = Integer.parseInt(s1);
                        int selectionY = Integer.parseInt(s2);
                        currentFrame.setSelectionContent(content);
                        currentFrame.setSelectionLocation(selectionX, selectionY);
                    }
                    catch (Exception e) {
                        System.err.println("Warning: Error in format of JavE jmov-Logfile.");
                    }
                    continue;
                }
                if (s.startsWith("M:")) {
                    currentFrame.setSelectionMask(s.substring(2));
                    continue;
                }
                if (s.startsWith("T:")) {
                    String toolName = s.substring(2);
                    currentFrame.setTool(toolName);
                    continue;
                }
                if (s.startsWith("A:")) {
                    String actionName = s.substring(2);
                    currentFrame.setAction(actionName);
                    continue;
                }
                if (s.startsWith("|:")) {
                    int i1 = s.indexOf(32, 2);
                    try {
                        int cursorX = Integer.parseInt(s.substring(2, i1));
                        int cursorY = Integer.parseInt(s.substring(i1 + 1));
                        currentFrame.setCursorX(cursorX);
                        currentFrame.setCursorY(cursorY);
                    }
                    catch (Exception e) {
                        System.err.println("Warning: Error in format of JavE animation: " + s);
                    }
                    continue;
                }
                if (s.startsWith("^:")) {
                    int i1 = s.indexOf(32, 2);
                    try {
                        int scrollX = Integer.parseInt(s.substring(2, i1));
                        int scrollY = Integer.parseInt(s.substring(i1 + 1));
                        currentFrame.setScrollX(scrollX);
                        currentFrame.setScrollY(scrollY);
                    }
                    catch (Exception e) {
                        System.err.println("Warning: Error in format of JavE animation: " + s);
                    }
                    continue;
                }
                if (s.startsWith("+:")) {
                    try {
                        int duration = Integer.parseInt(s.substring(2));
                        currentFrame.setDuration(duration);
                    }
                    catch (Exception e) {
                        System.err.println("Warning: Error in format of JavE animation: " + s);
                    }
                    continue;
                }
                if (!s.startsWith("C:")) continue;
                s = s.substring(2);
                ColorScheme[] schemes = ColorScheme.getAll();
                for (int i = 0; i < schemes.length; ++i) {
                    if (!s.equals(schemes[i].getColorHex())) continue;
                    colorScheme = schemes[i];
                    currentFrame.setColorScheme(colorScheme);
                    continue block17;
                }
            }
            if (currentFrame != null) {
                frames.add(currentFrame);
            }
            IOUtilities.close(reader);
        }
        catch (FileNotFoundException e) {
            CompressedDocumentState[] compressedDocumentStateArray = null;
            return compressedDocumentStateArray;
        }
        catch (IOException e2) {
            CompressedDocumentState[] compressedDocumentStateArray = null;
            return compressedDocumentStateArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtilities.close(reader);
        }
        return frames.toArray(new CompressedDocumentState[frames.size()]);
    }
}

