/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.gui.GCheckbox;
import de.jave.gui.button.ModernToggleButtonFactory;
import de.jave.gui.layout.Gap;
import de.jave.jave.ArcToolGeneric;
import de.jave.jave.BezierToolGeneric;
import de.jave.jave.BrushTool;
import de.jave.jave.CloneTool;
import de.jave.jave.EllipseToolGeneric;
import de.jave.jave.EraserTool;
import de.jave.jave.FreehandSelectionTool;
import de.jave.jave.FreehandToolGeneric;
import de.jave.jave.JavEApplication;
import de.jave.jave.LineToolGeneric;
import de.jave.jave.PanTool;
import de.jave.jave.RectangleToolGeneric;
import de.jave.jave.SelectionTool;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkTool;
import de.jave.jave.figlet.FIGletTool;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.jave.tool.auxiliarylines.AuxiliaryLinesTool;
import de.jave.jave.tool.ellipsealgorithmic.EllipseAlgorithmicTool;
import de.jave.jave.tool.fill.FillTool;
import de.jave.jave.tool.freehandalgorrithmic.FreehandAlgorithmicTool;
import de.jave.jave.tool.linealgorithmic.LineAlgorithmicTool;
import de.jave.jave.tool.rectanglealgorithmic.RectangleAlgorithmicTool;
import de.jave.jave.tool.text.TextTool;
import de.jave.jave.watermark.IWatermarkPainter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.disy.commons.swing.button.SmartButtonGroup;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.widgets.HorizontalLine;

public class ToolBar {
    public static final int BRUSH_TOOL_INDEX = 14;
    public static final int DEFAULT_TOOL_INDEX = 0;
    public static final int SELECTION_TOOL_INDEX = 12;
    public static final int TEXT_TOOL_INDEX = 10;
    public static final int AUXILIARY_LINES_TOOL_INDEX = 20;
    public static final int WATERMARK_TOOL_INDEX = 19;
    public static final int TOOL_COUNT = 21;
    private final JavEApplication jave;
    private final SmartButtonGroup buttonGroup = new SmartButtonGroup();
    private final JCheckBox cbWatermark;
    private final JCheckBox cbAuxLines;
    private Tool[] tools;
    private final JaveApplicationPreferences preferences;
    private final JComponent content;

    public ToolBar(final JavEApplication jave, JaveApplicationPreferences preferences, PlatePreferences plateViewOptions) {
        int i;
        this.jave = jave;
        this.preferences = preferences;
        this.createTools();
        this.cbWatermark = new JCheckBox((String)null, false);
        this.cbWatermark.setToolTipText("Show / Hide Watermark");
        this.cbWatermark.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((IWatermarkPainter)((Object)ToolBar.this.tools[19])).setEnabled(ToolBar.this.cbWatermark.isSelected());
                jave.getMainPanel().repaint();
                jave.getMainPanel().requestFocus();
            }
        });
        this.cbAuxLines = new JCheckBox((String)null, false);
        this.cbAuxLines.setToolTipText("Show / Hide Auxiliary Lines");
        this.cbAuxLines.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((IWatermarkPainter)((Object)ToolBar.this.tools[20])).setEnabled(ToolBar.this.cbAuxLines.isSelected());
                jave.getMainPanel().repaint();
                jave.getMainPanel().requestFocus();
            }
        });
        GCheckbox cbGrid = new GCheckbox(plateViewOptions.getGridVisibilityModel(), JaveIcons.GRID_VISIBLE_ICON);
        cbGrid.setToolTipText("Show / Hide Grid");
        GCheckbox cbPure = new GCheckbox(plateViewOptions.getMarkIllegalModel(), JaveIcons.PURE_ASCII_ICON);
        cbPure.setToolTipText("Mark Characters not belonging to the current character set");
        GCheckbox cbPixel = new GCheckbox(plateViewOptions.getConnectedLinesViewModel(), JaveIcons.CONNECTED_LINES_VIEW_ICON);
        cbPixel.setToolTipText("Toggle ASCII/Connected Lines View");
        GridDialogLayoutData twoColumnsData = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        twoColumnsData.setHorizontalSpan(2);
        GridDialogLayoutData labelData = new GridDialogLayoutData(GridDialogLayoutData.CENTER);
        labelData.setVerticalAlignment(GridAlignment.END);
        JLabel genericToolsLabel = new JLabel(JaveIcons.TOOLTYPE_GENERIC_ICON);
        genericToolsLabel.setToolTipText("<html><b>Generic Tools:</b><p>Generic tools use a complex computational algorithm for creating shapes.<br> Each tool uses the same generic algorithm.<br> Generic tools work best for freehand shapes, ellipses, Bezier curves and arcs.</p></html>");
        JLabel algorithmicToolsLabel = new JLabel(JaveIcons.TOOLTYPE_ALGORITHMIC_ICON);
        algorithmicToolsLabel.setToolTipText("<html><b>Algorithmic Tools:</b><p>Algorithmic tools use algorithms from Ascii Artists.<br> Each shape has an algorithm or a set of algorithms of its own.<br> Algorithmic tools work best for lines and rectangles.</p></html>");
        JPanel panel = new JPanel(new GridDialogLayout(2, true, 0, 0));
        panel.add((Component)new Gap(1, 6), twoColumnsData);
        panel.add((Component)genericToolsLabel, labelData);
        panel.add((Component)algorithmicToolsLabel, labelData);
        panel.add((Component)new Gap(1, 3), twoColumnsData);
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                panel.add(new Gap());
            }
            panel.add(this.buttonGroup.getButton(i));
        }
        panel.add(new Gap());
        panel.add((Component)this.createHorizontalLine(6), twoColumnsData);
        for (i = 10; i < 14; ++i) {
            panel.add(this.buttonGroup.getButton(i));
        }
        panel.add((Component)this.createHorizontalLine(6), twoColumnsData);
        for (i = 14; i < 19; ++i) {
            panel.add(this.buttonGroup.getButton(i));
        }
        panel.add(new Gap());
        panel.add((Component)this.createHorizontalLine(6), twoColumnsData);
        panel.add(this.cbWatermark);
        panel.add(this.buttonGroup.getButton(19));
        panel.add(this.cbAuxLines);
        panel.add(this.buttonGroup.getButton(20));
        panel.add((Component)new Gap(3, 3), twoColumnsData);
        panel.add((Component)this.createHorizontalLine(1), twoColumnsData);
        panel.add((Component)this.createHorizontalLine(1), twoColumnsData);
        panel.add((Component)cbGrid.getContent(), twoColumnsData);
        panel.add((Component)cbPure.getContent(), twoColumnsData);
        panel.add((Component)cbPixel.getContent(), twoColumnsData);
        panel.add((Component)this.createHorizontalLine(2), twoColumnsData);
        this.content = panel;
    }

    private HorizontalLine createHorizontalLine(int verticalSpace) {
        HorizontalLine horizontalLine = new HorizontalLine(20);
        horizontalLine.setMargin(new Insets(LayoutUtilities.getDpiAdjusted(verticalSpace), LayoutUtilities.getDpiAdjusted(3), LayoutUtilities.getDpiAdjusted(verticalSpace), LayoutUtilities.getDpiAdjusted(3)));
        return horizontalLine;
    }

    public void setWatermarkVisible(boolean what) {
        ((IWatermarkPainter)((Object)this.tools[19])).setEnabled(what);
        this.cbWatermark.setSelected(what);
    }

    public void setAuxiliaryLinesVisible(boolean what) {
        ((IWatermarkPainter)((Object)this.tools[20])).setEnabled(what);
        this.cbAuxLines.setSelected(what);
    }

    public void selectToolButton(int index) {
        this.buttonGroup.setSelectedIndex(index);
    }

    protected void createTools() {
        JaveMainPanel mainPanel = this.jave.getMainPanel();
        this.tools = new Tool[21];
        this.tools[0] = new FreehandToolGeneric(mainPanel, this.jave);
        this.tools[2] = new LineToolGeneric(mainPanel, this.jave);
        this.tools[4] = new RectangleToolGeneric(mainPanel, this.jave);
        this.tools[6] = new EllipseToolGeneric(mainPanel, this.jave);
        this.tools[8] = new BezierToolGeneric(mainPanel, this.jave);
        this.tools[9] = new ArcToolGeneric(mainPanel, this.jave);
        this.tools[1] = new FreehandAlgorithmicTool(mainPanel, this.jave);
        this.tools[3] = new LineAlgorithmicTool(mainPanel, this.jave);
        this.tools[5] = new RectangleAlgorithmicTool(mainPanel, this.jave);
        this.tools[7] = new EllipseAlgorithmicTool(mainPanel, this.jave);
        this.tools[10] = new TextTool(mainPanel, this.jave, this.preferences.getCursorBlockStyleModel());
        this.tools[11] = new FIGletTool(mainPanel, this.jave);
        this.tools[12] = new SelectionTool(mainPanel, this.jave);
        this.tools[13] = new FreehandSelectionTool(mainPanel, this.jave);
        this.tools[14] = new BrushTool(mainPanel, this.jave);
        this.tools[15] = new EraserTool(mainPanel, this.jave);
        this.tools[16] = new FillTool(mainPanel, this.jave);
        this.tools[17] = new CloneTool(mainPanel, this.jave);
        this.tools[18] = new PanTool(mainPanel, this.jave);
        this.tools[19] = new WatermarkTool(mainPanel, this.jave);
        this.tools[20] = new AuxiliaryLinesTool(mainPanel, this.jave);
        mainPanel.getToolManager().setTools(this.tools);
        mainPanel.setCurrentTool(this.tools[0]);
        for (int i = 0; i < 21; ++i) {
            JToggleButton button = ModernToggleButtonFactory.createModernToggleButton();
            button.setIcon(this.tools[i].getIcon());
            button.setSelected(i == this.jave.getMainPanel().getToolManager().getCurrentToolIndex());
            this.buttonGroup.add(button);
            button.setToolTipText(this.tools[i].getName());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolBar.this.jave.setTool(ToolBar.this.buttonGroup.getSelectedIndex());
                    ToolBar.this.jave.getMainPanel().requestFocus();
                }
            });
        }
    }

    public JComponent getContent() {
        return this.content;
    }
}

