/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.image.Rotation;
import de.jave.image2ascii.RotationUi;
import de.jave.jave.JaveSelection;
import de.jave.jave.actions.AbstractJaveUndoableAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextAndAnimationEditorEnabledStrategy;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.algorithm.Rotate90LeftStaticAction;
import de.jave.jave.plate.JaveMainPanel;
import java.awt.Component;
import java.awt.Dimension;

public class Rotate90LeftAction
extends AbstractJaveUndoableAction {
    public Rotate90LeftAction(JaveMainPanel mainPanel) {
        super(mainPanel, "90 degrees left", new RotationUi().getIcon(Rotation.LEFT));
    }

    @Override
    protected String getActionName() {
        return "rotate 90 degrees";
    }

    @Override
    protected JaveSelection apply(Component parentComponent, JaveSelection selection) {
        selection = Rotate90LeftStaticAction.applyTo(selection);
        Dimension size = selection.getSize();
        char[][] ch = selection.getContent().getContent();
        char[] table = GeneralAlgorithm.getRotate90Right().toCharArray();
        for (int y = 0; y < size.height; ++y) {
            for (int x = 0; x < size.width; ++x) {
                if (ch[y][x] < ' ' || ch[y][x] > '~') continue;
                ch[y][x] = table[ch[y][x] - 32];
            }
        }
        return selection;
    }

    @Override
    protected IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextAndAnimationEditorEnabledStrategy.getInstance();
    }
}

