/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.ascii3d;

import de.jave.jave.AbstractDialogTool;
import de.jave.jave.AsciiGradients;
import de.jave.jave.JavEApplication;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.ascii3d.Animate3dAction;
import de.jave.jave.ascii3d.Ascii3dExampleObjectUi;
import de.jave.jave.ascii3d.Navigate3dModel;
import de.jave.jave.ascii3d.Polygon2d;
import de.jave.jave.ascii3d.ResetAction;
import de.jave.jave.ascii3d.RotateLeftAction;
import de.jave.jave.ascii3d.RotateRightAction;
import de.jave.jave.ascii3d.ZoomInAction;
import de.jave.jave.ascii3d.ZoomOutAction;
import de.jave.jave.ascii3d.example.Cube3dExample;
import de.jave.jave.ascii3d.example.I3dExample;
import de.jave.jave.ascii3d.example.Jave3dExample;
import de.jave.jave.ascii3d.example.Key3dExample;
import de.jave.jave.ascii3d.example.Pyramid3dExample;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.toolbar.ToolBarBuilder;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public class Render3DTool
extends AbstractDialogTool
implements ItemListener,
KeyListener {
    static final String TITLE = "3D Rendering Tool";
    static final double D = 3.0;
    private JComboBox chDemo;
    JComboBox chStyle;
    JComboBox tfGradient;
    private static final String[] STYLES = new String[]{"Solid", "Wireframe", "High Resolution", "Shaded"};
    private static final I3dExample[] EXAMPLES = new I3dExample[]{new Key3dExample(), new Cube3dExample(), new Pyramid3dExample(), new Jave3dExample()};
    private static final int WIREFRAME_VISIBLE = 0;
    private static final int WIREFRAME = 1;
    private static final int HIRES = 2;
    private static final int SHADED = 3;
    private static final int SOLID = 4;
    private static final int SOLID_DEPTH = 5;
    JTextArea taScript;
    private final Navigate3dModel model = new Navigate3dModel();
    private final JavEApplication asciiPainter;
    private JLabel gradientLabel;

    public Render3DTool(JavEApplication asciiPainter, JaveApplicationPreferences preferences) {
        super(asciiPainter, preferences);
        Ensure.ensureArgumentNotNull(asciiPainter);
        this.asciiPainter = asciiPainter;
        this.getDialog().getDialog().getWindow().addKeyListener(this);
        this.model.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                Render3DTool.this.render();
            }
        });
        this.render();
    }

    @Override
    protected ColorScheme getPreferredColorScheme() {
        return ColorScheme.WHITE_ON_BLACK;
    }

    @Override
    protected String getToolTitle() {
        return TITLE;
    }

    @Override
    public String getToolActionName() {
        return "render 3D";
    }

    @Override
    public JComponent getOptionsComponent() {
        this.taScript = new JTextArea(EXAMPLES[0].getCode(), 9, 40);
        this.taScript.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            @Override
            protected void documentChanged() {
                Render3DTool.this.render();
            }
        });
        this.taScript.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        final DefaultBoundedRangeModel sliderModel = new DefaultBoundedRangeModel(this.model.getAlpha(), 1, 0, 360);
        sliderModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Render3DTool.this.model.setAlpha(sliderModel.getValue());
            }
        });
        this.model.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                sliderModel.setValue(Render3DTool.this.model.getAlpha());
            }
        });
        JSlider rotateSlider = new JSlider(sliderModel);
        rotateSlider.setToolTipText("Rotate");
        ToolBarBuilder toolBarBuilder = new ToolBarBuilder();
        toolBarBuilder.add(new RotateLeftAction(this.model));
        toolBarBuilder.add(new RotateRightAction(this.model));
        toolBarBuilder.add(rotateSlider);
        toolBarBuilder.add(new ZoomInAction(this.model));
        toolBarBuilder.add(new ZoomOutAction(this.model));
        toolBarBuilder.add(new ResetAction(this.model));
        JToolBar toolBar = toolBarBuilder.getToolBar();
        this.chDemo = new JComboBox<I3dExample>(EXAMPLES);
        this.chDemo.setRenderer(new ObjectUiListCellRenderer(new Ascii3dExampleObjectUi()));
        this.chDemo.addItemListener(this);
        this.chStyle = new JComboBox<String>(STYLES);
        this.chStyle.addItemListener(this);
        this.tfGradient = AsciiGradients.createComponent();
        this.tfGradient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Render3DTool.this.render();
            }
        });
        JPanel pControls = new JPanel(new GridDialogLayout(6, false));
        pControls.add(new JLabel("Demos:"));
        pControls.add(this.chDemo);
        pControls.add(new JLabel("Style:"));
        pControls.add(this.chStyle);
        this.gradientLabel = new JLabel("Gradient:");
        pControls.add(this.gradientLabel);
        pControls.add(this.tfGradient);
        JPanel p = new JPanel(new BorderLayout(2, 2));
        p.add((Component)toolBar, "North");
        p.add((Component)pControls, "South");
        p.add((Component)new JScrollPane(this.taScript), "Center");
        p.addKeyListener(this);
        pControls.addKeyListener(this);
        toolBar.addKeyListener(this);
        this.updateGradientEnabled();
        return p;
    }

    private void updateGradientEnabled() {
        boolean isShaded = this.chStyle.getSelectedIndex() == 3;
        this.tfGradient.setEnabled(isShaded);
        this.gradientLabel.setEnabled(isShaded);
    }

    @Override
    protected Action[] getAdditionalActions() {
        return new Action[]{new Animate3dAction(this, this.asciiPainter, this.model)};
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 37) {
            this.model.doRotateLeft();
            evt.consume();
            return;
        }
        if (code == 39) {
            this.model.doRotateRight();
            evt.consume();
            return;
        }
        if (code == 38) {
            this.model.doZoomIn();
            evt.consume();
            return;
        }
        if (code == 40) {
            this.model.doZoomOut();
            evt.consume();
            return;
        }
    }

    private final void render() {
        if (this.markPlate == null) {
            this.markPlate = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        }
        double dx = this.plateWidth / 2;
        double dy = this.plateHeight / 2;
        int style = this.chStyle.getSelectedIndex();
        String gradient = (String)this.tfGradient.getSelectedItem();
        if (gradient.length() == 0) {
            gradient = " ";
        }
        Render3DTool.render(this.markPlate, this.taScript.getText(), style, gradient, this.model.getAlpha(), 3.0, this.model.getZoom(), dx, dy);
        this.characterPlate.clear();
        this.markPlate.convert();
        this.markPlate.pasteResultInto(this.characterPlate);
        this.repaintPlate();
    }

    public static final void render(PixelPlate markPlate, String script, int style, String gradient, double alpha, double d, double scale, double dx, double dy) {
        switch (style) {
            case 2: {
                markPlate.setMode(PixelPlateMode.PIXEL);
                break;
            }
            case 0: 
            case 1: {
                markPlate.setMode(PixelPlateMode.DOT);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                markPlate.setMode(PixelPlateMode.CHAR);
            }
        }
        markPlate.clear();
        double scaleX = scale * 1.98;
        double scaleY = scale;
        int vWidth = markPlate.getVirtualWidth();
        int vHeight = markPlate.getVirtualHeight();
        double factorX = vWidth / markPlate.getWidth();
        double factorY = vHeight / markPlate.getHeight();
        double[][] zBuffer = new double[vHeight][vWidth];
        for (int x = 0; x < vWidth; ++x) {
            zBuffer[0][x] = Double.MAX_VALUE;
        }
        for (int y = 1; y < vHeight; ++y) {
            System.arraycopy(zBuffer[0], 0, zBuffer[y], 0, vWidth);
        }
        int[][] markBuffer = new int[vHeight][vWidth];
        boolean mode = false;
        ArrayList<double[]> points = new ArrayList<double[]>();
        ArrayList<Integer> shades = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(script, "\n", false);
        int polCounter = 0;
        while (st.hasMoreTokens()) {
            StringTokenizer sl;
            String line = st.nextToken().trim();
            if (line.length() == 0 || line.charAt(0) == '#' || line.startsWith("AlWuzEre")) continue;
            if (!mode && line.indexOf(46) == -1 && line.indexOf(45) == -1) {
                mode = true;
            }
            if (!mode) {
                try {
                    sl = new StringTokenizer(line, " \t", false);
                    double x1 = Double.valueOf(sl.nextToken());
                    double y1 = Double.valueOf(sl.nextToken());
                    double z1 = Double.valueOf(sl.nextToken());
                    double[] p = Render3DTool.transform(x1, y1, z1, alpha, d, scaleX, scaleY, dx, dy);
                    points.add(p);
                }
                catch (Exception e) {
                    System.err.println("Warning: Line '" + line + "' seems to be invalid. - ignored");
                }
                continue;
            }
            try {
                int iAngle;
                double cosAlpha;
                double angle;
                int i;
                ++polCounter;
                sl = new StringTokenizer(line, " \t", false);
                int count = sl.countTokens();
                int[] polygon = new int[count];
                for (i = 0; i < count; ++i) {
                    polygon[i] = Integer.parseInt(sl.nextToken());
                }
                if (style == 1) {
                    for (i = 0; i < count; ++i) {
                        double[] p0 = (double[])points.get(polygon[i]);
                        double[] p1 = (double[])points.get(polygon[(i + 1) % count]);
                        markPlate.drawLine(p0[0] + dx, p0[1] + dy, p1[0] + dx, p1[1] + dy);
                    }
                    continue;
                }
                double[] polX = new double[count];
                double[] polY = new double[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    double[] p = (double[])points.get(polygon[i2]);
                    polX[i2] = p[0] * factorX;
                    polY[i2] = p[1] * factorY;
                }
                Polygon2d pol2 = new Polygon2d(polX, polY);
                double[] p0 = (double[])points.get(polygon[0]);
                double[] p1 = (double[])points.get(polygon[1]);
                double[] p2 = (double[])points.get(polygon[2]);
                double ax = p0[3] - p1[3];
                double ay = p0[4] - p1[4];
                double az = p0[2] - p1[2];
                double bx = p2[3] - p1[3];
                double by = p2[4] - p1[4];
                double bz = p2[2] - p1[2];
                double nx = ay * bz - az * by;
                double ny = az * bx - ax * bz;
                double nz = ax * by - ay * bx;
                double e = Math.sqrt(nx * nx + ny * ny + nz * nz);
                nx /= e;
                ny /= e;
                nz /= e;
                ax = p0[5] - p1[5];
                ay = p0[6] - p1[6];
                az = p0[7] - p1[7];
                bx = p2[5] - p1[5];
                by = p2[6] - p1[6];
                bz = p2[7] - p1[7];
                double lnx = ay * bz - az * by;
                double lny = az * bx - ax * bz;
                double lnz = ax * by - ay * bx;
                e = Math.sqrt(lnx * lnx + lny * lny + lnz * lnz);
                lnx /= e;
                lny /= e;
                lnz /= e;
                double lx = 1.0;
                double ly = -1.0;
                double lz = 2.0;
                if ((angle = 57.29577951308232 * Math.acos(cosAlpha = (lx /= (e = Math.sqrt(lx * lx + ly * ly + lz * lz))) * lnx + (ly /= e) * lny + (lz /= e) * lnz)) > 90.0) {
                    angle = 180.0 - angle;
                }
                if ((iAngle = (int)(angle / 90.0 * (double)gradient.length())) >= gradient.length()) {
                    iAngle = gradient.length() - 1;
                }
                shades.add(new Integer(iAngle));
                double px = p0[3] - 0.0;
                double py = p0[4] - 0.0;
                double pz = p0[2] + d;
                int minY = (int)(pol2.getMinY() + dy * factorY) - 1;
                int maxY = (int)(pol2.getMaxY() + dy * factorY) + 1;
                int minX = (int)(pol2.getMinX() + dx * factorX) - 1;
                int maxX = (int)(pol2.getMaxX() + dx * factorX) + 1;
                if (minY < 0) {
                    minY = 0;
                }
                if (minX < 0) {
                    minX = 0;
                }
                if (maxX >= vWidth) {
                    maxX = vWidth - 1;
                }
                if (maxY >= vHeight) {
                    maxY = vHeight - 1;
                }
                for (int y = minY; y <= maxY; ++y) {
                    for (int x = minX; x <= maxX; ++x) {
                        double yy;
                        double xx;
                        double z;
                        if (!pol2.contains((double)x - dx * factorX, (double)y - dy * factorY) || !((z = Render3DTool.getDepth(xx = (double)x / factorX - dx, yy = (double)y / factorY - dy, d, nx, ny, nz, px, py, pz)) < zBuffer[y][x])) continue;
                        zBuffer[y][x] = z;
                        markBuffer[y][x] = polCounter;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Warning: Line '" + line + "' seems to be invalid. - ignored");
            }
        }
        if (style == 0 || style == 2) {
            for (int y = 0; y < vHeight; ++y) {
                for (int x = 0; x < vWidth; ++x) {
                    if (markBuffer[y][x] <= 0) continue;
                    if (x + 1 < vWidth && markBuffer[y][x + 1] != markBuffer[y][x]) {
                        markPlate.set(x, y);
                        continue;
                    }
                    if (y + 1 < vHeight && markBuffer[y + 1][x] != markBuffer[y][x]) {
                        markPlate.set(x, y);
                        continue;
                    }
                    if (x + 1 < vWidth && markBuffer[y][x + 1] == 0) {
                        markPlate.set(x, y);
                        continue;
                    }
                    if (y + 1 < vHeight && markBuffer[y + 1][x] == 0) {
                        markPlate.set(x, y);
                        continue;
                    }
                    if (x > 0 && markBuffer[y][x - 1] == 0) {
                        markPlate.set(x, y);
                        continue;
                    }
                    if (y <= 0 || markBuffer[y - 1][x] != 0) continue;
                    markPlate.set(x, y);
                }
            }
        } else if (style == 4) {
            for (int y = 0; y < vHeight; ++y) {
                for (int x = 0; x < vWidth; ++x) {
                    markPlate.set(x, y, " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ#*+-:?!()[]{}@".charAt(markBuffer[y][x]));
                }
            }
        } else if (style == 3) {
            for (int y = 0; y < vHeight; ++y) {
                for (int x = 0; x < vWidth; ++x) {
                    if (markBuffer[y][x] <= 0) continue;
                    int shade = (Integer)shades.get(markBuffer[y][x] - 1);
                    markPlate.set(x, y, gradient.charAt(gradient.length() - shade - 1));
                }
            }
        } else {
            int y;
            double min = 0.0;
            double max = 0.0;
            for (y = 0; y < vHeight; ++y) {
                for (int x = 0; x < vWidth; ++x) {
                    if (zBuffer[y][x] < min) {
                        min = zBuffer[y][x];
                    }
                    if (!(zBuffer[y][x] > max) || !(zBuffer[y][x] < Double.MAX_VALUE)) continue;
                    max = zBuffer[y][x];
                }
            }
            for (y = 0; y < vHeight; ++y) {
                for (int x = 0; x < vWidth; ++x) {
                    if (zBuffer[y][x] > max) continue;
                    int index = (int)((zBuffer[y][x] - min) / (max - min) * (double)gradient.length());
                    if (index < 0) {
                        index = 0;
                    } else if (index >= gradient.length()) {
                        index = gradient.length() - 1;
                    }
                    markPlate.set(x, y, gradient.charAt(index));
                }
            }
        }
    }

    public static final double getDepth(double x, double y, double d, double nx, double ny, double nz, double px, double py, double pz) {
        double sx = x - 0.0;
        double sy = y - 0.0;
        double sz = d;
        double a = (px * nx + py * ny + pz * nz) / (sx * nx + sy * ny + sz * nz);
        return a;
    }

    public static final double[] transform(double x, double y, double z, double alpha, double d, double scaleX, double scaleY, double dx, double dy) {
        double a = alpha / 180.0 * Math.PI;
        double x1 = x * Math.cos(a) + z * Math.sin(a);
        double y1 = y;
        double z1 = z * Math.cos(a) - x * Math.sin(a);
        double xR = x1;
        double yR = y1;
        double zR = z1;
        double xx = (x1 *= scaleX) / (z1 / d + 1.0);
        double yy = (y1 *= -scaleY) / (z1 / d + 1.0);
        return new double[]{xx, yy, z1, x1, y1, xR, yR, zR};
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.chDemo) {
            this.taScript.setText(((I3dExample)this.chDemo.getSelectedItem()).getCode());
            this.render();
            return;
        }
        if (source == this.chStyle) {
            this.updateGradientEnabled();
            this.render();
            return;
        }
    }

    public void dispose() {
        this.getDialog().setVisible(false);
    }
}

