/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.filter;

import de.jave.jave.RectangleAlgorithm;
import de.jave.jave.algorithm.rectangle.RectangleStyle;
import de.jave.lib.CharacterPlate;
import java.awt.Insets;
import java.awt.Rectangle;

public class FilterMatrix {
    private final char[][] mask;
    private final int maskWidth;
    private final int maskHeight;
    private final int maskCenterX;
    private final int maskCenterY;
    private final char[][] result;
    private final int resultWidth;
    private final int resultHeight;
    private final int resultCenterX;
    private final int resultCenterY;
    private int minimumNearest9CharacterCount;
    private int optionalNearest9CharacterCount;

    public FilterMatrix(String sizeString, String maskString, String resultString) {
        int originalMaskWidth = sizeString.charAt(0) - 48;
        int originalMaskHeight = sizeString.charAt(1) - 48;
        int originalResultWidth = sizeString.charAt(2) - 48;
        int originalResultHeight = sizeString.charAt(3) - 48;
        CharacterPlate maskPlate = FilterMatrix.toCharacterPlate(maskString, originalMaskWidth, originalMaskHeight);
        Insets maskInsets = maskPlate.getEmptyInsets('?');
        this.maskWidth = originalMaskWidth - maskInsets.left - maskInsets.right;
        this.maskHeight = originalMaskHeight - maskInsets.top - maskInsets.bottom;
        this.maskCenterX = (originalMaskWidth - 1) / 2 - maskInsets.left;
        this.maskCenterY = (originalMaskHeight - 1) / 2 - maskInsets.top;
        this.mask = maskPlate.getCopy(maskInsets.left, maskInsets.top, this.maskWidth, this.maskHeight).getContent();
        CharacterPlate resultPlate = FilterMatrix.toCharacterPlate(resultString, originalResultWidth, originalResultHeight);
        Insets resultInsets = resultPlate.getEmptyInsets('?');
        this.resultWidth = originalResultWidth - resultInsets.left - resultInsets.right;
        this.resultHeight = originalResultHeight - resultInsets.top - resultInsets.bottom;
        this.resultCenterX = (originalResultWidth - 1) / 2 - resultInsets.left;
        this.resultCenterY = (originalResultHeight - 1) / 2 - resultInsets.top;
        this.result = resultPlate.getCopy(resultInsets.left, resultInsets.top, this.resultWidth, this.resultHeight).getContent();
        this.optionalNearest9CharacterCount = 0;
        this.minimumNearest9CharacterCount = 0;
        for (int y = this.maskCenterY - 1; y <= this.maskCenterY + 1; ++y) {
            for (int x = this.maskCenterX - 1; x <= this.maskCenterX + 1; ++x) {
                if (y < 0 || y >= this.maskHeight || x < 0 || x >= this.maskWidth || this.mask[y][x] == ' ') continue;
                if (this.mask[y][x] == '?') {
                    ++this.optionalNearest9CharacterCount;
                    continue;
                }
                ++this.minimumNearest9CharacterCount;
            }
        }
    }

    private static CharacterPlate toCharacterPlate(String definitionString, int width, int height) {
        char[][] field = new char[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                field[y][x] = definitionString.charAt(y * width + x);
            }
        }
        return new CharacterPlate(field);
    }

    public boolean fits(CharacterPlate plate, int plateWidth, int plateHeight, int x, int y, int charactersSetInNear9) {
        if ((charactersSetInNear9 < this.minimumNearest9CharacterCount || charactersSetInNear9 > this.minimumNearest9CharacterCount + this.optionalNearest9CharacterCount) && charactersSetInNear9 > -1) {
            return false;
        }
        int minPlateX = x - this.maskCenterX;
        if (minPlateX < 0) {
            return false;
        }
        int maxPlateX = x - this.maskCenterX + this.maskWidth - 1;
        if (maxPlateX >= plateWidth) {
            return false;
        }
        int minPlateY = y - this.maskCenterY;
        if (minPlateY < 0) {
            return false;
        }
        int maxPlateY = y - this.maskCenterY + this.maskHeight - 1;
        if (maxPlateY >= plateHeight) {
            return false;
        }
        for (int plateX = minPlateX; plateX <= maxPlateX; ++plateX) {
            for (int plateY = minPlateY; plateY <= maxPlateY; ++plateY) {
                int maskY = plateY - y + this.maskCenterY;
                int maskX = plateX - x + this.maskCenterX;
                char maskCharacter = this.mask[maskY][maskX];
                if (maskCharacter == '?') continue;
                char plateCharacter = plate.get(plateX, plateY);
                if (maskCharacter == '!' && plateCharacter != ' ' || plateCharacter == maskCharacter) continue;
                return false;
            }
        }
        return true;
    }

    public void apply(CharacterPlate cp, int w, int h, int x, int y) {
        int y1;
        int y0;
        int x1;
        int x0 = x - this.resultCenterX;
        if (x0 < 0) {
            x0 = 0;
        }
        if ((x1 = x - this.resultCenterX + this.resultWidth - 1) >= w) {
            x1 = w - 1;
        }
        if ((y0 = y - this.resultCenterY) < 0) {
            y0 = 0;
        }
        if ((y1 = y - this.resultCenterY + this.resultHeight - 1) >= h) {
            y1 = h - 1;
        }
        for (int i = x0; i <= x1; ++i) {
            for (int j = y0; j <= y1; ++j) {
                char ch = this.result[j - y + this.resultCenterY][i - x + this.resultCenterX];
                if (ch == '?') continue;
                cp.setForce(i, j, ch);
            }
        }
    }

    public String toString() {
        CharacterPlate cp = new CharacterPlate(40, 8);
        cp.setMix(false);
        RectangleAlgorithm.drawRectangle(cp, new Rectangle(1, 0, this.maskWidth + 2, this.maskHeight + 2), RectangleStyle.NORMAL);
        RectangleAlgorithm.drawRectangle(cp, new Rectangle(11, 0, this.maskWidth + 2, this.maskHeight + 2), RectangleStyle.NORMAL);
        new CharacterPlate(this.mask).pasteInto(cp, 2, 1);
        new CharacterPlate(this.mask).pasteInto(cp, 12, 1);
        new CharacterPlate(this.result).pasteInto(cp, 12 - this.resultCenterX + this.maskCenterX, 1 - this.resultCenterY + this.maskCenterY);
        Insets in = cp.getEmptyInsets();
        cp.setSize(cp.getWidth(), cp.getHeight() - in.bottom);
        return cp.toString();
    }
}

