/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.pixelplate;

import de.jave.jave.ICharacterDrawable;
import de.jave.jave.Point2d;
import de.jave.jave.filter.Filter;
import de.jave.jave.filter.FilterMode;
import de.jave.jave.pixelplate.PixelPlateConfiguration;
import de.jave.jave.pixelplate.PixelPlateConverterMode;
import de.jave.jave.pixelplate.PixelPlateFeltPenMode;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.lib.CharacterPlate;
import net.disy.commons.core.util.Ensure;

public class PixelPlate
implements ICharacterDrawable {
    private char[][] pixels;
    private CharacterPlate plate;
    private int width;
    private int height;
    private int originX;
    private int originY;
    private static final char[] TWO_BY_TWO_CHARS = new char[]{' ', '\'', '.', '(', '`', '\"', '/', 'P', ',', '\\', '_', 'L', ')', '7', 'J', '8'};
    private static final char[] THREE_BY_TWO_CHARS = new char[]{' ', '`', '-', '!', '.', '|', 'i', '[', '\'', '~', '/', 'f', '/', '7', '/', 'P', '-', '\\', '=', '+', 'v', ')', 'z', 'D', '!', 'V', 'Y', '*', '/', 'Z', 'Z', 'A', ',', '\\', 'c', 't', '_', 'L', 's', 'b', '!', 'T', '(', '5', '2', 'X', 'K', 'K', 'i', '\\', 'e', 'N', 'g', 'G', 'm', 'W', ']', 'Y', '4', 'M', 'd', '8', 'W', '@'};
    public static final char[] FELTPEN_CHARS = new char[]{'!', ':', '$', 'O', '8', 'X', 'M'};
    public static final int DEFAULT_FELTPEN_CHAR_INDEX = 4;
    public static PixelPlateMode[] FELTPEN_GRADIENT_MODES = new PixelPlateMode[]{PixelPlateFeltPenMode.FELTPEN_EXCLAM, PixelPlateFeltPenMode.FELTPEN_COLON, PixelPlateFeltPenMode.FELTPEN_DOLLAR, PixelPlateFeltPenMode.FELTPEN_O, PixelPlateFeltPenMode.FELTPEN_X, PixelPlateFeltPenMode.FELTPEN_8, PixelPlateFeltPenMode.FELTPEN_M};
    private PixelPlateMode mode;
    private int pencilSize;
    private char character;
    private char feltPenChar;
    private static final char[] DOT_TABLE = new char[]{'\u0000', '\'', '.', ':'};

    public PixelPlate(int originX, int originY, int width, int height) {
        this.originX = originX;
        this.originY = originY;
        this.width = width;
        this.height = height;
        this.pixels = new char[height][width];
        this.setMode(PixelPlateMode.PIXEL);
        this.character = (char)88;
    }

    public PixelPlate(char[][] pixels, int originX, int originY) {
        this.originX = originX;
        this.originY = originY;
        this.pixels = pixels;
        this.width = pixels[0].length;
        this.height = pixels.length;
        this.setMode(PixelPlateMode.PIXEL);
        this.character = (char)88;
    }

    public void setMode(PixelPlateMode mode) {
        Ensure.ensureArgumentNotNull(mode);
        this.mode = mode;
        if (mode == PixelPlateMode.PIXEL) {
            this.feltPenChar = (char)32;
            this.pencilSize = 1;
        } else if (mode == PixelPlateMode.CHAR) {
            this.feltPenChar = (char)32;
            this.pencilSize = 1;
        } else if (mode instanceof PixelPlateFeltPenMode) {
            PixelPlateFeltPenMode feltPenMode = (PixelPlateFeltPenMode)mode;
            this.feltPenChar = feltPenMode.getCharacter();
            this.pencilSize = feltPenMode.getSize() + 1;
        } else if (mode == PixelPlateMode.TWO_BY_TWO) {
            this.feltPenChar = (char)32;
            this.pencilSize = 1;
        } else if (mode == PixelPlateMode.THREE_BY_TWO) {
            this.feltPenChar = (char)32;
            this.pencilSize = 1;
        } else if (mode == PixelPlateMode.THICK_THIN) {
            this.feltPenChar = (char)56;
            this.pencilSize = 1;
        } else if (mode == PixelPlateMode.DOT) {
            this.feltPenChar = (char)32;
            this.pencilSize = 1;
        } else {
            throw new IllegalArgumentException("Unsupported mode " + mode);
        }
    }

    public void setSize(int width, int height) {
        if (width == this.width && height == this.height) {
            return;
        }
        char[][] oldChars = this.pixels;
        this.pixels = new char[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.pixels[y][x] = y < this.height && x < this.width ? oldChars[y][x] : (char)'\u0000';
            }
        }
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getVirtualWidth() {
        return this.width * this.getRasterX();
    }

    public int getHeight() {
        return this.height;
    }

    public int getVirtualHeight() {
        return this.height * this.mode.getRasterY();
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public void removeNoise(int max) {
        int y;
        int x;
        int w = this.width * this.getRasterX();
        int h = this.height * this.mode.getRasterY();
        boolean[][] kill = new boolean[h][w];
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                kill[y][x] = false;
                int neighbourCount = 0;
                if (y - 1 >= 0 && this.isSet(x, y - 1)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                if (y - 1 >= 0 && x + 1 < w && this.isSet(x + 1, y - 1)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                if (x + 1 < w && this.isSet(x + 1, y)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                if (y + 1 < h && x + 1 < w && this.isSet(x + 1, y + 1)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                if (y + 1 < h && this.isSet(x, y + 1)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                if (y + 1 < h && x - 1 >= 0 && this.isSet(x - 1, y + 1)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                if (x - 1 >= 0 && this.isSet(x - 1, y)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                if (y - 1 >= 0 && x - 1 >= 0 && this.isSet(x - 1, y - 1)) {
                    ++neighbourCount;
                }
                if (neighbourCount > max) continue;
                kill[y][x] = true;
            }
        }
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                if (!kill[y][x]) continue;
                this.setInternal(x, y, false);
            }
        }
    }

    public void setCharacter(char ch) {
        this.character = ch;
    }

    public char getCharacter() {
        return this.character;
    }

    public void clear() {
        if (this.height == 0) {
            return;
        }
        for (int x = 0; x < this.width; ++x) {
            this.pixels[0][x] = '\u0000';
        }
        for (int y = 1; y < this.height; ++y) {
            System.arraycopy(this.pixels[0], 0, this.pixels[y], 0, this.width);
        }
    }

    public void drawArc(Point2d center, double radiusX, double radiusY, double angle, double arcAngle) {
        int oX = this.getPhysicalX(center.getX());
        int oY = this.getPhysicalY(center.getY());
        int rX = this.getPhysicalX(radiusX);
        int rY = this.getPhysicalY(radiusY);
        this.drawArc(oX, oY, rX, rY, angle, arcAngle);
    }

    private void drawArc(int oX, int oY, int radiusX, int radiusY, double angle, double arcAngle) {
        double endAngle;
        double startAngle;
        if (radiusX == 0 || radiusY == 0) {
            this.set(oX, oY, oX, oX, oY, oY);
            return;
        }
        if (arcAngle < 0.0) {
            angle += arcAngle;
            arcAngle = -arcAngle;
        }
        if ((angle %= 360.0) + arcAngle >= 270.0 && angle <= 360.0 || angle + arcAngle >= 630.0 && angle <= 720.0) {
            startAngle = angle - 270.0;
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = endAngle < 270.0 ? 90.0 : (endAngle %= 270.0);
            if (startAngle < 0.0) {
                startAngle = 0.0;
            }
            if (endAngle < 0.0) {
                endAngle = 0.0;
            }
            if (startAngle > 90.0) {
                startAngle = 90.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                this.drawArcSE(oX, oY, radiusX, radiusY, 0.0, endAngle);
                this.drawArcSE(oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                this.drawArcSE(oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 180.0 && angle <= 270.0 || angle + arcAngle >= 540.0 && angle <= 630.0) {
            startAngle = angle - 180.0;
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = endAngle < 180.0 ? 90.0 : (endAngle %= 180.0);
            if (startAngle < 0.0 || startAngle > 90.0) {
                startAngle = 0.0;
            }
            if (endAngle < 0.0) {
                endAngle = 0.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                this.drawArcSW(oX, oY, radiusX, radiusY, 0.0, endAngle);
                this.drawArcSW(oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                this.drawArcSW(oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 90.0 && angle <= 180.0 || angle + arcAngle >= 450.0 && angle <= 540.0) {
            startAngle = angle - 90.0;
            if (angle < 90.0) {
                startAngle = 0.0;
            } else if (angle > 180.0) {
                startAngle = 0.0;
            }
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = endAngle > 180.0 ? 90.0 : (endAngle < 90.0 ? 90.0 : (endAngle %= 90.0));
            if (endAngle < startAngle) {
                this.drawArcNW(oX, oY, radiusX, radiusY, 0.0, endAngle);
                this.drawArcNW(oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                this.drawArcNW(oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 0.0 && angle <= 90.0 || angle + arcAngle >= 360.0 && angle <= 450.0) {
            startAngle = angle;
            endAngle = (angle + arcAngle) % 360.0;
            if (startAngle > 90.0) {
                startAngle = 0.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                this.drawArcNE(oX, oY, radiusX, radiusY, 0.0, endAngle);
                this.drawArcNE(oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                this.drawArcNE(oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
    }

    private void drawArcSE(int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX;
        int maxX = oX + radiusX;
        int minY = oY;
        int maxY = oY + radiusY;
        if (startAngle > 0.0) {
            minX = oX + (int)((double)radiusX * Math.sin(startAngle / 180.0 * Math.PI));
            maxY = oY + (int)((double)radiusY * Math.cos(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            maxX = oX + (int)((double)radiusX * Math.sin(endAngle / 180.0 * Math.PI));
            minY = oY + (int)((double)radiusY * Math.cos(endAngle / 180.0 * Math.PI));
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX + x, oY + y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    this.set(oX + x, oY + y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX + x, oY, minX, maxX, minY, maxY);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX + y, oY + x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    this.set(oX + y, oY + x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX, oY + x, minX, maxX, minY, maxY);
        }
    }

    private void drawArcSW(int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX - radiusX;
        int maxX = oX;
        int minY = oY;
        int maxY = oY + radiusY;
        if (startAngle > 0.0) {
            minX = oX - (int)((double)radiusX * Math.cos(startAngle / 180.0 * Math.PI));
            minY = oY + (int)((double)radiusY * Math.sin(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            maxX = oX - (int)((double)radiusX * Math.cos(endAngle / 180.0 * Math.PI));
            maxY = oY + (int)((double)radiusY * Math.sin(endAngle / 180.0 * Math.PI));
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX - x, oY + y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    this.set(oX - x, oY + y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX - x, oY, minX, maxX, minY, maxY);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX - y, oY + x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    this.set(oX - y, oY + x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX, oY + x, minX, maxX, minY, maxY);
        }
    }

    private void drawArcNW(int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX - radiusX;
        int maxX = oX;
        int minY = oY - radiusY;
        int maxY = oY;
        if (startAngle > 0.0) {
            maxX = oX - (int)((double)radiusX * Math.sin(startAngle / 180.0 * Math.PI));
            minY = oY - (int)((double)radiusY * Math.cos(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            minX = oX - (int)((double)radiusX * Math.sin(endAngle / 180.0 * Math.PI));
            maxY = oY - (int)((double)radiusY * Math.cos(endAngle / 180.0 * Math.PI));
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX - x, oY - y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    this.set(oX - x, oY - y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX - y, oY - x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    this.set(oX - y, oY - x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX, oY - x, minX, maxX, minY, maxY);
        }
    }

    private void drawArcNE(int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX;
        int maxX = oX + radiusX;
        int minY = oY - radiusY;
        int maxY = oY;
        if (startAngle > 0.0) {
            maxX = oX + (int)((double)radiusX * Math.cos(startAngle / 180.0 * Math.PI));
            maxY = oY - (int)((double)radiusY * Math.sin(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            minX = oX + (int)((double)radiusX * Math.cos(endAngle / 180.0 * Math.PI));
            minY = oY - (int)((double)radiusY * Math.sin(endAngle / 180.0 * Math.PI));
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX + x, oY - y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    this.set(oX + x, oY - y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX + y, oY - x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    this.set(oX + y, oY - x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX, oY - x, minX, maxX, minY, maxY);
        }
    }

    private final void set(int x, int y, int minX, int maxX, int minY, int maxY) {
        if (x < minX && y < minY || y > maxY && x > maxX || x < minX - 1 || x > maxX + 1 || y < minY - 1 || y > maxY + 1) {
            return;
        }
        this.set(x, y);
    }

    public int getPhysicalX(double x) {
        return (int)(x * (double)this.getRasterX());
    }

    public int getPhysicalY(double y) {
        return (int)(y * (double)this.mode.getRasterY());
    }

    public void drawEllipse(double oX, double oY, double radiusX, double radiusY) {
        int xx = this.getPhysicalX(oX);
        int yy = this.getPhysicalY(oY);
        int rX = this.getPhysicalX(radiusX);
        int rY = this.getPhysicalY(radiusY);
        this.drawEllipse(xx, yy, rX, rY);
    }

    public void fillEllipse(double oX, double oY, double radiusX, double radiusY) {
        int xx = this.getPhysicalX(oX);
        int yy = this.getPhysicalY(oY);
        int rX = this.getPhysicalX(radiusX);
        int rY = this.getPhysicalY(radiusY);
        this.fillEllipse(xx, yy, rX, rY);
    }

    private void drawEllipse(int oX, int oY, int radiusX, int radiusY) {
        if (radiusX == 0) {
            this.drawLine(oX, oY - radiusY, oX, oY + radiusY);
            return;
        }
        if (radiusY == 0) {
            this.drawLine(oX - radiusX, oY, oX + radiusX, oY + radiusY);
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX + x, oY + y);
                        this.set(oX - x, oY + y);
                        this.set(oX + x, oY - y);
                        this.set(oX - x, oY - y);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    this.set(oX + x, oY + y);
                    this.set(oX - x, oY + y);
                    this.set(oX + x, oY - y);
                    this.set(oX - x, oY - y);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX + x, oY);
            this.set(oX - x, oY);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        this.set(oX + y, oY + x);
                        this.set(oX - y, oY + x);
                        this.set(oX + y, oY - x);
                        this.set(oX - y, oY - x);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    this.set(oX + y, oY + x);
                    this.set(oX - y, oY + x);
                    this.set(oX + y, oY - x);
                    this.set(oX - y, oY - x);
                }
                e -= (yE -= c);
            } while (--y != 0);
            this.set(oX, oY + x);
            this.set(oX, oY - x);
        }
    }

    private void fillEllipse(int oX, int oY, int radiusX, int radiusY) {
        if (radiusX == 0) {
            this.drawLine(oX, oY - radiusY, oX, oY + radiusY);
            return;
        }
        if (radiusY == 0) {
            this.drawLine(oX - radiusX, oY, oX + radiusX, oY + radiusY);
            return;
        }
        this.drawEllipse(oX, oY, radiusX, radiusY);
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                int y2;
                if (e <= 0) {
                    do {
                        for (y2 = oY - y; y2 <= oY + y; ++y2) {
                            this.set(oX + x, y2);
                            this.set(oX - x, y2);
                        }
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    for (y2 = oY - y; y2 <= oY + y; ++y2) {
                        this.set(oX + x, y2);
                        this.set(oX - x, y2);
                    }
                }
                e -= (yE -= c);
            } while (--y != 0);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                int y2;
                if (e <= 0) {
                    do {
                        for (y2 = oX - y; y2 <= oX + y; ++y2) {
                            this.set(y2, oY + x);
                            this.set(y2, oY - x);
                        }
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    for (y2 = oX - y; y2 <= oX + y; ++y2) {
                        this.set(y2, oY + x);
                        this.set(y2, oY - x);
                    }
                }
                e -= (yE -= c);
            } while (--y != 0);
        }
    }

    public void setResult(CharacterPlate plate) {
        this.plate = plate;
    }

    public CharacterPlate getResult() {
        if (this.plate == null) {
            this.convert();
        }
        return this.plate;
    }

    private final char convertPixel(int pixel) {
        char[] rules = PixelPlateConfiguration.getInstance().getRules();
        if (pixel == 0 || pixel >= rules.length) {
            return '\u0000';
        }
        char ch = rules[pixel];
        if (ch == '\u0000' || ch == ' ') {
            return this.convertThick(pixel);
        }
        return ch;
    }

    public char[][] getContentClone() {
        char[][] result = new char[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            System.arraycopy(this.pixels[y], 0, result[y], 0, this.width);
        }
        return result;
    }

    private final char convertDot(int pixel) {
        return DOT_TABLE[pixel];
    }

    private final char convertThick(int pixel) {
        int lookup;
        int i;
        char[] rules = PixelPlateConfiguration.getInstance().getRules();
        char[] rulesThick = PixelPlateConfiguration.getInstance().getRulesThick();
        if (pixel == 0 || pixel >= rulesThick.length) {
            return '\u0000';
        }
        char ch = rulesThick[pixel];
        if (ch != '\u0000') {
            return ch;
        }
        for (i = 0; i < 12; ++i) {
            lookup = pixel | 1 << i;
            ch = rulesThick[lookup];
            if (ch == '\u0000') continue;
            return ch;
        }
        for (i = 0; i < 12; ++i) {
            lookup = (pixel | 1 << i) - (1 << i);
            ch = rulesThick[lookup];
            if (ch == '\u0000') continue;
            return ch;
        }
        return rules[pixel];
    }

    public void convert() {
        char[][] result = new char[this.height][this.width];
        if (this.mode.getConverterMode() == PixelPlateConverterMode.LINE) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    result[y][x] = this.convertPixel(this.pixels[y][x]);
                }
            }
        } else if (this.mode.getConverterMode() == PixelPlateConverterMode.DOT) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    result[y][x] = this.convertDot(this.pixels[y][x]);
                }
            }
        } else if (this.mode.getConverterMode() == PixelPlateConverterMode.THICK) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int ch = this.convertThick(this.pixels[y][x]);
                    if (ch == 32 || ch == 0) {
                        result[y][x] = '\u0000';
                        continue;
                    }
                    if (this.feltPenChar == 'M') {
                        if (ch == 56) {
                            ch = 77;
                        } else if (ch == 111) {
                            ch = 109;
                        }
                    } else if (this.feltPenChar == 'O') {
                        if (ch == 56) {
                            ch = 79;
                        }
                    } else if (this.feltPenChar == 'X') {
                        if (ch == 56) {
                            ch = 88;
                        }
                    } else if (this.feltPenChar == '$') {
                        if (ch == 56) {
                            ch = 36;
                        } else if (ch == 98) {
                            ch = 104;
                        } else if (ch == 111) {
                            ch = 99;
                        } else if (ch == 80) {
                            ch = 70;
                        } else if (ch == 89) {
                            ch = 63;
                        }
                    } else if (this.feltPenChar == '!') {
                        if (ch == 56) {
                            ch = 33;
                        } else if (ch == 34) {
                            ch = 39;
                        } else if (ch == 111) {
                            ch = 46;
                        } else if (ch == 80) {
                            ch = 39;
                        } else if (ch == 112) {
                            ch = 44;
                        } else if (ch == 100) {
                            ch = 44;
                        } else if (ch == 70) {
                            ch = 39;
                        } else if (ch == 95) {
                            ch = 46;
                        } else if (ch == 76) {
                            ch = 46;
                        } else if (ch == 98) {
                            ch = 46;
                        } else if (ch == 93) {
                            ch = 59;
                        } else if (ch == 91) {
                            ch = 59;
                        } else if (ch == 74) {
                            ch = 44;
                        } else if (ch == 55) {
                            ch = 96;
                        } else if (ch == 89) {
                            ch = 96;
                        }
                    } else if (this.feltPenChar == ':') {
                        if (ch == 56) {
                            ch = 58;
                        } else if (ch == 34) {
                            ch = 39;
                        } else if (ch == 111) {
                            ch = 46;
                        } else if (ch == 80) {
                            ch = 39;
                        } else if (ch == 112) {
                            ch = 46;
                        } else if (ch == 100) {
                            ch = 46;
                        } else if (ch == 70) {
                            ch = 39;
                        } else if (ch == 95) {
                            ch = 46;
                        } else if (ch == 44) {
                            ch = 46;
                        } else if (ch == 76) {
                            ch = 46;
                        } else if (ch == 98) {
                            ch = 46;
                        } else if (ch == 93) {
                            ch = 58;
                        } else if (ch == 91) {
                            ch = 58;
                        } else if (ch == 74) {
                            ch = 46;
                        } else if (ch == 55) {
                            ch = 39;
                        } else if (ch == 96) {
                            ch = 39;
                        } else if (ch == 90) {
                            ch = 58;
                        } else if (ch == 77) {
                            ch = 58;
                        } else if (ch == 50) {
                            ch = 58;
                        } else if (ch == 117) {
                            ch = 46;
                        } else if (ch == 104) {
                            ch = 46;
                        } else if (ch == 79) {
                            ch = 58;
                        } else if (ch == 89) {
                            ch = 39;
                        }
                    }
                    result[y][x] = ch;
                }
            }
        } else if (this.mode.getConverterMode() == PixelPlateConverterMode.TWO_BY_TWO) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    result[y][x] = this.pixels[y][x] == '\u0000' || this.pixels[y][x] >= TWO_BY_TWO_CHARS.length ? (char)'\u0000' : TWO_BY_TWO_CHARS[this.pixels[y][x]];
                }
            }
        } else if (this.mode.getConverterMode() == PixelPlateConverterMode.RAW) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    result[y][x] = this.pixels[y][x] > '\u0000' ? this.pixels[y][x] : (char)'\u0000';
                }
            }
        } else if (this.mode.getConverterMode() == PixelPlateConverterMode.THREE_BY_TWO) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    result[y][x] = this.pixels[y][x] == '\u0000' || this.pixels[y][x] >= THREE_BY_TWO_CHARS.length ? (char)'\u0000' : THREE_BY_TWO_CHARS[this.pixels[y][x]];
                }
            }
        }
        if (this.plate == null) {
            this.plate = new CharacterPlate(result);
        } else {
            this.plate.setContent(result);
        }
        if (this.mode.getConverterMode() == PixelPlateConverterMode.LINE) {
            this.plate.replace('\u0000', ' ');
            Filter.filter(this.plate, FilterMode.LINE_ART_CLEANER);
            this.plate.replace(' ', '\u0000');
        }
    }

    public synchronized void pasteResultInto(CharacterPlate plate) {
        CharacterPlate result = this.getResult();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!plate.contains(x + this.originX, y + this.originY)) continue;
                char ch = result.get(x, y);
                if (ch == '\u00a0') {
                    plate.setForce(x + this.originX, y + this.originY, ' ');
                    continue;
                }
                if (ch == '\u0000' || ch == ' ') continue;
                plate.set(x + this.originX, y + this.originY, ch);
            }
        }
    }

    public void drawRectangle(Point2d p1, Point2d p2) {
        this.drawRectangle(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void drawRectangle(double p1x, double p1y, double p2x, double p2y) {
        this.drawLine(p1x, p1y, p2x, p1y);
        this.drawLine(p1x, p1y, p1x, p2y);
        this.drawLine(p2x, p1y, p2x, p2y);
        this.drawLine(p1x, p2y, p2x, p2y);
    }

    public void fillRectangle(Point2d p1, Point2d p2) {
        this.drawRectangle(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        int t = this.pencilSize;
        this.pencilSize = 1;
        int x1 = this.getPhysicalX(p1.getX());
        int y1 = this.getPhysicalY(p1.getY());
        int x2 = this.getPhysicalX(p2.getX());
        int y2 = this.getPhysicalY(p2.getY());
        int dx = x1 <= x2 ? 1 : -1;
        int dy = y1 <= y2 ? 1 : -1;
        for (int x = x1; x != x2 + dx; x += dx) {
            for (int y = y1; y != y2 + dy; y += dy) {
                this.set(x, y);
            }
        }
        this.pencilSize = t;
    }

    public void drawLine(Point2d p1, Point2d p2) {
        this.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        int xx1 = this.getPhysicalX(x1);
        int yy1 = this.getPhysicalY(y1);
        int xx2 = this.getPhysicalX(x2);
        int yy2 = this.getPhysicalY(y2);
        this.drawLineBresenham(xx1, yy1, xx2, yy2);
    }

    @Override
    public void set(int x, int y, char ch) {
        this.setCharacter(ch);
        this.set(x, y);
    }

    public void set(int x, int y) {
        this.set(x, y, true);
    }

    public void set(int x, int y, boolean what) {
        if (this.pencilSize == 1) {
            this.setInternal(x, y, what);
            return;
        }
        this.setInternal(x, y);
        this.setInternal(x - 1, y, what);
        this.setInternal(x + 1, y, what);
        this.setInternal(x, y - 1, what);
        this.setInternal(x, y + 1, what);
        this.setInternal(x - 1, y - 1, what);
        this.setInternal(x - 1, y + 1, what);
        this.setInternal(x + 1, y - 1, what);
        this.setInternal(x + 1, y + 1, what);
        this.setInternal(x + 2, y, what);
        this.setInternal(x - 2, y, what);
        if (this.pencilSize == 2) {
            return;
        }
        this.setInternal(x + 3, y, what);
        this.setInternal(x + 2, y - 1, what);
        this.setInternal(x + 1, y - 2, what);
        this.setInternal(x, y - 2, what);
        this.setInternal(x - 1, y - 2, what);
        this.setInternal(x - 2, y - 1, what);
        this.setInternal(x - 3, y, what);
        this.setInternal(x - 2, y + 1, what);
        this.setInternal(x - 1, y + 2, what);
        this.setInternal(x, y + 2, what);
        this.setInternal(x + 1, y + 2, what);
        this.setInternal(x + 2, y + 1, what);
        if (this.pencilSize == 3) {
            return;
        }
        this.setInternal(x + 4, y, what);
        this.setInternal(x + 4, y + 1, what);
        this.setInternal(x + 4, y - 1, what);
        this.setInternal(x + 3, y + 1, what);
        this.setInternal(x + 3, y - 1, what);
        this.setInternal(x + 3, y - 2, what);
        this.setInternal(x + 2, y - 2, what);
        this.setInternal(x + 3, y + 2, what);
        this.setInternal(x + 2, y + 2, what);
        this.setInternal(x + 1, y - 3, what);
        this.setInternal(x + 1, y + 3, what);
        this.setInternal(x, y - 3, what);
        this.setInternal(x, y + 3, what);
        this.setInternal(x - 4, y, what);
        this.setInternal(x - 4, y + 1, what);
        this.setInternal(x - 4, y - 1, what);
        this.setInternal(x - 3, y + 1, what);
        this.setInternal(x - 3, y - 1, what);
        this.setInternal(x - 3, y - 2, what);
        this.setInternal(x - 2, y - 2, what);
        this.setInternal(x - 3, y + 2, what);
        this.setInternal(x - 2, y + 2, what);
        this.setInternal(x - 1, y - 3, what);
        this.setInternal(x - 1, y + 3, what);
    }

    public boolean isSet(int x, int y) {
        int xx = 0;
        int yy = 0;
        xx = x / this.getRasterX();
        if (x < 0) {
            xx = (x - this.getRasterX() + 1) / this.getRasterX();
        }
        x -= xx * this.getRasterX();
        xx -= this.originX;
        yy = y / this.mode.getRasterY();
        if (y < 0) {
            yy = (y - this.mode.getRasterY() + 1) / this.mode.getRasterY();
        }
        y -= yy * this.mode.getRasterY();
        if ((yy -= this.originY) < 0 || xx < 0 || yy >= this.height || xx >= this.width) {
            return false;
        }
        if (this.mode.getConverterMode() == PixelPlateConverterMode.RAW) {
            return this.pixels[yy][xx] == this.character;
        }
        return this.pixels[yy][xx] == (this.pixels[yy][xx] | 1 << y + x * this.mode.getRasterY());
    }

    private void setInternal(int x, int y) {
        this.setInternal(x, y, true);
    }

    private synchronized void setInternal(int x, int y, boolean set) {
        int j;
        char[][] newChars;
        int xx = 0;
        int yy = 0;
        xx = x / this.getRasterX();
        if (x < 0) {
            xx = (x - this.getRasterX() + 1) / this.getRasterX();
        }
        x -= xx * this.getRasterX();
        xx -= this.originX;
        yy = y / this.mode.getRasterY();
        if (y < 0) {
            yy = (y - this.mode.getRasterY() + 1) / this.mode.getRasterY();
        }
        y -= yy * this.mode.getRasterY();
        yy -= this.originY;
        if (xx < 0) {
            newChars = new char[this.height][this.width + -xx + 2];
            for (j = 0; j < this.height; ++j) {
                System.arraycopy(this.pixels[j], 0, newChars[j], 2 - xx, this.width);
            }
            this.originX += xx - 2;
            this.width += -xx + 2;
            this.pixels = newChars;
            xx = 2;
        }
        if (xx >= this.width) {
            newChars = new char[this.height][xx + 1 + 2];
            for (j = 0; j < this.height; ++j) {
                System.arraycopy(this.pixels[j], 0, newChars[j], 0, this.width);
            }
            this.width = xx + 1 + 2;
            this.pixels = newChars;
        }
        if (yy < 0) {
            newChars = new char[this.height + -yy + 2][this.width];
            for (j = 0; j < this.height; ++j) {
                newChars[j + 2 - yy] = this.pixels[j];
            }
            this.originY += yy - 2;
            this.height += -yy + 2;
            this.pixels = newChars;
            yy = 2;
        }
        if (yy >= this.height) {
            newChars = new char[yy + 1 + 2][this.width];
            for (j = 0; j < this.height; ++j) {
                newChars[j] = this.pixels[j];
            }
            this.height = yy + 1 + 2;
            this.pixels = newChars;
        }
        if (set) {
            if (this.mode.getConverterMode() == PixelPlateConverterMode.RAW) {
                this.pixels[yy][xx] = this.character;
            } else {
                char[] cArray = this.pixels[yy];
                int n = xx;
                cArray[n] = (char)(cArray[n] | 1 << y + x * this.mode.getRasterY());
            }
        } else {
            this.pixels[yy][xx] = this.mode.getConverterMode() == PixelPlateConverterMode.RAW ? (char)'\u0000' : (char)(this.pixels[yy][xx] | 1 << y + x * this.mode.getRasterY() - 1 << y + x * this.mode.getRasterY());
        }
    }

    public void drawLineBresenham(int x1, int y1, int x2, int y2) {
        int x = x1;
        int y = y1;
        int d = 0;
        int hx = x2 - x1;
        int hy = y2 - y1;
        int xInc = 1;
        int yInc = 1;
        if (hx < 0) {
            xInc = -1;
            hx = -hx;
        }
        if (hy < 0) {
            yInc = -1;
            hy = -hy;
        }
        if (hy <= hx) {
            int c = 2 * hx;
            int m = 2 * hy;
            while (true) {
                this.set(x, y);
                if (x != x2) {
                    x += xInc;
                    if ((d += m) <= hx) continue;
                    y += yInc;
                    d -= c;
                    continue;
                }
                break;
            }
        } else {
            int c = 2 * hy;
            int m = 2 * hx;
            while (true) {
                this.set(x, y);
                if (y == y2) break;
                y += yInc;
                if ((d += m) <= hy) continue;
                x += xInc;
                d -= c;
            }
        }
    }

    public int getRasterX() {
        return this.mode.getRasterX();
    }

    public int getRasterY() {
        return this.mode.getRasterY();
    }

    public int getPixels(int x, int y) {
        return this.pixels[y][x];
    }

    public CharacterPlate getCharacterPlate() {
        return this.plate;
    }
}

