/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.freehandalgorrithmic;

import de.jave.jave.JavEApplication;
import de.jave.jave.LineAlgorithm;
import de.jave.jave.Tool;
import de.jave.jave.algorithm.freehandalgorithmic.FreehandAlgorithm;
import de.jave.jave.algorithm.freehandalgorithmic.FreehandAlgorithmicMode;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import de.jave.jave.tool.freehandalgorrithmic.FreehandAlgorithmicOptions;
import de.jave.jave.tool.freehandalgorrithmic.FreehandAlgorithmicOptionsPanel;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class FreehandAlgorithmicTool
extends Tool {
    private Point lastMouseLocation;
    private final FreehandAlgorithmicOptions options = new FreehandAlgorithmicOptions();
    private boolean upToDate = false;

    public FreehandAlgorithmicTool(JaveMainPanel plate, JavEApplication asciiPainter) {
        super(plate, asciiPainter);
    }

    @Override
    public String getName() {
        return "Freehand Algorithmic";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_FREEHAND_ALGORITHMIC_ICON;
    }

    @Override
    public JComponent createOptionsComponent() {
        return new FreehandAlgorithmicOptionsPanel(this.options, this.getMouseCharacterModel(), this.getMixCharactersModel()).getContent();
    }

    @Override
    public void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    @Override
    public void putAside(boolean nextToolIsSelectionTool) {
    }

    @Override
    public void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.upToDate = false;
        this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
        this.markPlate.setMode(PixelPlateMode.CHAR);
        this.markPlate.set(location.x, location.y);
        FreehandAlgorithmicMode mode = this.options.getMode();
        if (mode == FreehandAlgorithmicMode.CHARACTERS) {
            this.markPlate.setCharacter(this.getMouseCharacterModel().getCharacter(evt.isMetaDown()));
        } else {
            this.markPlate.setCharacter('#');
        }
        this.lastMouseLocation = location;
        this.repaintCursor();
    }

    @Override
    public void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.isMix());
        if (!this.upToDate) {
            this.convert();
        }
        this.markPlate.pasteResultInto(this.getPlate().getContent());
        this.markPlate = null;
        this.saveCurrentState("freehand");
        this.repaintAll();
    }

    @Override
    public void keyPressed(int code, KeyEvent evt) {
        if (code == 27) {
            this.markPlate = null;
            this.lastMouseLocation = null;
            this.repaintCursor();
            return;
        }
    }

    @Override
    public void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.markPlate == null || location == null || this.lastMouseLocation == null) {
            return;
        }
        if (location.equals(this.lastMouseLocation)) {
            return;
        }
        this.upToDate = false;
        LineAlgorithm.drawLineBresenham(this.markPlate, location, this.lastMouseLocation, this.markPlate.getCharacter());
        this.lastMouseLocation = location;
        this.repaintCursor();
        this.showCoordinates(location);
    }

    @Override
    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.markPlate == null) {
            return;
        }
        this.convert();
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
    }

    private void convert() {
        FreehandAlgorithmicMode mode = this.options.getMode();
        FreehandAlgorithm.convertMarksToFreehandLine(this.markPlate, mode);
        this.upToDate = true;
    }
}

