/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib;

import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.disy.commons.core.io.IOUtilities;

public class CharacterPlateConfiguration
implements IJaveInitializable {
    private static final CharacterPlateConfiguration instance = new CharacterPlateConfiguration();
    private static final String DEFAULT_MIX_RULE_A = "-\\-||---||oooooooooooddddddddddPPPPPPPPP,,,,,....'''''88888bbbb``YY";
    private static final String DEFAULT_MIX_RULE_B = "|/++__/\\/\\PdY8b\"_`'.,P,.'8b`Y_\",.'8b`Y_\".8bY_8bY_8b`Y\"b`Y_\"`Y_\"Y\"_\"";
    private static final String DEFAULT_MIX_RULE_C = "+X++|=++++8d88b8odboo8ddd88d8d88PP88P88P,8bY,8bY.8b'Y\"88888b8b8Y\"8Y";
    private static char[] mixRuleA = "-\\-||---||oooooooooooddddddddddPPPPPPPPP,,,,,....'''''88888bbbb``YY".toCharArray();
    private static char[] mixRuleB = "|/++__/\\/\\PdY8b\"_`'.,P,.'8b`Y_\",.'8b`Y_\".8bY_8bY_8b`Y\"b`Y_\"`Y_\"Y\"_\"".toCharArray();
    private static char[] mixRuleC = "+X++|=++++8d88b8odboo8ddd88d8d88PP88P88P,8bY,8bY.8b'Y\"88888b8b8Y\"8Y".toCharArray();

    @Override
    public void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/mix.txt");
        StringBuffer ra = new StringBuffer();
        StringBuffer rb = new StringBuffer();
        StringBuffer rc = new StringBuffer();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() != 3) continue;
                char chA = line.charAt(0);
                char chB = line.charAt(1);
                char chC = line.charAt(2);
                ra.append(chA);
                rb.append(chB);
                rc.append(chC);
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(configurationFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
        }
        IOUtilities.close(br);
        int size = ra.length();
        mixRuleA = new char[size];
        mixRuleB = new char[size];
        mixRuleC = new char[size];
        ra.getChars(0, size, mixRuleA, 0);
        rb.getChars(0, size, mixRuleB, 0);
        rc.getChars(0, size, mixRuleC, 0);
    }

    private CharacterPlateConfiguration() {
    }

    public static CharacterPlateConfiguration getInstance() {
        return instance;
    }

    public char[] getMixRuleA() {
        return mixRuleA;
    }

    public char[] getMixRuleB() {
        return mixRuleB;
    }

    public char[] getMixRuleC() {
        return mixRuleC;
    }
}

