/*
 * Decompiled with CFR 0.152.
 */
package de.jave.maxosx.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MacOsXInterface
implements InvocationHandler {
    private static Object macOSXApplication;
    private final Object target;
    private final Method handler;
    private final String proxySignature;

    public static void setQuitHandler(Object target, Method quitHandler) {
        MacOsXInterface.setHandler(new MacOsXInterface("handleQuit", target, quitHandler));
    }

    public static void setAboutHandler(Object target, Method aboutHandler) {
        boolean isAboutMenuEnabled;
        boolean bl = isAboutMenuEnabled = target != null && aboutHandler != null;
        if (isAboutMenuEnabled) {
            MacOsXInterface.setHandler(new MacOsXInterface("handleAbout", target, aboutHandler));
        }
        if (macOSXApplication == null) {
            return;
        }
        try {
            Method enableAboutMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
            enableAboutMethod.invoke(macOSXApplication, isAboutMenuEnabled);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static void setPreferencesHandler(Object target, Method prefsHandler) {
        boolean enablePrefsMenu;
        boolean bl = enablePrefsMenu = target != null && prefsHandler != null;
        if (enablePrefsMenu) {
            MacOsXInterface.setHandler(new MacOsXInterface("handlePreferences", target, prefsHandler));
        }
        if (macOSXApplication == null) {
            return;
        }
        try {
            Method enablePrefsMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            enablePrefsMethod.invoke(macOSXApplication, enablePrefsMenu);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static void setFileHandler(final Object target, final Method fileHandler) {
        MacOsXInterface.setHandler(new MacOsXInterface("handleOpenFile", target, fileHandler){

            @Override
            public boolean callTarget(Object appleEvent) {
                if (appleEvent != null) {
                    try {
                        Method getFilenameMethod = appleEvent.getClass().getDeclaredMethod("getFilename", null);
                        String name = (String)getFilenameMethod.invoke(appleEvent, (Object[])null);
                        fileHandler.invoke(target, name);
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (InvocationTargetException e) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                return true;
            }
        });
    }

    public static void setHandler(MacOsXInterface adapter) {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            if (macOSXApplication == null) {
                macOSXApplication = applicationClass.getConstructor(null).newInstance(null);
            }
            Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", applicationListenerClass);
            Object osxAdapterProxy = Proxy.newProxyInstance(MacOsXInterface.class.getClassLoader(), new Class[]{applicationListenerClass}, (InvocationHandler)adapter);
            addListenerMethod.invoke(macOSXApplication, osxAdapterProxy);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected MacOsXInterface(String signature, Object target, Method handler) {
        this.proxySignature = signature;
        this.target = target;
        this.handler = handler;
    }

    public boolean callTarget(Object appleEvent) throws InvocationTargetException, IllegalAccessException {
        Object result = this.handler.invoke(this.target, (Object[])null);
        if (result == null) {
            return true;
        }
        return Boolean.valueOf(result.toString());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isCorrectMethod(method, args)) {
            boolean handled = this.callTarget(args[0]);
            this.setApplicationEventHandled(args[0], handled);
        }
        return null;
    }

    private boolean isCorrectMethod(Method method, Object[] args) {
        return this.handler != null && this.proxySignature.equals(method.getName()) && args.length == 1;
    }

    private void setApplicationEventHandled(Object event, boolean handled) {
        if (event != null) {
            try {
                Method setHandledMethod = event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                setHandledMethod.invoke(event, handled);
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

