/*
 * Decompiled with CFR 0.152.
 */
package de.jave.text;

import java.awt.Dimension;
import java.util.StringTokenizer;

public class TextTools {
    private TextTools() {
    }

    public static final int count(String s, char ch) {
        int result = 0;
        int index = s.indexOf(ch);
        while (index != -1) {
            ++result;
            index = s.indexOf(ch, index + 1);
        }
        return result;
    }

    public static final String fillFront(String text, char fill, int length) {
        while (text.length() < length) {
            text = fill + text;
        }
        return text;
    }

    public static final String firstLetterUp(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        char[] chars = text.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        for (int i = 0; i < chars.length - 1; ++i) {
            if (chars[i] != ' ') continue;
            chars[i + 1] = Character.toUpperCase(chars[i + 1]);
        }
        return new String(chars);
    }

    public static final String[] toStringArray(char[][] ch) {
        int height = ch.length;
        String[] result = new String[height];
        for (int y = 0; y < height; ++y) {
            result[y] = TextTools.trimRight(new String(ch[y]));
        }
        return result;
    }

    public static String trimRight(String line) {
        int i0;
        for (i0 = line.length() - 1; i0 >= 0 && line.charAt(i0) <= ' '; --i0) {
        }
        return line.substring(0, i0 + 1);
    }

    public static final String toString(char[][] ch) {
        int height = ch.length;
        int width = height == 0 ? 0 : ch[0].length;
        StringBuffer sb = new StringBuffer(height * width + height);
        for (int y = 0; y < height; ++y) {
            sb.append(TextTools.trimRight(new String(ch[y])));
            if (y >= height - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final Dimension getDimensionOf(String text) {
        int h = 1;
        int w = 0;
        int currentW = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                if (currentW > w) {
                    w = currentW;
                }
                currentW = 0;
                ++h;
                continue;
            }
            ++currentW;
        }
        if (currentW > w) {
            w = currentW;
        }
        return new Dimension(w, h);
    }

    public static final char[][] toCharField(String[] lines) {
        int h = lines.length;
        int w = 0;
        for (int y = 0; y < h; ++y) {
            if (lines[y].length() <= w) continue;
            w = lines[y].length();
        }
        char[][] ch = new char[h][w];
        for (int y = 0; y < h; ++y) {
            int x;
            for (x = 0; x < lines[y].length(); ++x) {
                ch[y][x] = lines[y].charAt(x);
            }
            for (x = lines[y].length(); x < w; ++x) {
                ch[y][x] = 32;
            }
        }
        return ch;
    }

    public static final char[][] toCharField(String text) {
        Dimension d = TextTools.getDimensionOf(text);
        if (d.width == 0 && d.height > 0) {
            d.width = 1;
        } else if (d.height == 0 && d.width > 0) {
            d.height = 1;
        }
        char[][] ch = new char[d.height][d.width];
        int y = 0;
        int x = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                for (int xx = x; xx < d.width; ++xx) {
                    ch[y][xx] = 32;
                }
                x = 0;
                ++y;
                continue;
            }
            ch[y][x] = text.charAt(i);
            ++x;
        }
        for (int xx = x; xx < d.width; ++xx) {
            ch[y][xx] = 32;
        }
        return ch;
    }

    public static final String[] toStringArray(String text) {
        Dimension d = TextTools.getDimensionOf(text);
        if (d.height <= 1) {
            return new String[]{text};
        }
        String[] result = new String[d.height];
        int y = 0;
        int x1 = 0;
        int x2 = 0;
        int l = text.length();
        while (y < d.height) {
            while (x2 < l && text.charAt(x2) != '\n') {
                ++x2;
            }
            result[y++] = text.substring(x1, x2);
            x1 = x2 + 1;
            ++x2;
        }
        return result;
    }

    public static String center(String s, int length) {
        int i;
        int d = length - s.length();
        int a = d / 2;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < a; ++i) {
            sb.append(' ');
        }
        sb.append(s);
        for (i = a; i < d; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static void print(int[][] c) {
        for (int y = 0; y < c.length; ++y) {
            for (int x = 0; x < c[y].length; ++x) {
                System.out.print(c[y][x] + "\t");
            }
            System.out.println();
        }
    }

    public static void print(double[][] c) {
        for (int y = 0; y < c.length; ++y) {
            for (int x = 0; x < c[y].length; ++x) {
                System.out.print(c[y][x] + "\t");
            }
            System.out.println();
        }
    }

    public static int editDistance(String s1, String s2) {
        int i;
        int n = s1.length();
        int m = s2.length();
        int[][] c = new int[n + 1][m + 1];
        for (i = 0; i <= m; ++i) {
            c[0][i] = i;
        }
        for (i = 0; i <= n; ++i) {
            c[i][0] = i;
        }
        for (int i2 = 1; i2 <= n; ++i2) {
            for (int j = 1; j <= m; ++j) {
                int c1 = c[i2 - 1][j] + 1;
                int c2 = c[i2][j - 1] + 1;
                int c3 = c[i2 - 1][j - 1];
                if (s1.charAt(i2 - 1) != s2.charAt(j - 1)) {
                    ++c3;
                }
                c3 = c3 <= c2 ? c3 : c2;
                c[i2][j] = c3 <= c1 ? c3 : c1;
            }
        }
        return c[n][m];
    }

    public static int editDistance(String s1, String s2, int max) {
        int i;
        int m;
        int n = s1.length();
        if (n - (m = s2.length()) > max || m - n > max) {
            return max;
        }
        int[][] c = new int[n + 1][m + 1];
        for (i = 0; i <= m; ++i) {
            c[0][i] = i;
        }
        for (i = 0; i <= n; ++i) {
            c[i][0] = i;
        }
        for (int i2 = 1; i2 <= n; ++i2) {
            for (int j = 1; j <= m; ++j) {
                int c1 = c[i2 - 1][j] + 1;
                int c2 = c[i2][j - 1] + 1;
                int c3 = c[i2 - 1][j - 1];
                if (s1.charAt(i2 - 1) != s2.charAt(j - 1)) {
                    ++c3;
                }
                c3 = c3 <= c2 ? c3 : c2;
                c[i2][j] = c3 <= c1 ? c3 : c1;
            }
        }
        return c[n][m];
    }

    public static int editDistanceGebhard(String s1, String s2) {
        int i;
        int n = s1.length();
        int m = s2.length();
        int[][] c = new int[n + 1][m + 1];
        for (i = 0; i <= m; ++i) {
            c[0][i] = i;
        }
        for (i = 0; i <= n; ++i) {
            c[i][0] = i;
        }
        for (int i2 = 1; i2 <= n; ++i2) {
            for (int j = 1; j <= m; ++j) {
                int c1 = c[i2 - 1][j] + 1;
                int c2 = c[i2][j - 1] + 1;
                int c3 = c[i2 - 1][j - 1];
                if (s1.charAt(i2 - 1) != s2.charAt(j - 1)) {
                    c3 = Character.toLowerCase(s1.charAt(i2 - 1)) == Character.toLowerCase(s2.charAt(j - 1)) ? ++c3 : (c3 += 2);
                }
                c3 = c3 <= c2 ? c3 : c2;
                c[i2][j] = c3 <= c1 ? c3 : c1;
            }
        }
        return c[n][m];
    }

    public static double levenshteinDistance(String s1, String s2, double wInsert, double wDelete, double wCase, double wSubst) {
        int i;
        int n = s1.length();
        int m = s2.length();
        double[][] c = new double[n + 1][m + 1];
        for (i = 0; i <= m; ++i) {
            c[0][i] = (double)i * wInsert;
        }
        for (i = 0; i <= n; ++i) {
            c[i][0] = (double)i * wDelete;
        }
        for (int i2 = 1; i2 <= n; ++i2) {
            for (int j = 1; j <= m; ++j) {
                char ch2;
                double c1 = c[i2 - 1][j] + wDelete;
                double c2 = c[i2][j - 1] + wInsert;
                double c3 = c[i2 - 1][j - 1];
                char ch1 = s1.charAt(i2 - 1);
                if (ch1 != (ch2 = s2.charAt(j - 1))) {
                    c3 = Character.toUpperCase(ch1) == Character.toUpperCase(ch2) ? (c3 += wCase) : (c3 += wSubst);
                }
                c3 = c3 <= c2 ? c3 : c2;
                c[i2][j] = c3 <= c1 ? c3 : c1;
            }
        }
        TextTools.print(c);
        return c[n][m];
    }

    public static String trim(String s) {
        if (s.length() == 0) {
            return "";
        }
        StringBuffer s2 = new StringBuffer(s.length());
        StringTokenizer st = new StringTokenizer(s, "\n\r", true);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!t.equals("\n") && !t.equals("\r")) {
                int i0;
                for (i0 = t.length() - 1; i0 >= 0 && t.charAt(i0) <= ' '; --i0) {
                }
                t = t.substring(0, i0 + 1);
            }
            s2.append(t);
        }
        s = s2.toString();
        int i0 = 0;
        char ch = s.charAt(0);
        while (i0 < s.length() - 1 && (ch == '\n' || ch == '\r')) {
            ch = s.charAt(++i0);
        }
        int i1 = s.length() - 1;
        ch = s.charAt(i1);
        while (i1 > i0 && (ch == '\n' || ch == '\r')) {
            ch = s.charAt(--i1);
        }
        String result = s.substring(i0, i1 + 1);
        return result;
    }
}

