/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.att.AttributeManager;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import java.util.StringTokenizer;

public class DefineLinePattern
implements Cmd {
    private String m_toString = null;
    private String m_svName = null;
    private double[] m_svValue;
    private boolean m_override = false;
    private double[] m_overridenValue;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        String name;
        Kernel krnl = (Kernel)context;
        AttributeManager atm = AttributeManager.getAttributeManager();
        if (atm.containsLinePattern(name = krnl.readString(Messages.getString("db.att.DefineLinePattern.0")))) {
            this.m_override = true;
            this.m_overridenValue = atm.getLinePattern(name);
            krnl.readOK(Messages.getString("db.att.DefineLinePattern.1"), Messages.getString("db.att.DefineLinePattern.2"), String.valueOf(Messages.getString("db.att.DefineLinePattern.3")) + name + Messages.getString("db.att.DefineLinePattern.4") + atm.getLinePattern(name).toString() + Messages.getString("db.att.DefineLinePattern.5"), 10);
        }
        String dashes = krnl.readString(Messages.getString("db.att.DefineLinePattern.6"), "");
        StringTokenizer st = new StringTokenizer(dashes, ", ");
        double[] value = null;
        int nTokens = st.countTokens();
        if (nTokens > 0) {
            value = new double[nTokens];
            int i = 0;
            while (i < nTokens) {
                String token = st.nextToken();
                try {
                    double x;
                    value[i] = x = Double.parseDouble(token);
                }
                catch (NumberFormatException e) {
                    System.err.println(Messages.getString("db.att.DefineLinePattern.8"));
                    return;
                }
                ++i;
            }
        }
        this.m_svName = name;
        this.m_svValue = value;
        atm.addLinePattern(name, value);
        String d = "[";
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                d = String.valueOf(d) + value[i] + " ";
                ++i;
            }
        } else {
            d = String.valueOf(d) + "null";
        }
        d = String.valueOf(d) + "]";
        this.m_toString = String.valueOf(Messages.getString("db.att.DefineLinePattern.13")) + name + Messages.getString("db.att.DefineLinePattern.14") + d + Messages.getString("db.att.DefineLinePattern.15");
        System.out.println(this);
        if (this.m_override) {
            krnl.getUserInterface().repaintUserInterface();
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        AttributeManager atm = AttributeManager.getAttributeManager();
        if (!this.m_override) {
            atm.removeLinePattern(this.m_svName);
        } else {
            atm.addLinePattern(this.m_svName, this.m_overridenValue);
            krnl.getUserInterface().repaintUserInterface();
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        AttributeManager atm = AttributeManager.getAttributeManager();
        atm.addLinePattern(this.m_svName, this.m_svValue);
        if (this.m_override) {
            krnl.getUserInterface().repaintUserInterface();
        }
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

