/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.feature.AngleFeature;
import cib.cad.db.feature.DistanceFeature;
import cib.cad.db.feature.DrawPaintFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.FillPaintFeature;
import cib.cad.db.feature.FontFamilyFeature;
import cib.cad.db.feature.LinePatternFeature;
import cib.cad.db.feature.LineWidthFeature;
import cib.cad.db.feature.Point2DFeature;
import cib.cad.db.feature.TextSizeFeature;
import cib.cad.db.feature.VisibilityFeature;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.ObservableObject;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ComponentLine2D
extends Line2D.Double
implements Component,
CtrlSegments {
    private static final long serialVersionUID = 1L;
    private Attributes m_attribute = null;
    private Set<ObservableObject.Listener> m_listeners = new HashSet<ObservableObject.Listener>();
    private transient Point2D[] t_locs = new Point2D[3];
    private static final String[] FEATURE_NAMES = new String[]{"GENERAL.LINE_PATTERN", "GENERAL.LINE_WIDTH", "GENERAL.DRAW_PAINT", "GENERAL.FILL_PAINT", "GENERAL.TEXT_SIZE", "GENERAL.FONT_FAMILY", "GENERAL.VISIBILITY", "GEOMETRY.START_POINT_2D", "GEOMETRY.END_POINT_2D", "GEOMETRY.LENGTH", "GEOMETRY.ANGLE"};

    public ComponentLine2D() {
        this.setLine(0.0, 0.0, 0.0, 0.0);
    }

    public ComponentLine2D(double x1, double y1, double x2, double y2) {
        this.setLine(x1, y1, x2, y2);
    }

    public ComponentLine2D(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public ComponentLine2D(Line2D l) {
        this.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.x1);
        out.writeDouble(this.y1);
        out.writeDouble(this.x2);
        out.writeDouble(this.y2);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x1 = in.readDouble();
        this.y1 = in.readDouble();
        this.x2 = in.readDouble();
        this.y2 = in.readDouble();
    }

    @Override
    public Object clone() {
        ComponentLine2D dst = (ComponentLine2D)super.clone();
        dst.m_listeners = new HashSet<ObservableObject.Listener>();
        dst.setAttributes(this.m_attribute);
        this._notifyWasCloned(dst);
        return dst;
    }

    @Override
    public void assign(Component rhs) {
        ComponentLine2D rhsComp = (ComponentLine2D)rhs;
        this.setLine(rhsComp.getP1(), rhsComp.getP2());
        this.setAttributes(rhsComp.m_attribute);
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(this.getP1(), this.getP2());
        return r;
    }

    @Override
    public Point2D getP1() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double p1 = new Point2D.Double();
        return w2u.transform(super.getP1(), p1);
    }

    @Override
    public Point2D getP2() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double p2 = new Point2D.Double();
        return w2u.transform(super.getP2(), p2);
    }

    @Override
    public double getX1() {
        return this.getP1().getX();
    }

    @Override
    public double getY1() {
        return this.getP1().getY();
    }

    @Override
    public double getX2() {
        return this.getP2().getX();
    }

    @Override
    public double getY2() {
        return this.getP2().getY();
    }

    @Override
    public void setLine(double x1, double y1, double x2, double y2) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        u2w.transform(new Point2D.Double(x1, y1), p1);
        u2w.transform(new Point2D.Double(x2, y2), p2);
        super.setLine(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY());
        this._notifyWasChanged();
    }

    @Override
    public void transformBy(AffineTransform mat) {
        Point2D p1 = this.getP1();
        Point2D.Double q1 = new Point2D.Double();
        mat.transform(p1, q1);
        Point2D p2 = this.getP2();
        Point2D.Double q2 = new Point2D.Double();
        mat.transform(p2, q2);
        this.setLine(q1, q2);
    }

    private AttributedShape getShape() {
        AttributedShape as = new AttributedShape(new Line2D.Double(this.getP1(), this.getP2()));
        AttributeManager atm = AttributeManager.getAttributeManager();
        Attributes attr = this.m_attribute == null ? new Attributes() : this.m_attribute;
        as.setStroke(atm.getModelStroke(attr.getLineWidth(), attr.getLinePattern()));
        as.setDrawPaint(atm.getDrawPaint(attr.getDrawPaint()));
        as.setFillPaint(atm.getFillPaint(attr.getFillPaint()));
        return as;
    }

    @Override
    public AttributedShape getShape(int name) throws IllegalArgumentException {
        if (name == 0) {
            return this.getShape();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setShape(AttributedShape shape, int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return NamedListIteratorAdapter.singletonNamedListIterator(this.getShape());
    }

    @Override
    public AttributedText getText(int name) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    @Override
    public void setText(AttributedText text, int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedListIterator<AttributedText> textIterator() {
        return NamedListIteratorAdapter.emptyNamedListIterator();
    }

    @Override
    public int getCtrlType(int name) {
        switch (name) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 8;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean hasControlPoint(int name) {
        return name >= 0 && name <= 2;
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        switch (name) {
            case 0: {
                return this.getP1();
            }
            case 1: {
                return this.getP2();
            }
            case 2: {
                return new Point2D.Double(0.5 * (this.getX1() + this.getX2()), 0.5 * (this.getY1() + this.getY2()));
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getControlPointChildrenCount(int name) {
        switch (name) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getControlPointChild(int name, int iChild) {
        switch (name) {
            case 2: {
                switch (iChild) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getVertexSegmentCount(int vtxName) {
        switch (vtxName) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getVertexSegmentAt(int vtxName, int iSegment) {
        switch (vtxName) {
            case 0: 
            case 1: {
                if (iSegment != 0) break;
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentVertex1(int segName) {
        switch (segName) {
            case 2: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentVertex2(int segName) {
        switch (segName) {
            case 2: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentPointCount(int segName) {
        switch (segName) {
            case 2: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentPointAt(int segName, int iPoint) {
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentCrds(int segName, double[] crds) {
        switch (segName) {
            case 2: {
                crds[0] = this.getX1();
                crds[1] = this.getY1();
                crds[2] = this.getX2();
                crds[3] = this.getY2();
                return 8;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setSegmentCrds(int segName, double[] crds) throws UnsupportedOperationException {
        switch (segName) {
            case 2: {
                this.setLine(crds[0], crds[1], crds[2], crds[3]);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setControlPointStarts() {
        if (this.t_locs == null) {
            this.t_locs = new Point2D[3];
        }
        int i = 0;
        while (i < this.t_locs.length) {
            this.t_locs[i] = null;
            ++i;
        }
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        this.t_locs[name] = pnt;
    }

    @Override
    public void setControlPointEnds() {
        if (this.t_locs[2] != null) {
            Point2D p = this.getControlPoint(2);
            double dx = this.t_locs[2].getX() - p.getX();
            double dy = this.t_locs[2].getY() - p.getY();
            int i = 0;
            while (i < 2) {
                this.t_locs[i] = this.getControlPoint(i);
                this.t_locs[i].setLocation(this.t_locs[i].getX() + dx, this.t_locs[i].getY() + dy);
                ++i;
            }
        }
        Point2D sp = this.t_locs[0] == null ? this.getControlPoint(0) : this.t_locs[0];
        Point2D ep = this.t_locs[1] == null ? this.getControlPoint(1) : this.t_locs[1];
        this.setLine(sp, ep);
    }

    @Override
    public void removeControlPointStarts() {
    }

    @Override
    public void removeControlPoint(int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeControlPointEnds() {
    }

    @Override
    public void setCtrlType(int type, int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int split(int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return 3;
            }

            @Override
            protected Point2D _get(int index) {
                return ComponentLine2D.this.getControlPoint(index);
            }

            @Override
            protected void _set(int index, Point2D p) {
                ComponentLine2D.this.setControlPoint(p, index);
            }
        };
    }

    @Override
    public AttributedImage getImage(int name) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    @Override
    public void setImage(AttributedImage image, int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedListIterator<AttributedImage> imageIterator() {
        return NamedListIteratorAdapter.emptyNamedListIterator();
    }

    @Override
    public Attributes getAttributes() {
        return this.m_attribute == null ? null : new Attributes(this.m_attribute);
    }

    @Override
    public void setAttributes(Attributes attribute) {
        this.m_attribute = attribute == null ? new Attributes() : new Attributes(attribute);
        this._notifyWasChanged();
    }

    @Override
    public boolean addListener(ObservableObject.Listener l) {
        return this.m_listeners.add(l);
    }

    @Override
    public boolean removeListener(ObservableObject.Listener l) {
        return this.m_listeners.remove(l);
    }

    @Override
    public void clearListeners() {
        this.m_listeners.clear();
    }

    private void _notifyWasChanged() {
        for (ObservableObject.Listener l : this.m_listeners) {
            l.wasChanged(this);
        }
    }

    private void _notifyWasCloned(ObservableObject dst) {
        for (ObservableObject.Listener l : this.m_listeners) {
            l.wasCloned(this, dst);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + Geo2D.formatCoordinate(this.getX1()) + ", " + Geo2D.formatCoordinate(this.getY1()) + ", " + Geo2D.formatCoordinate(this.getX2()) + ", " + Geo2D.formatCoordinate(this.getY2()) + ")";
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            return new LinePatternFeature(FEATURE_NAMES[0], this.getAttributes().getLinePattern());
        }
        if (name.equals(FEATURE_NAMES[1])) {
            return new LineWidthFeature(FEATURE_NAMES[1], this.getAttributes().getLineWidth());
        }
        if (name.equals(FEATURE_NAMES[2])) {
            return new DrawPaintFeature(FEATURE_NAMES[2], this.getAttributes().getDrawPaint());
        }
        if (name.equals(FEATURE_NAMES[3])) {
            return new FillPaintFeature(FEATURE_NAMES[3], this.getAttributes().getFillPaint());
        }
        if (name.equals(FEATURE_NAMES[4])) {
            return new TextSizeFeature(FEATURE_NAMES[4], this.getAttributes().getTextSize());
        }
        if (name.equals(FEATURE_NAMES[5])) {
            return new FontFamilyFeature(FEATURE_NAMES[5], this.getAttributes().getFontFamily());
        }
        if (name.equals(FEATURE_NAMES[6])) {
            return new VisibilityFeature(FEATURE_NAMES[6], this.getAttributes().getVisibility());
        }
        if (name.equals(FEATURE_NAMES[7])) {
            return new Point2DFeature(FEATURE_NAMES[7], this.getP1());
        }
        if (name.equals(FEATURE_NAMES[8])) {
            return new Point2DFeature(FEATURE_NAMES[8], this.getP2());
        }
        if (name.equals(FEATURE_NAMES[9])) {
            return new DistanceFeature(FEATURE_NAMES[9], Geo2D.distance(this.getP1(), this.getP2()));
        }
        if (name.equals(FEATURE_NAMES[10])) {
            Vector2D vec = new Vector2D(this.getP1(), this.getP2());
            double angle = 0.0;
            try {
                angle = Vector2D.X_UNIT.getAngleCCW(vec);
            }
            catch (NullVectorException nullVectorException) {
                // empty catch block
            }
            return new AngleFeature(FEATURE_NAMES[10], angle);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setFeature(Feature feature) {
        Attributes attributes = new Attributes(this.getAttributes());
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            attributes.setLinePattern((String)feature.getValue());
            this.setAttributes(attributes);
            this._notifyWasChanged();
            return;
        }
        if (feature.getName().equals(FEATURE_NAMES[1])) {
            attributes.setLineWidth((String)feature.getValue());
            this.setAttributes(attributes);
            this._notifyWasChanged();
            return;
        }
        if (feature.getName().equals(FEATURE_NAMES[2])) {
            attributes.setDrawPaint((String)feature.getValue());
            this.setAttributes(attributes);
            this._notifyWasChanged();
            return;
        }
        if (feature.getName().equals(FEATURE_NAMES[3])) {
            attributes.setFillPaint((String)feature.getValue());
            this.setAttributes(attributes);
            this._notifyWasChanged();
            return;
        }
        if (feature.getName().equals(FEATURE_NAMES[4])) {
            attributes.setTextSize((String)feature.getValue());
            this.setAttributes(attributes);
            this._notifyWasChanged();
            return;
        }
        if (feature.getName().equals(FEATURE_NAMES[5])) {
            attributes.setFontFamily((String)feature.getValue());
            this.setAttributes(attributes);
            this._notifyWasChanged();
            return;
        }
        if (feature.getName().equals(FEATURE_NAMES[6])) {
            attributes.setVisibility((String)feature.getValue());
            this.setAttributes(attributes);
            this._notifyWasChanged();
            return;
        }
        Point2D p1 = this.getP1();
        Point2D p2 = this.getP2();
        if (feature.getName().equals(FEATURE_NAMES[7])) {
            p1 = (Point2D)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[8])) {
            p2 = (Point2D)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[9])) {
            double len = (Double)feature.getValue();
            Vector2D vec = new Vector2D(p1, p2);
            try {
                vec.normalize();
                vec.scaleBy(len);
                p2.setLocation(vec.add(p1));
            }
            catch (NullVectorException nullVectorException) {}
        } else if (feature.getName().equals(FEATURE_NAMES[10])) {
            double ang = (Double)feature.getValue();
            Vector2D vec = new Vector2D(ang);
            double dist = Geo2D.distance(p1, p2);
            vec.scaleBy(dist);
            p2.setLocation(vec.add(p1));
        } else {
            throw new IllegalArgumentException();
        }
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        this._notifyWasChanged();
    }

    @Override
    public Iterator<Feature> featureIterator() {
        return new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentLine2D.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

