/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerManager;
import cib.cad.db.layer.LayerSelector;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class SetDefaultLayer
implements Cmd {
    private String m_toString = null;
    private String m_svDefaultLayerName = null;
    private Attributes m_svDefaultAttribute = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        LayerManager lm = LayerManager.getLayerManager();
        this.m_svDefaultAttribute = db.getAttributeManager().getDefaultAttributes();
        this.m_svDefaultLayerName = lm.getDefaultLayer();
        LayerSelector layerSelector = LayerSelector.getLayerSelector(krnl);
        String name = layerSelector.select(Messages.getString("db.layer.SetDefaultLayer.0"));
        Layer layer = lm.setDefaultLayer(name);
        if (krnl.readYesNo(Messages.getString("db.layer.SetDefaultLayer.1"), 2)) {
            db.getAttributeManager().setDefaultAttributes(layer.getAttributes());
        }
        String locName = lm.getLocalizedLayerName(name);
        String semantics = lm.getLocalizedLayerSemantics(name);
        this.m_toString = String.valueOf(Messages.getString("db.layer.SetDefaultLayer.2")) + locName + Messages.getString("db.layer.SetDefaultLayer.3") + semantics + Messages.getString("db.layer.SetDefaultLayer.4") + layer.getAttributes().toString() + Messages.getString("db.layer.SetDefaultLayer.5");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        AttributeManager atm = db.getAttributeManager();
        LayerManager lm = LayerManager.getLayerManager();
        String defaultLayerName = lm.getDefaultLayer();
        lm.setDefaultLayer(this.m_svDefaultLayerName);
        this.m_svDefaultLayerName = defaultLayerName;
        Attributes defAtt = atm.getDefaultAttributes();
        atm.setDefaultAttributes(this.m_svDefaultAttribute);
        this.m_svDefaultAttribute = defAtt;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

