/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.ext.dxf.ExportEntityHeader;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.io.IOException;

public class ExportArc
extends ExportEntityHeader {
    private double m_centerX = 0.0;
    private double m_centerY = 0.0;
    private double m_radius = 0.0;
    private double m_startAngle = 0.0;
    private double m_endAngle = 0.0;

    public ExportArc(double centerX, double centerY, double radius, double startAngle, double endAngle) {
        this.m_centerX = centerX;
        this.m_centerY = centerY;
        this.m_radius = radius;
        this.m_startAngle = startAngle;
        this.m_endAngle = endAngle;
    }

    @Override
    public boolean commit(DXFWriter writer) throws IOException {
        if (this._isNaN()) {
            return false;
        }
        writer.writeGroup(GroupCode.GC0, "ARC");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbCircle");
        writer.writeGroup(GroupCode.GC10, this.m_centerX);
        writer.writeGroup(GroupCode.GC20, this.m_centerY);
        writer.writeGroup(GroupCode.GC40, this.m_radius);
        writer.writeGroup(GroupCode.GC100, "AcDbArc");
        writer.writeGroup(GroupCode.GC50, this.m_startAngle);
        writer.writeGroup(GroupCode.GC51, this.m_endAngle);
        return true;
    }

    private boolean _isNaN() {
        return Double.isNaN(this.m_centerX) || Double.isNaN(this.m_centerY) || Double.isNaN(this.m_radius) || Double.isNaN(this.m_startAngle) || Double.isNaN(this.m_endAngle);
    }
}

