/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.ext.dxf.ExportEntityHeader;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.AttributedShape;
import cib.util.CoordSpace;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import cib.util.view.FillPaint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExportHatch
extends ExportEntityHeader {
    private AttributedShape m_attributedShape = null;
    private double m_flatness = 0.005;

    public ExportHatch(AttributedShape as, double flatness) {
        this.m_attributedShape = as;
        this.m_flatness = flatness;
    }

    @Override
    public boolean commit(DXFWriter writer) throws IOException {
        if (this.m_attributedShape == null || this._isNaN()) {
            return false;
        }
        PathIterator pit = this.m_attributedShape.getPathIterator(null, this.m_flatness);
        if (pit.isDone()) {
            return false;
        }
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        int nLoops = 0;
        boolean isDegenerated = true;
        while (!pit.isDone()) {
            double[] crds = new double[6];
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: {
                    ++nLoops;
                    break;
                }
                default: {
                    isDegenerated = false;
                }
            }
            pit.next();
        }
        if (isDegenerated) {
            return false;
        }
        writer.writeGroup(GroupCode.GC0, "HATCH");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbHatch");
        writer.writeGroup(GroupCode.GC10, 0);
        writer.writeGroup(GroupCode.GC20, 0);
        writer.writeGroup(GroupCode.GC30, 0);
        writer.writeGroup(GroupCode.GC210, 0);
        writer.writeGroup(GroupCode.GC220, 0);
        writer.writeGroup(GroupCode.GC230, 1);
        if (this.m_attributedShape.getFillPaint() instanceof FillPaint) {
            writer.writeGroup(GroupCode.GC2, "CADEMIA_HATCH");
            writer.writeGroup(GroupCode.GC70, 0);
        } else {
            writer.writeGroup(GroupCode.GC2, "CADEMIA_SOLID");
            writer.writeGroup(GroupCode.GC70, 1);
        }
        writer.writeGroup(GroupCode.GC71, 0);
        writer.writeGroup(GroupCode.GC91, nLoops);
        ArrayList<Shape> edges = new ArrayList<Shape>();
        double[] crds = new double[6];
        double[] moveto = new double[2];
        double[] lastpnt = new double[2];
        pit = this.m_attributedShape.getPathIterator(null, this.m_flatness);
        while (!pit.isDone()) {
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: {
                    if (!edges.isEmpty()) {
                        this.writeLoop(writer, edges);
                        edges.clear();
                    }
                    moveto[0] = crds[0];
                    moveto[1] = crds[1];
                    lastpnt[0] = crds[0];
                    lastpnt[1] = crds[1];
                    break;
                }
                case 1: {
                    edges.add(new Line2D.Double(lastpnt[0], lastpnt[1], crds[0], crds[1]));
                    lastpnt[0] = crds[0];
                    lastpnt[1] = crds[1];
                    break;
                }
                case 4: {
                    edges.add(new Line2D.Double(lastpnt[0], lastpnt[1], moveto[0], moveto[1]));
                }
            }
            pit.next();
        }
        if (!edges.isEmpty()) {
            this.writeLoop(writer, edges);
            edges.clear();
        }
        writer.writeGroup(GroupCode.GC75, 0);
        writer.writeGroup(GroupCode.GC76, 1);
        if (this.m_attributedShape.getFillPaint() instanceof FillPaint) {
            writer.writeGroup(GroupCode.GC52, 0);
            writer.writeGroup(GroupCode.GC41, 1);
            writer.writeGroup(GroupCode.GC77, 0);
            writer.writeGroup(GroupCode.GC78, 1);
            writer.writeGroup(GroupCode.GC53, 45);
            writer.writeGroup(GroupCode.GC43, 0);
            writer.writeGroup(GroupCode.GC44, 0);
            double offsetX = -2.5;
            double offsetY = 2.5;
            writer.writeGroup(GroupCode.GC45, offsetX *= cs.getScale() / cs.getMillimetersPerNaturalUnit());
            writer.writeGroup(GroupCode.GC46, offsetY *= cs.getScale() / cs.getMillimetersPerNaturalUnit());
            writer.writeGroup(GroupCode.GC79, 0);
            writer.writeGroup(GroupCode.GC98, 1);
            writer.writeGroup(GroupCode.GC10, 0);
            writer.writeGroup(GroupCode.GC20, 0);
        } else {
            writer.writeGroup(GroupCode.GC98, 0);
            writer.writeGroup(GroupCode.GC450, 0);
            writer.writeGroup(GroupCode.GC451, 0);
            writer.writeGroup(GroupCode.GC460, 0.0);
            writer.writeGroup(GroupCode.GC461, 0.0);
            writer.writeGroup(GroupCode.GC452, 0);
            writer.writeGroup(GroupCode.GC462, 0.0);
            writer.writeGroup(GroupCode.GC453, 0);
            writer.writeGroup(GroupCode.GC470, "");
        }
        return true;
    }

    private void writeLoop(DXFWriter writer, List<Shape> edges) throws IOException {
        writer.writeGroup(GroupCode.GC92, 0);
        int nEdges = edges.size();
        writer.writeGroup(GroupCode.GC93, nEdges);
        int iEdge = 0;
        while (iEdge < nEdges) {
            Shape shape = edges.get(iEdge);
            if (!(shape instanceof Line2D)) {
                throw new AssertionError((Object)Messages.getString("ext.dxf.ExportHatch.5"));
            }
            Line2D l = (Line2D)shape;
            writer.writeGroup(GroupCode.GC72, 1);
            writer.writeGroup(GroupCode.GC10, l.getX1());
            writer.writeGroup(GroupCode.GC20, l.getY1());
            writer.writeGroup(GroupCode.GC11, l.getX2());
            writer.writeGroup(GroupCode.GC21, l.getY2());
            ++iEdge;
        }
        writer.writeGroup(GroupCode.GC97, 0);
    }

    private boolean _isNaN() {
        return this.m_attributedShape != null && Double.isNaN(this.m_attributedShape.getBounds2D().getWidth());
    }
}

