/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.att.AttributeManager;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExportStyleEntries {
    private static Map<String, String> ACAD_FONT_FILE_NAMES = new HashMap<String, String>();

    static {
        ACAD_FONT_FILE_NAMES.put("arial", "arial.ttf");
        ACAD_FONT_FILE_NAMES.put("sansserif", "sanss___.ttf");
        ACAD_FONT_FILE_NAMES.put("courier new", "cour.ttf");
        ACAD_FONT_FILE_NAMES.put("serif", "times.ttf");
    }

    public boolean commit(DXFWriter writer) throws IOException {
        HashSet<String> transferredFontFamilies = new HashSet<String>();
        AttributeManager atm = AttributeManager.getAttributeManager();
        Set<String> fontFamilyNames = atm.getFontFamilies();
        for (String name : fontFamilyNames) {
            String fontFamily = atm.getFontFamily(name);
            if (transferredFontFamilies.contains(fontFamily)) continue;
            transferredFontFamilies.add(fontFamily);
            String fontFileName = ACAD_FONT_FILE_NAMES.get(fontFamily);
            writer.writeGroup(GroupCode.GC0, "STYLE");
            writer.writeGroup(GroupCode.GC5, writer.nextHandle());
            writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            writer.writeGroup(GroupCode.GC100, "AcDbTextStyleTableRecord");
            writer.writeGroup(GroupCode.GC2, fontFamily);
            writer.writeGroup(GroupCode.GC3, fontFileName);
            writer.writeGroup(GroupCode.GC70, "0");
        }
        return true;
    }
}

