/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.util.NameSpace;
import cib.util.coll.ReverseAccessMap;
import cib.util.dxf.ColorNumber;
import cib.util.dxf.GroupCode;
import java.awt.Color;
import java.util.Set;

public class ImportAttributes {
    public static void apply(Kernel krnl, Component comp, cib.util.dxf.Attributes atts) {
        int lineweightEnum;
        String linetypeName;
        int colorNumber;
        Attributes layerAttr;
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        AttributeManager atm = db.getAttributeManager();
        Attributes attr = comp.getAttributes();
        attr.setFillPaint("DEFAULT");
        String layerName = atts.getValue(GroupCode.GC8);
        Layer layer = (Layer)ns.getObject(layerName);
        if (layer != null) {
            layerMap.put(comp, layer);
        }
        if (layer != null && (layerAttr = layer.getAttributes()) != null) {
            attr.setDrawPaint(layerAttr.getDrawPaint());
            attr.setLinePattern(layerAttr.getLinePattern());
            attr.setVisibility(layerAttr.getVisibility());
        }
        if (atts.valueExists(GroupCode.GC62) && (colorNumber = atts.getIntValue(GroupCode.GC62)) > 0 && colorNumber < 256) {
            String name = "COLOR_" + colorNumber;
            Color color = ColorNumber.valueOf(name).toColor();
            if (!atm.containsDrawPaint(name)) {
                atm.addDrawPaint(name, color);
            }
            attr.setDrawPaint(name);
        }
        if (atts.valueExists(GroupCode.GC6) && (linetypeName = atts.getValue(GroupCode.GC6)) != null && atm.containsLinePattern(linetypeName)) {
            if (atts.valueExists(GroupCode.GC48)) {
                double linetypeScale = atts.getDoubleValue(GroupCode.GC48);
                String scaledLinetypeName = String.valueOf(linetypeName) + "_" + linetypeScale;
                if (!atm.containsLinePattern(scaledLinetypeName)) {
                    double[] linetypePattern = atm.getLinePattern(linetypeName);
                    if (linetypePattern != null) {
                        int i = 0;
                        while (i < linetypePattern.length) {
                            int n = i++;
                            linetypePattern[n] = linetypePattern[n] * linetypeScale;
                        }
                    }
                    linetypeName = scaledLinetypeName;
                    try {
                        atm.addLinePattern(linetypeName, linetypePattern);
                    }
                    catch (IllegalArgumentException e) {
                        atm.addLinePattern(linetypeName, null);
                    }
                }
            }
            attr.setLinePattern(linetypeName);
        }
        if ((lineweightEnum = atts.getIntValue(GroupCode.GC370, -1)) > 0) {
            double width = (double)lineweightEnum / 100.0;
            String name = "LW_" + Long.toString(Math.round(width * 100.0));
            if (!atm.containsLineWidth(name)) {
                atm.addLineWidth(name, width);
            }
            attr.setLineWidth(name);
        } else {
            attr.setLineWidth("DEFAULT");
        }
        if (atts.valueExists(GroupCode.GC60)) {
            boolean isVisible = atts.getIntValue(GroupCode.GC60, 0) == 0;
            attr.setVisibility(ImportAttributes.visibilityName(isVisible, true));
        }
        comp.setAttributes(attr);
    }

    public static String colorName(cib.util.dxf.Attributes atts, boolean define) {
        AttributeManager atm = AttributeManager.getAttributeManager();
        String name = null;
        int colorNumber = Math.abs(atts.getIntValue(GroupCode.GC62, 256));
        if (colorNumber != 256) {
            name = "COLOR_" + colorNumber;
            if (define) {
                Color color = ColorNumber.valueOf(name).toColor();
                if (!atm.containsDrawPaint(name)) {
                    atm.addDrawPaint(name, color);
                }
            }
        }
        return name;
    }

    public static String linetypeName(cib.util.dxf.Attributes atts) {
        String name = atts.getValue(GroupCode.GC6, null);
        if (name != null && name.compareToIgnoreCase("Continuous") == 0) {
            name = null;
        }
        return name;
    }

    public static String lineweightName(cib.util.dxf.Attributes atts, boolean define) {
        AttributeManager atm = AttributeManager.getAttributeManager();
        String name = null;
        int lineweightEnum = atts.getIntValue(GroupCode.GC370, -1);
        if (lineweightEnum >= 0) {
            double width = (double)lineweightEnum / 100.0;
            name = "LW_" + Long.toString(Math.round(width * 100.0));
            if (define && !atm.containsLineWidth(name)) {
                atm.addLineWidth(name, width);
            }
        }
        return name;
    }

    public static String visibilityName(boolean isVisible, boolean define) {
        String name2;
        AttributeManager atm = AttributeManager.getAttributeManager();
        Set<String> visibilities = atm.getVisibilities();
        for (String name2 : visibilities) {
            if (atm.getVisibility(name2) != isVisible) continue;
            return name2;
        }
        name2 = isVisible ? "visible" : "invisible";
        atm.addVisibility(name2, isVisible);
        return name2;
    }
}

