/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentGroup;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.ComponentPlacementDialog;
import cib.cad.kernel.interpreter.CmdLineInterpreter;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.TokenMgrError;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.binding.DefaultBindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdMgr;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AddMacroCell
implements Cmd {
    private ComponentGroup m_group = null;
    private Map<Component, String> m_compNames = new HashMap<Component, String>();
    private Map<Component, Layer> m_compLayers = new HashMap<Component, Layer>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        ObservableSet<Component> cmpSet;
        Database db;
        HashSet<Component> compsAdded;
        File file;
        block20: {
            CmdMgr svCmdMgr;
            ObservableSet.Listener<Component> osl;
            Kernel krnl;
            block19: {
                krnl = (Kernel)context;
                UserInterface ui = krnl.getUserInterface();
                file = krnl.readFile(new Kernel.FileDialogConfiguration(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String fileName = f.getName();
                        if (!fileName.endsWith(".cademia_macro")) {
                            return false;
                        }
                        if (!f.exists()) {
                            System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.AddMacroCell.1"));
                            return false;
                        }
                        if (!f.canRead()) {
                            System.err.println(String.valueOf(Messages.getString("kernel.cmds.AddMacroCell.2")) + f.getAbsolutePath());
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String[] getExtensions() {
                        return new String[]{"cademia_macro"};
                    }

                    @Override
                    public String getPrompt() {
                        return Messages.getString("kernel.cmds.AddMacroCell.3");
                    }

                    @Override
                    public String getFileFormatDescription() {
                        return String.valueOf(Messages.getString("kernel.cmds.AddMacroCell.4")) + " (*." + "cademia_macro" + ")";
                    }

                    @Override
                    public File getCurrentDirectory() {
                        String dir = krnl.getProperty("Kernel.DialogSCRIPT-files (*.cademia_macro)");
                        if (dir != null) {
                            return new File(dir);
                        }
                        return krnl.getUserDir("/files/cells");
                    }
                });
                compsAdded = new HashSet<Component>();
                db = krnl.getDatabase();
                cmpSet = db.getComponentSet();
                osl = new ObservableSet.Listener<Component>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void wasAdded(Component comp) {
                        compsAdded.add(comp);
                    }

                    @Override
                    public void wasRemoved(Component comp) {
                        compsAdded.remove(comp);
                    }

                    @Override
                    public void wasCloned(Component src, Component dst) {
                        compsAdded.add(dst);
                    }
                };
                svCmdMgr = krnl.getCmdMgr();
                try {
                    CmdLineInterpreter interpreter = new CmdLineInterpreter(System.in);
                    interpreter.addListener(new CmdLineInterpreter.Listener(){
                        private String m_cmdName = null;
                        private String m_args = "";

                        @Override
                        public void parsingCommand(String cmdName) {
                            this.m_cmdName = cmdName;
                            this.m_args = " ";
                        }

                        @Override
                        public void parsingArgument(String arg) {
                            this.m_args = String.valueOf(this.m_args) + arg + " ";
                        }

                        @Override
                        public void parsingEndOfCommand() {
                            krnl.doCmd(this.m_cmdName, this.m_args);
                        }
                    });
                    cmpSet.addListener(osl);
                    CmdMgr ignorableCmdsMgr = new CmdMgr();
                    krnl.setCmdMgr(ignorableCmdsMgr);
                    interpreter.ReInit(new FileInputStream(file));
                    try {
                        ui.enableDrawing(false);
                        interpreter.start();
                    }
                    catch (TokenMgrError e) {
                        System.err.println(e);
                        ui.enableDrawing(true);
                        break block19;
                    }
                    catch (ParseException e) {
                        try {
                            System.err.println(e);
                            break block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ui.enableDrawing(true);
                        }
                    }
                    ui.enableDrawing(true);
                }
                catch (FileNotFoundException e) {
                    System.err.println(String.valueOf(Messages.getString("kernel.cmds.AddMacroCell.14")) + file + Messages.getString("kernel.cmds.AddMacroCell.15"));
                    cmpSet.removeListener(osl);
                    krnl.setCmdMgr(svCmdMgr);
                    break block20;
                }
                catch (Exception e) {
                    try {
                        System.err.println(Messages.getString("kernel.cmds.AddMacroCell.16"));
                        e.printStackTrace();
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        cmpSet.removeListener(osl);
                        krnl.setCmdMgr(svCmdMgr);
                    }
                }
            }
            cmpSet.removeListener(osl);
            krnl.setCmdMgr(svCmdMgr);
        }
        if (!compsAdded.isEmpty()) {
            NameSpace nameSpace = db.getNameSpace();
            ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
            for (Component comp : compsAdded) {
                this.m_compNames.put(comp, nameSpace.getName(comp));
                this.m_compLayers.put(comp, (Layer)lm.get(comp));
            }
            AttributeManager am = AttributeManager.getAttributeManager();
            Attributes defAttributes = am.getDefaultAttributes();
            Attributes groupAttributes = new Attributes();
            groupAttributes.setVisibility(defAttributes.getVisibility());
            this.m_group = new ComponentGroup(compsAdded, new DefaultBindingModel<Component>());
            this.m_group.setConfiguration(1);
            this.m_group.setAttributes(groupAttributes);
            cmpSet.removeAll(compsAdded);
            cmpSet.add(this.m_group);
            ObservableSet<Component> comps = this.m_group.getComponentSet();
            for (Component comp : comps) {
                nameSpace.put(comp, this.m_compNames.get(comp));
                lm.put(comp, this.m_compLayers.get(comp));
            }
            try {
                ComponentPlacementDialog dlg = new ComponentPlacementDialog(this.m_group);
                dlg.start();
            }
            catch (CmdAbortedException e) {
                cmpSet.remove(this.m_group);
                throw e;
            }
            this.m_toString = String.valueOf(Messages.getString("kernel.cmds.AddMacroCell.18")) + file.getName() + Messages.getString("kernel.cmds.AddMacroCell.19");
        }
    }

    @Override
    public void undoCmd(Object context) {
        if (this.m_group == null) {
            return;
        }
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_group);
    }

    @Override
    public void redoCmd(Object context) {
        if (this.m_group == null) {
            return;
        }
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_group);
        NameSpace nameSpace = db.getNameSpace();
        ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
        ObservableSet<Component> comps = this.m_group.getComponentSet();
        for (Component comp : comps) {
            nameSpace.put(comp, this.m_compNames.get(comp));
            lm.put(comp, this.m_compLayers.get(comp));
        }
    }

    @Override
    public boolean changesState() {
        return this.m_group != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString != null ? this.m_toString : super.toString();
    }
}

