/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.StoreAs;
import cib.cad.kernel.cmds.WinFit;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;

public class Load
implements Cmd {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final String[] EXT = new String[]{"cademia".toLowerCase(), "cademia".toUpperCase()};
        if (krnl.databaseChanged() && krnl.readYesNo(Messages.getString("kernel.cmds.Load.0"), 2)) {
            StoreAs storeCmd = new StoreAs();
            storeCmd.doCmd(krnl);
        }
        File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName();
                if (!fileName.endsWith("." + EXT[0]) && !fileName.endsWith("." + EXT[1])) {
                    return false;
                }
                if (!f.exists()) {
                    System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.Load.3"));
                    return false;
                }
                if (!f.canRead()) {
                    System.err.println(String.valueOf(Messages.getString("kernel.cmds.Load.4")) + f.getAbsolutePath());
                    return false;
                }
                return true;
            }

            @Override
            public String[] getExtensions() {
                return EXT;
            }

            @Override
            public String getPrompt() {
                return Messages.getString("kernel.cmds.Load.5");
            }

            @Override
            public String getFileFormatDescription() {
                return String.valueOf(Messages.getString("kernel.cmds.Load.6")) + " (*." + EXT[0] + ", *." + EXT[1] + ")";
            }
        });
        try {
            Kernel.DatabaseInputStream in = new Kernel.DatabaseInputStream(new FileInputStream(file));
            krnl.loadDatabase(in);
        }
        catch (IOException e) {
            System.err.println(e);
            return;
        }
        catch (ClassNotFoundException e) {
            String msg = String.valueOf(Messages.getString("kernel.cmds.Load.10")) + e.getMessage() + Messages.getString("kernel.cmds.Load.11");
            krnl.readOK(Messages.getString("kernel.cmds.Load.12"), Messages.getString("kernel.cmds.Load.13"), msg, 14);
            return;
        }
        krnl.setDatabasePathname(file.getAbsolutePath());
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)it.next();
            Rectangle2D rectangle = drawPanel.getViewBounds();
            if (rectangle == null) continue;
            WinFit.zoom(drawPanel, rectangle);
        }
        System.out.println(String.valueOf(Messages.getString("kernel.cmds.Load.14")) + file.getAbsolutePath() + Messages.getString("kernel.cmds.Load.15"));
    }

    @Override
    public void undoCmd(Object context) {
    }

    @Override
    public void redoCmd(Object context) {
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }
}

