/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.RemoveControlPoints;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Remove
implements Cmd {
    private boolean m_changesState = false;
    private String m_toString = null;
    private static Set<Listener> s_listeners = new HashSet<Listener>();
    private Map<Component, Layer> m_layers = new HashMap<Component, Layer>();
    private Map<Component, String> m_names = new HashMap<Component, String>();
    private Set<Component> m_removedObjects = new HashSet<Component>();
    private Map<Component, Binding<Component>> m_affectedBindingMap = new HashMap<Component, Binding<Component>>();
    private Map<Component, Binding<Component>> m_clonedAffectedBindingMap = new HashMap<Component, Binding<Component>>();
    private RemoveControlPoints m_removeControlPoints = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        NameSpace ns = db.getNameSpace();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        if (selSet.isEmpty()) {
            System.out.println(Messages.getString("kernel.cmds.Remove.0"));
            return;
        }
        this._notifyPreDoRemove();
        if (selSet.isEmpty()) {
            this.m_toString = Messages.getString("kernel.cmds.Remove.0a");
        } else {
            this.m_changesState = true;
            MarkerMap mm = db.getMarkerMap();
            HashSet<Component> compsSelectedAsWhole = new HashSet<Component>();
            for (Component comp : selSet) {
                if (mm.hasMarkedPrimitives(comp, 2)) continue;
                compsSelectedAsWhole.add(comp);
            }
            this.m_removeControlPoints = new RemoveControlPoints();
            this.m_removeControlPoints.doCmd(context);
            if (!compsSelectedAsWhole.isEmpty()) {
                this.m_removedObjects.addAll(compsSelectedAsWhole);
                for (Component c : compsSelectedAsWhole) {
                    this.m_layers.put(c, (Layer)layerMap.get(c));
                    if (!(c instanceof Group)) continue;
                    this.deepSaveLayers(((Group)c).getComponentSet(), layerMap);
                }
                for (Component c : compsSelectedAsWhole) {
                    this.m_names.put(c, ns.getName(c));
                    if (!(c instanceof Group)) continue;
                    this.deepSaveNames(((Group)c).getComponentSet(), ns);
                }
                selSet.removeAll(compsSelectedAsWhole);
                cmpSet.removeAll(compsSelectedAsWhole);
                this.deepRemoveNames(ns, compsSelectedAsWhole);
                this.deepRemoveLayers(layerMap, compsSelectedAsWhole);
            }
            BindingModel<Component> bindingModel = db.getBindingModel();
            Set entrySet = bindingModel.entrySet();
            for (Map.Entry entry : entrySet) {
                Component c = (Component)entry.getKey();
                Binding b = (Binding)entry.getValue();
                if (this.m_removedObjects.contains(c) || selSet.contains(c)) {
                    this.m_affectedBindingMap.put(c, b);
                    this.m_clonedAffectedBindingMap.put(c, (Binding)b.clone());
                    continue;
                }
                for (Component d : b.getBindingObjects()) {
                    if (!this.m_removedObjects.contains(d) && !selSet.contains(d)) continue;
                    this.m_affectedBindingMap.put(c, b);
                    this.m_clonedAffectedBindingMap.put(c, (Binding)b.clone());
                }
            }
            this.m_toString = this.m_removedObjects.size() == 0 ? String.valueOf(Messages.getString("kernel.cmds.Remove.1")) + this.m_removeControlPoints.getNumberOfRemovedControlPoints() + Messages.getString("kernel.cmds.Remove.2") + this.m_removeControlPoints.getNumberOfComponentsWithRemovedControlPoints() + Messages.getString("kernel.cmds.Remove.3") : (this.m_removeControlPoints.getNumberOfComponentsWithRemovedControlPoints() == 0 ? String.valueOf(Messages.getString("kernel.cmds.Remove.4")) + this.m_removedObjects.size() + Messages.getString("kernel.cmds.Remove.5") : String.valueOf(Messages.getString("kernel.cmds.Remove.6")) + this.m_removedObjects.size() + Messages.getString("kernel.cmds.Remove.7") + this.m_removeControlPoints.getNumberOfRemovedControlPoints() + Messages.getString("kernel.cmds.Remove.8") + this.m_removeControlPoints.getNumberOfComponentsWithRemovedControlPoints() + Messages.getString("kernel.cmds.Remove.9"));
        }
        this._notifyPostDoRemove();
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        NameSpace ns = db.getNameSpace();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        Set<Component> set = this.m_names.keySet();
        for (Component c : set) {
            ns.put(c, this.m_names.get(c));
        }
        cmpSet.addAll(this.m_removedObjects);
        selSet.addAll(this.m_removedObjects);
        set = this.m_layers.keySet();
        for (Component c : set) {
            layerMap.put(c, this.m_layers.get(c));
        }
        BindingModel<Component> bindingModel = db.getBindingModel();
        bindingModel.putAll(this.m_clonedAffectedBindingMap);
        if (this.m_removeControlPoints != null) {
            this.m_removeControlPoints.undoCmd(context);
        }
        this._notifyPostUndoRemove();
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        if (this.m_removeControlPoints != null) {
            this.m_removeControlPoints.redoCmd(context);
        }
        cmpSet.removeAll(this.m_removedObjects);
        BindingModel<Component> bindingModel = db.getBindingModel();
        bindingModel.putAll(this.m_affectedBindingMap);
        this._notifyPostRedoRemove();
    }

    @Override
    public boolean changesState() {
        return this.m_changesState || this.m_removeControlPoints != null && this.m_removeControlPoints.changesState();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _notifyPreDoRemove() {
        for (Listener l : s_listeners) {
            l.preDoRemove(this);
        }
    }

    private void _notifyPostDoRemove() {
        for (Listener l : s_listeners) {
            l.postDoRemove(this);
        }
    }

    private void _notifyPostUndoRemove() {
        for (Listener l : s_listeners) {
            l.postUndoRemove(this);
        }
    }

    private void _notifyPostRedoRemove() {
        for (Listener l : s_listeners) {
            l.postRedoRemove(this);
        }
    }

    public static boolean addListener(Listener l) {
        return s_listeners.add(l);
    }

    public static boolean removeListener(Listener l) {
        return s_listeners.remove(l);
    }

    private void deepRemoveNames(NameSpace ns, Set<Component> set) {
        for (Component comp : set) {
            ns.remove(comp);
            if (!(comp instanceof Group)) continue;
            this.deepRemoveNames(ns, ((Group)comp).getComponentSet());
        }
    }

    private void deepRemoveLayers(ReverseAccessMap<Component, Layer> layerMap, Set<Component> set) {
        for (Component comp : set) {
            layerMap.remove(comp);
            if (!(comp instanceof Group)) continue;
            this.deepRemoveLayers(layerMap, ((Group)comp).getComponentSet());
        }
    }

    private void deepSaveNames(Set<Component> set, NameSpace ns) {
        for (Component comp : set) {
            this.m_names.put(comp, ns.getName(comp));
            if (!(comp instanceof Group)) continue;
            this.deepSaveNames(((Group)comp).getComponentSet(), ns);
        }
    }

    private void deepSaveLayers(Set<Component> set, ReverseAccessMap<Component, Layer> lm) {
        for (Component comp : set) {
            this.m_layers.put(comp, (Layer)lm.get(comp));
            if (!(comp instanceof Group)) continue;
            this.deepSaveLayers(((Group)comp).getComponentSet(), lm);
        }
    }

    public static interface Listener {
        public void preDoRemove(Remove var1);

        public void postDoRemove(Remove var1);

        public void postUndoRemove(Remove var1);

        public void postRedoRemove(Remove var1);
    }
}

