/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.ViewController;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.view.Projection2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WinFit
implements Cmd {
    private Map<DrawPanel, Projection2D> m_drawPanelProjections = new HashMap<DrawPanel, Projection2D>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        UserInterface ui = krnl.getUserInterface();
        int winMask = krnl.readWindowIds(Messages.getString("kernel.cmds.WinFit.0"));
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            Rectangle2D rectangle;
            DrawPanel drawPanel = (DrawPanel)it.next();
            if ((drawPanel.getId() & winMask) == 0) continue;
            this.m_drawPanelProjections.put(drawPanel, drawPanel.getProjection());
            Rectangle2D rectangle2D = rectangle = selSet.isEmpty() ? drawPanel.getViewBounds() : WinFit._getBounds(selSet, drawPanel);
            if (rectangle == null) continue;
            WinFit.zoom(drawPanel, rectangle);
        }
        this.m_toString = Messages.getString("kernel.cmds.WinFit.1");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Set<DrawPanel> set = this.m_drawPanelProjections.keySet();
        for (DrawPanel drawPanel : set) {
            Projection2D projection = this.m_drawPanelProjections.get(drawPanel);
            this.m_drawPanelProjections.put(drawPanel, drawPanel.getProjection());
            drawPanel.setProjection(projection);
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_drawPanelProjections.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private static Rectangle2D _getBounds(Set<Component> set, GeometryPanel gp) {
        Component comp;
        ViewController vc;
        Rectangle2D bounds = null;
        Iterator<Component> it = set.iterator();
        if (it.hasNext() && (vc = gp.getViewController(comp = it.next())) != null) {
            bounds = vc.getRawBounds();
        }
        while (it.hasNext()) {
            comp = it.next();
            vc = gp.getViewController(comp);
            if (vc == null) continue;
            bounds.add(vc.getRawBounds());
        }
        return bounds;
    }

    public static void zoom(DrawPanel drawPanel, Rectangle2D viewPort) {
        Projection2D projection = drawPanel.getProjection();
        AffineTransform v2m = projection.getViewToModel();
        Point2D p1 = v2m.transform(new Point2D.Double(viewPort.getMinX(), viewPort.getMinY()), null);
        Point2D p2 = v2m.transform(new Point2D.Double(viewPort.getMaxX(), viewPort.getMaxY()), null);
        viewPort.setFrameFromDiagonal(p1, p2);
        if (!projection.setViewPort(viewPort)) {
            System.out.println(Messages.getString("kernel.cmds.WinFit.2"));
            return;
        }
        drawPanel.setProjection(projection);
    }
}

